<?php

defined('BASEPATH') or exit('No direct script access allowed');

$dimensions = $pdf->getPageDimensions();

// Header with company info
$html = '<div style="text-align: center; background-color: #3498db; color: white; padding: 15px; margin-bottom: 20px;">';
$html .= '<h1 style="margin: 0; font-size: 24px; font-weight: bold;">📊 Staff Activity Report</h1>';
$html .= '<h3 style="margin: 5px 0; font-size: 14px;">' . get_option('companyname') . '</h3>';
$html .= '<p style="margin: 5px 0; font-size: 11px;">Generated on ' . date('F j, Y \a\t g:i A') . '</p>';
$html .= '</div>';

// Report Period
$dateFrom = isset($filters['from']) ? $filters['from'] : date('Y-m-01');
$dateTo = isset($filters['to']) ? $filters['to'] : date('Y-m-d');
$html .= '<div style="background-color: #ecf0f1; padding: 10px; margin-bottom: 15px; text-align: center;">';
$html .= '<p style="margin: 0; font-size: 12px; font-weight: bold; color: #2c3e50;">📅 Report Period: ' . date('M j, Y', strtotime($dateFrom)) . ' to ' . date('M j, Y', strtotime($dateTo)) . '</p>';
$html .= '</div>';

$pdf->writeHTML($html, true, false, false, false, '');

// KPI Summary Section
$html = '<h2 style="color: #2c3e50; border-bottom: 2px solid #3498db; padding-bottom: 5px; margin-bottom: 15px; font-size: 16px;">📊 Key Performance Indicators</h2>';

$html .= '<table style="width: 100%; border-collapse: collapse; margin-bottom: 15px; border: 1px solid #3498db;" cellpadding="10">';
$html .= '<thead>';
$html .= '<tr style="background-color: #3498db; color: white;">';
$html .= '<th style="text-align: center; font-size: 12px; padding: 10px;">Today\'s Activities</th>';
$html .= '<th style="text-align: center; font-size: 12px; padding: 10px;">This Week</th>';
$html .= '<th style="text-align: center; font-size: 12px; padding: 10px;">This Month</th>';
$html .= '<th style="text-align: center; font-size: 12px; padding: 10px;">Today\'s Logins</th>';
$html .= '</tr>';
$html .= '</thead>';
$html .= '<tbody>';
$html .= '<tr style="background-color: #ffffff;">';
$html .= '<td style="text-align: center; font-size: 14px; font-weight: bold; color: #27ae60; padding: 15px;">' . (int)$kpis['today'] . '</td>';
$html .= '<td style="text-align: center; font-size: 14px; font-weight: bold; color: #3498db; padding: 15px;">' . (int)$kpis['week'] . '</td>';
$html .= '<td style="text-align: center; font-size: 14px; font-weight: bold; color: #9b59b6; padding: 15px;">' . (int)$kpis['month'] . '</td>';
$html .= '<td style="text-align: center; font-size: 14px; font-weight: bold; color: #f39c12; padding: 15px;">' . (int)$kpis['logins_today'] . '</td>';
$html .= '</tr>';
$html .= '</tbody>';
$html .= '</table>';

$pdf->writeHTML($html, true, false, false, false, '');

// Top Active Staff Section
if (!empty($kpis['top_staff'])) {
    $html = '<h2 style="color: #2c3e50; border-bottom: 2px solid #f39c12; padding-bottom: 5px; margin-bottom: 15px; font-size: 16px;">🏆 Top Active Staff</h2>';
    
    $html .= '<table style="width: 100%; border-collapse: collapse; margin-bottom: 15px; border: 1px solid #f39c12;" cellpadding="8">';
    $html .= '<thead>';
    $html .= '<tr style="background-color: #f39c12; color: white;">';
    $html .= '<th style="text-align: left; font-size: 12px; padding: 10px;">Staff Member</th>';
    $html .= '<th style="text-align: center; font-size: 12px; padding: 10px;">Total Activities</th>';
    $html .= '<th style="text-align: center; font-size: 12px; padding: 10px;">Activity Score</th>';
    $html .= '</tr>';
    $html .= '</thead>';
    $html .= '<tbody>';
    
    $rank = 1;
    foreach (array_slice($kpis['top_staff'], 0, 5) as $staff) { // Top 5 staff
        $score = min(100, ($staff['total'] / max(1, $kpis['month'])) * 100); // Calculate percentage score
        
        $html .= '<tr style="background-color: ' . ($rank % 2 == 0 ? '#f9f9f9' : '#ffffff') . ';">';
        $html .= '<td style="font-size: 11px; font-weight: bold; padding: 8px;">#' . $rank . ' ' . e($staff['staff_name']) . '</td>';
        $html .= '<td style="text-align: center; font-size: 11px; color: #3498db; font-weight: bold; padding: 8px;">' . (int)$staff['total'] . '</td>';
        $html .= '<td style="text-align: center; font-size: 11px; color: #27ae60; font-weight: bold; padding: 8px;">' . number_format($score, 1) . '%</td>';
        $html .= '</tr>';
        $rank++;
    }
    
    $html .= '</tbody>';
    $html .= '</table>';
    
    $pdf->writeHTML($html, true, false, false, false, '');
}

// Activity Summary by Type
if (!empty($activity_types['chart_data']['labels'])) {
    $html = '<h2 style="color: #2c3e50; border-bottom: 2px solid #9b59b6; padding-bottom: 5px; margin-bottom: 15px; font-size: 16px;">📈 Activity Distribution</h2>';
    
    $html .= '<table style="width: 100%; border-collapse: collapse; margin-bottom: 15px; border: 1px solid #9b59b6;" cellpadding="8">';
    $html .= '<thead>';
    $html .= '<tr style="background-color: #9b59b6; color: white;">';
    $html .= '<th style="text-align: left; font-size: 12px; padding: 10px;">Activity Type</th>';
    $html .= '<th style="text-align: center; font-size: 12px; padding: 10px;">Count</th>';
    $html .= '<th style="text-align: center; font-size: 12px; padding: 10px;">Percentage</th>';
    $html .= '</tr>';
    $html .= '</thead>';
    $html .= '<tbody>';
    
    $total_activities = array_sum($activity_types['chart_data']['datasets'][0]['data']);
    
    for ($i = 0; $i < count($activity_types['chart_data']['labels']); $i++) {
        $count = $activity_types['chart_data']['datasets'][0]['data'][$i];
        $percentage = $total_activities > 0 ? ($count / $total_activities) * 100 : 0;
        
        $html .= '<tr style="background-color: ' . ($i % 2 == 0 ? '#f9f9f9' : '#ffffff') . ';">';
        $html .= '<td style="font-size: 11px; font-weight: bold; padding: 8px;">' . e($activity_types['chart_data']['labels'][$i]) . '</td>';
        $html .= '<td style="text-align: center; font-size: 11px; color: #9b59b6; font-weight: bold; padding: 8px;">' . (int)$count . '</td>';
        $html .= '<td style="text-align: center; font-size: 11px; color: #27ae60; font-weight: bold; padding: 8px;">' . number_format($percentage, 1) . '%</td>';
        $html .= '</tr>';
    }
    
    $html .= '</tbody>';
    $html .= '</table>';
    
    $pdf->writeHTML($html, true, false, false, false, '');
}

// Follow-up Types by Staff Section
if (!empty($followup_types['by_staff'])) {
    $html = '<h2 style="color: #2c3e50; border-bottom: 2px solid #1abc9c; padding-bottom: 5px; margin-bottom: 15px; font-size: 16px;">📞 Follow-up Types by Staff</h2>';
    
    // Ensure we have all types available - get from actual data first
    $allTypes = [];
    
    // First, collect all unique types from the data
    if (isset($followup_types['by_staff']) && !empty($followup_types['by_staff'])) {
        foreach ($followup_types['by_staff'] as $staffData) {
            if (is_array($staffData)) {
                $allTypes = array_merge($allTypes, array_keys($staffData));
            }
        }
        $allTypes = array_unique($allTypes);
    }
    
    // If no types found in data, use fallback
    if (empty($allTypes)) {
        $allTypes = ['Message', 'Phone Call', 'WhatsApp Call', 'WhatsApp Message', 'Reminder Created', 'Follow-up Added'];
    }
    
    $html .= '<table style="width: 100%; border-collapse: collapse; margin-bottom: 20px; border: 1px solid #1abc9c;" cellpadding="8" cellspacing="0">';
    
    // Header row
    $html .= '<thead>';
    $html .= '<tr style="background-color: #1abc9c; color: white;">';
    $html .= '<th style="text-align: left; font-size: 12px; font-weight: bold; padding: 10px; border: 1px solid #16a085;">Staff Member</th>';
    
    // Add column headers for each follow-up type
    foreach ($allTypes as $type) {
        $displayType = $type;
        // Clean up type names for better display
        $displayType = str_replace(['_', '-'], ' ', $displayType);
        $displayType = ucwords(strtolower($displayType));
        
        $html .= '<th style="text-align: center; font-size: 10px; font-weight: bold; padding: 8px 4px; border: 1px solid #16a085; max-width: 60px;">' . e($displayType) . '</th>';
    }
    $html .= '<th style="text-align: center; font-size: 12px; font-weight: bold; background-color: #16a085; padding: 10px; border: 1px solid #16a085;">TOTAL</th>';
    $html .= '</tr>';
    $html .= '</thead>';
    
    // Body rows
    $html .= '<tbody>';
    $row_count = 0;
    $columnTotals = array_fill(0, count($allTypes), 0);
    $grandTotal = 0;
    
    foreach ($followup_types['by_staff'] as $staffName => $followupData) {
        $row_count++;
        $rowTotal = 0;
        
        // Calculate row total
        foreach ($allTypes as $type) {
            $rowTotal += isset($followupData[$type]) ? $followupData[$type] : 0;
        }
        
        $html .= '<tr style="background-color: ' . ($row_count % 2 == 0 ? '#f9f9f9' : '#ffffff') . ';">';
        $html .= '<td style="font-size: 11px; font-weight: bold; color: #2c3e50; padding: 8px; border: 1px solid #ddd;">' . e($staffName) . '</td>';
        
        // Add data for each follow-up type
        $colIndex = 0;
        foreach ($allTypes as $type) {
            $count = isset($followupData[$type]) ? $followupData[$type] : 0;
            $columnTotals[$colIndex] += $count;
            
            if ($count > 0) {
                $html .= '<td style="text-align: center; padding: 6px; border: 1px solid #ddd; background-color: #e8f5e8; color: #27ae60; font-weight: bold; font-size: 10px;">' . $count . '</td>';
            } else {
                $html .= '<td style="text-align: center; padding: 6px; border: 1px solid #ddd; color: #999; font-size: 10px;">0</td>';
            }
            $colIndex++;
        }
        
        // Add total column
        $html .= '<td style="text-align: center; padding: 6px; border: 1px solid #ddd; background-color: #3498db; color: white; font-weight: bold; font-size: 11px;">' . $rowTotal . '</td>';
        $html .= '</tr>';
        
        $grandTotal += $rowTotal;
    }
    
    // Add totals row
    $html .= '<tr style="background-color: #34495e; color: white; font-weight: bold;">';
    $html .= '<td style="font-size: 11px; font-weight: bold; padding: 8px; border: 1px solid #2c3e50;">TOTALS</td>';
    
    foreach ($columnTotals as $total) {
        $html .= '<td style="text-align: center; padding: 6px; border: 1px solid #2c3e50; font-size: 10px;">' . $total . '</td>';
    }
    
    $html .= '<td style="text-align: center; padding: 6px; border: 1px solid #2c3e50; background-color: #e74c3c; font-size: 11px;">' . $grandTotal . '</td>';
    $html .= '</tr>';
    
    $html .= '</tbody>';
    $html .= '</table>';
    
    // Add summary statistics
    $html .= '<div style="background: linear-gradient(135deg, #ecf0f1 0%, #bdc3c7 100%); padding: 12px; border-left: 4px solid #1abc9c; margin-bottom: 20px; border-radius: 3px;">';
    $html .= '<h4 style="margin: 0 0 8px 0; color: #2c3e50; font-size: 13px; font-weight: bold;">📊 Follow-up Performance Summary</h4>';
    $html .= '<div style="font-size: 11px; color: #34495e; line-height: 1.4;">';
    $html .= '<span style="display: inline-block; margin-right: 20px;"><strong>Total Follow-ups:</strong> <span style="color: #1abc9c; font-weight: bold;">' . $grandTotal . '</span></span>';
    $html .= '<span style="display: inline-block; margin-right: 20px;"><strong>Active Staff:</strong> <span style="color: #3498db; font-weight: bold;">' . count($followup_types['by_staff']) . '</span></span>';
    $html .= '<span style="display: inline-block; margin-right: 20px;"><strong>Follow-up Types:</strong> <span style="color: #9b59b6; font-weight: bold;">' . count($followup_types['all_types']) . '</span></span>';
    
    // Find most active staff member
    $mostActiveStaff = '';
    $mostActiveCount = 0;
    foreach ($followup_types['by_staff'] as $staffName => $followupData) {
        $staffTotal = array_sum($followupData);
        if ($staffTotal > $mostActiveCount) {
            $mostActiveCount = $staffTotal;
            $mostActiveStaff = $staffName;
        }
    }
    
    if ($mostActiveStaff) {
        $html .= '<br><span style="display: inline-block; margin-top: 5px;"><strong>🏆 Top Performer:</strong> <span style="color: #e67e22; font-weight: bold;">' . e($mostActiveStaff) . '</span> <span style="color: #7f8c8d;">(' . $mostActiveCount . ' follow-ups)</span></span>';
    }
    
    $html .= '</div>';
    $html .= '</div>';
    
    $pdf->writeHTML($html, true, false, false, false, '');
}

// Start new page for detailed activity log
$pdf->AddPage();

// Detailed Activity Log
$html = '<h2 style="color: #2c3e50; border-bottom: 1px solid #bdc3c7; padding-bottom: 5px; font-size: 16px;">📋 Detailed Activity Log</h2>';
$html .= '<p style="color: #7f8c8d; font-size: 10px; margin-bottom: 10px;">Showing recent activities (limited to 100 entries for PDF)</p>';

if (!empty($activity_log['data'])) {
    $html .= '<table style="width: 100%; border-collapse: collapse; font-size: 9px;" border="1" cellpadding="5">';
    $html .= '<thead>';
    $html .= '<tr style="background-color: #34495e; color: white;">';
    $html .= '<th style="width: 15%; text-align: center;">Date & Time</th>';
    $html .= '<th style="width: 15%; text-align: center;">Staff</th>';
    $html .= '<th style="width: 20%; text-align: center;">Activity Type</th>';
    $html .= '<th style="width: 20%; text-align: center;">Related</th>';
    $html .= '<th style="width: 30%; text-align: center;">Description</th>';
    $html .= '</tr>';
    $html .= '</thead>';
    $html .= '<tbody>';
    
    $row_count = 0;
    foreach (array_slice($activity_log['data'], 0, 50) as $activity) { // Limit to 50 for better PDF formatting
        $row_count++;
        $html .= '<tr style="background-color: ' . ($row_count % 2 == 0 ? '#f8f9fa' : '#ffffff') . ';">';
        $html .= '<td style="text-align: center; font-size: 8px;">' . date('M j, Y<br/>g:i A', strtotime($activity['date'])) . '</td>';
        $html .= '<td style="text-align: center; font-size: 8px;">' . e($activity['staff_name']) . '</td>';
        $html .= '<td style="text-align: center; font-size: 8px;">' . e($activity['activity_type']) . '</td>';
        $html .= '<td style="text-align: center; font-size: 8px;">' . e($activity['related']) . '</td>';
        
        // Truncate description for PDF
        $description = strip_tags($activity['description']);
        $description = strlen($description) > 60 ? substr($description, 0, 60) . '...' : $description;
        $html .= '<td style="font-size: 8px;">' . e($description) . '</td>';
        $html .= '</tr>';
    }
    
    $html .= '</tbody>';
    $html .= '</table>';
} else {
    $html .= '<p style="text-align: center; color: #95a5a6; font-style: italic; padding: 20px;">No activity data found for the selected period.</p>';
}

$pdf->writeHTML($html, true, false, false, false, '');

// Footer section
$pdf->Ln(10);
$html = '<div style="border-top: 1px solid #bdc3c7; padding-top: 10px; text-align: center; color: #95a5a6; font-size: 10px;">';
$html .= '<p>This report was generated automatically by ' . get_option('companyname') . ' CRM System</p>';
$html .= '<p>Report generated on ' . date('F j, Y \a\t g:i A') . ' | Page {PAGENO} of {nb}</p>';
$html .= '</div>';

$pdf->writeHTML($html, true, false, false, false, '');

