<?php

defined('BASEPATH') or exit('No direct script access allowed');

hooks()->add_action('admin_init', function () {
    $CI = &get_instance();

    // Add under Reports menu
    if (is_admin() || staff_can('view', REPORTING_DASHBOARD_MODULE)) {
        // Newer Perfex uses app_menu->add_sidebar_children_item for nested items
        $CI->app_menu->add_sidebar_children_item('reports', [
            'slug'     => 'reporting_dashboard',
            'name'     => _l('Reporting Dashboard'),
            'href'     => admin_url('reporting_dashboard'),
            'position' => 50,
            'icon'     => 'fa fa-chart-line',
        ]);
    }
});

