<?php
// Simple database debug script for lead activity logs
define('BASEPATH', true);
require_once '../../application/config/database.php';
require_once '../../application/config/config.php';

// Database connection
$mysqli = new mysqli($db['default']['hostname'], $db['default']['username'], $db['default']['password'], $db['default']['database']);

if ($mysqli->connect_error) {
    die('Connection failed: ' . $mysqli->connect_error);
}

echo "<h2>Database Debug for Lead Activity Logs</h2>";

// Check if lead_activity_log table exists
$tables = ['tbllead_activity_log', 'tblactivitylog', 'tblleads'];
foreach ($tables as $table) {
    echo "<h3>Checking table: $table</h3>";
    $result = $mysqli->query("SHOW TABLES LIKE '$table'");
    if ($result && $result->num_rows > 0) {
        echo "<p style='color: green;'>✓ Table $table exists</p>";
        
        // Get table structure
        $structure = $mysqli->query("DESCRIBE $table");
        if ($structure) {
            echo "<h4>Table Structure:</h4>";
            echo "<table border='1'><tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
            while ($row = $structure->fetch_assoc()) {
                echo "<tr>";
                foreach ($row as $col) {
                    echo "<td>" . htmlspecialchars($col ?? '') . "</td>";
                }
                echo "</tr>";
            }
            echo "</table>";
        }
        
        // Get row count
        $count = $mysqli->query("SELECT COUNT(*) as cnt FROM $table");
        if ($count) {
            $countRow = $count->fetch_assoc();
            echo "<p><strong>Total rows: " . $countRow['cnt'] . "</strong></p>";
        }
        
        // Get sample data
        if ($table == 'tbllead_activity_log') {
            $sample = $mysqli->query("SELECT * FROM $table ORDER BY date DESC LIMIT 5");
            if ($sample && $sample->num_rows > 0) {
                echo "<h4>Sample Data (Latest 5 entries):</h4>";
                echo "<table border='1'>";
                $first = true;
                while ($row = $sample->fetch_assoc()) {
                    if ($first) {
                        echo "<tr>";
                        foreach (array_keys($row) as $col) {
                            echo "<th>" . htmlspecialchars($col) . "</th>";
                        }
                        echo "</tr>";
                        $first = false;
                    }
                    echo "<tr>";
                    foreach ($row as $val) {
                        echo "<td>" . htmlspecialchars($val ?? '') . "</td>";
                    }
                    echo "</tr>";
                }
                echo "</table>";
            } else {
                echo "<p style='color: red;'>No data found in $table</p>";
            }
        }
    } else {
        echo "<p style='color: red;'>✗ Table $table does not exist</p>";
    }
    echo "<hr>";
}

$mysqli->close();
?>

