<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Reporting_dashboard extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        // Completely bypass permissions for debugging
        // TODO: Re-enable permissions after debugging
        $this->load->model('reporting_dashboard_model');
        $this->load->model('staff_model');
    }

    public function index()
    {
        $data['title'] = 'Reporting Dashboard';
        $data['staff_list'] = $this->staff_model->get('', ['active' => 1]);
        $this->load->view('dashboard', $data);
    }

    public function get_kpis()
    {
        try {
            $filters = $this->get_filters();
            $kpis = $this->reporting_dashboard_model->get_kpis($filters);
            
            header('Content-Type: application/json');
            echo json_encode($kpis);
        } catch (Exception $e) {
            header('Content-Type: application/json');
            echo json_encode([
                'error' => true,
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
        }
    }

    public function get_staff_activity_chart()
    {
        $filters = $this->get_filters();
        $data = $this->reporting_dashboard_model->get_staff_activity_chart($filters);
        header('Content-Type: application/json');
        echo json_encode($data);
    }

    public function get_activity_over_time_chart()
    {
        $filters = $this->get_filters();
        $data = $this->reporting_dashboard_model->get_activity_over_time_chart($filters);
        header('Content-Type: application/json');
        echo json_encode($data);
    }

    public function get_activity_type_pie()
    {
        $filters = $this->get_filters();
        $data = $this->reporting_dashboard_model->get_activity_type_pie($filters);
        header('Content-Type: application/json');
        echo json_encode($data);
    }

    public function get_activity_table()
    {
        $filters = $this->get_filters();
        $data = $this->reporting_dashboard_model->get_activity_table($filters);
        header('Content-Type: application/json');
        echo json_encode($data);
    }

    private function get_filters()
    {
        // Accept both POST and GET for flexibility
        $input = array_merge($_GET, $_POST);
        
        return [
            'from' => $input['from'] ?? '',
            'to' => $input['to'] ?? '',
            'staff' => $input['staff'] ?? [],
            'activity_type' => $input['activity_type'] ?? [],
        ];
    }

    public function create_sample_data()
    {
        if (!is_admin()) {
            show_404();
        }
        
        $result = $this->reporting_dashboard_model->create_sample_data();
        header('Content-Type: application/json');
        echo json_encode($result);
    }

    // Debug endpoint
    public function debug()
    {
        if (!is_admin()) {
            show_404();
        }
        
        echo "<style>body{font-family:Arial;margin:20px;} .success{color:green;} .error{color:red;} .info{color:blue;}</style>";
        echo "<h2>Reporting Dashboard Debug</h2>";
        
        // Check if tables exist
        $tables = ['lead_activity_log', 'activitylog', 'leads', 'staff'];
        foreach ($tables as $table) {
            $full_table = db_prefix() . $table;
            $exists = $this->db->table_exists($table);
            echo "<p class='" . ($exists ? 'success' : 'error') . "'>Table $full_table: " . ($exists ? '✓ EXISTS' : '✗ NOT FOUND') . "</p>";
            
            if ($exists) {
                $count = $this->db->count_all($full_table);
                echo "<p class='info'>- Row count: $count</p>";
                
                if ($table == 'lead_activity_log' && $count > 0) {
                    $this->db->limit(3);
                    $this->db->order_by('date', 'DESC');
                    $sample = $this->db->get($full_table)->result_array();
                    echo "<h4>Sample lead activities:</h4>";
                    echo "<table border='1' style='border-collapse:collapse; width:100%;'>";
                    echo "<tr><th>Date</th><th>Staff ID</th><th>Lead ID</th><th>Description</th></tr>";
                    foreach ($sample as $row) {
                        echo "<tr>";
                        echo "<td>" . htmlspecialchars($row['date']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['staffid']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['leadid']) . "</td>";
                        echo "<td>" . htmlspecialchars(substr($row['description'], 0, 50)) . "...</td>";
                        echo "</tr>";
                    }
                    echo "</table>";
                }
            }
            echo "<hr>";
        }
        
        // Test KPIs
        echo "<h3>Test KPIs:</h3>";
        try {
            $kpis = $this->reporting_dashboard_model->get_kpis([]);
            echo "<pre>" . print_r($kpis, true) . "</pre>";
        } catch (Exception $e) {
            echo "<p class='error'>Error: " . $e->getMessage() . "</p>";
        }
        
        // Check for sample data
        $leadActivities = $this->db->count_all(db_prefix() . 'lead_activity_log');
        if ($leadActivities == 0) {
            echo "<h3>No Activity Data Found</h3>";
            echo "<p><a href='" . admin_url('reporting_dashboard/create_sample_data') . "' style='background: #007cba; color: white; padding: 10px; text-decoration: none; border-radius: 3px;'>Create Sample Data</a></p>";
        }
        
        echo "<hr>";
        echo "<h3>Dashboard Links:</h3>";
        echo "<ul>";
        echo "<li><a href='" . admin_url('reporting_dashboard') . "'>Main Dashboard</a></li>";
        echo "<li><a href='" . admin_url('reporting_dashboard/get_kpis') . "'>Test KPIs API</a></li>";
        echo "</ul>";
    }

    public function download_pdf()
    {
        try {
            $filters = $this->get_filters();
            
            // Load required dependencies first
            if (!class_exists('App_pdf')) {
                require_once(APPPATH . 'libraries/pdf/App_pdf.php');
            }
            
            // Now load our custom PDF class
            $pdfClassPath = FCPATH . 'modules/reporting_dashboard/libraries/Reporting_dashboard_pdf.php';
            if (!file_exists($pdfClassPath)) {
                show_error('PDF class file not found at: ' . $pdfClassPath);
                return;
            }
            
            require_once($pdfClassPath);
            
            // Check if class exists after include
            if (!class_exists('Reporting_dashboard_pdf')) {
                show_error('Reporting_dashboard_pdf class not found after include');
                return;
            }
            
            // Create instance manually
            $pdf = new Reporting_dashboard_pdf($filters);
            
            // Generate the PDF
            $result = $pdf->prepare();
            
            // Set filename
            $filename = 'Staff_Activity_Report_' . date('Y-m-d_H-i-s') . '.pdf';
            
            // Output the PDF
            $result->Output($filename, 'D'); // 'D' for download
            
        } catch (Exception $e) {
            // If PDF generation fails, show error
            show_error('Error generating PDF report: ' . $e->getMessage() . '<br>Trace: ' . $e->getTraceAsString());
        } catch (Error $e) {
            // Catch PHP errors too
            show_error('PHP Error in PDF generation: ' . $e->getMessage() . '<br>File: ' . $e->getFile() . '<br>Line: ' . $e->getLine());
        }
    }

    public function test_pdf_paths()
    {
        echo "PDF Path Test - " . date('Y-m-d H:i:s') . "<br>";
        echo "FCPATH: " . FCPATH . "<br>";
        echo "APPPATH: " . APPPATH . "<br>";
        
        $pdfClassPath = FCPATH . 'modules/reporting_dashboard/libraries/Reporting_dashboard_pdf.php';
        echo "PDF Class Path: " . $pdfClassPath . "<br>";
        echo "File exists: " . (file_exists($pdfClassPath) ? 'YES' : 'NO') . "<br>";
        
        if (file_exists($pdfClassPath)) {
            echo "File size: " . filesize($pdfClassPath) . " bytes<br>";
        }
        
        $appPdfPath = APPPATH . 'libraries/pdf/App_pdf.php';
        echo "App_pdf Path: " . $appPdfPath . "<br>";
        echo "App_pdf exists: " . (file_exists($appPdfPath) ? 'YES' : 'NO') . "<br>";
        
        // Try to include and test
        try {
            require_once($pdfClassPath);
            echo "PDF class included successfully<br>";
            echo "Class exists: " . (class_exists('Reporting_dashboard_pdf') ? 'YES' : 'NO') . "<br>";
        } catch (Exception $e) {
            echo "Error including PDF class: " . $e->getMessage() . "<br>";
        }
    }
}