<?php

defined('BASEPATH') or exit('No direct script access allowed');

// Register menu items on admin initialization
hooks()->add_action('admin_init', function () {
    $CI = &get_instance();

    // Only show to logged in staff
    if (!is_staff_logged_in()) {
        return;
    }

    // Add main reporting dashboard menu item
    $CI->app_menu->add_sidebar_menu_item('reporting_dashboard', [
        'slug'     => 'reporting_dashboard',
        'name'     => _l('Leads Reporting'),
        'href'     => admin_url('reporting_dashboard'),
        'position' => 2,
        'icon'     => 'fa fa-chart-bar',
    ]);
    
    // Add dashboard submenu item
    $CI->app_menu->add_sidebar_children_item('reporting_dashboard', [
        'slug'     => 'reporting_dashboard_main',
        'name'     => _l('Dashboard'), 
        'href'     => admin_url('reporting_dashboard'),
        'position' => 1,
        'icon'     => 'fa fa-chart-line',
    ]);
    
    // Add permissions submenu for admins only
    if (is_admin()) {
        $CI->app_menu->add_sidebar_children_item('reporting_dashboard', [
            'slug'     => 'reporting_dashboard_permissions',
            'name'     => _l('Permissions Management'), 
            'href'     => admin_url('reporting_dashboard/permissions'),
            'position' => 2,
            'icon'     => 'fa fa-lock',
        ]);
    }
});

