# Schedule Not Executing - Troubleshooting Guide

## Problem: Schedule Not Running After 3 Minutes

You created a schedule to run in 3 minutes, but it didn't execute. Here's why and how to fix it.

## Root Cause

**Perfex CRM schedules require server cron jobs to execute automatically.**

The schedule you created is stored in the database with a "next_run" time, but it won't execute on its own. Perfex CRM needs its cron job to run, which then triggers the schedule execution.

Think of it like this:
- ✅ Schedule = Alarm clock set for 3 minutes
- ❌ Cron = The electricity that powers the alarm
- Without cron running, the alarm (schedule) can't ring!

## Immediate Solution: Manual Testing

I've created two test scripts for you to manually trigger execution:

### Option 1: Test Schedule Execution (Recommended)
```
http://localhost/crm/test_schedule_execution.php
```

**What it does:**
- Shows all your schedules
- Identifies which ones are due to run
- Lets you manually execute them with one click
- Shows detailed execution logs
- Displays the WhatsApp message preview

**How to use:**
1. Open the URL above in your browser
2. Look for your schedule in the list
3. Click "EXECUTE ALL DUE SCHEDULES NOW" button
4. Watch the execution in real-time
5. Check logs in the dashboard

### Option 2: Trigger Cron Job
```
http://localhost/crm/trigger_cron.php
```

**What it does:**
- Manually triggers Perfex's cron system
- Executes all due schedules automatically
- Simpler but less detailed feedback

## Long-term Solution: Set Up Server Cron

For schedules to run automatically without manual intervention, you need to configure a server cron job.

### Step 1: Check Current Cron Status

1. Go to **Setup → Settings → Cron Job**
2. Check if "Cron Job Last Run" shows recent times
3. If it says "Never" or is very old, cron is NOT configured

### Step 2: Configure Server Cron

**You need server/hosting admin access for this step.**

#### For Linux/Unix Servers:

1. SSH into your server
2. Edit crontab:
   ```bash
   crontab -e
   ```

3. Add this line (choose ONE option):

   **Option A: Using PHP CLI**
   ```bash
   */5 * * * * php /path/to/crm/index.php misc/cron_job >/dev/null 2>&1
   ```

   **Option B: Using wget**
   ```bash
   */5 * * * * wget -q -O- http://localhost/crm/admin/misc/cron >/dev/null 2>&1
   ```

   **Option C: Using curl**
   ```bash
   */5 * * * * curl -s http://localhost/crm/admin/misc/cron >/dev/null 2>&1
   ```

4. Save and exit

**What `*/5 * * * *` means:**
- Runs every 5 minutes
- You can change to `*/1` for every minute (faster testing)
- Or `*/15` for every 15 minutes (production)

#### For Windows Servers:

1. Open **Task Scheduler**
2. Create new task:
   - **Name:** Perfex CRM Cron
   - **Trigger:** Repeat every 5 minutes
   - **Action:** Start a program
   - **Program:** `C:\xampp\php\php.exe`
   - **Arguments:** `C:\xampp\htdocs\crm\index.php misc/cron_job`

#### For cPanel/Plesk Hosting:

1. Log into your hosting control panel
2. Find **Cron Jobs** section
3. Add new cron job:
   - **Common Settings:** Every 5 minutes
   - **Command:** 
     ```
     php /home/username/public_html/crm/index.php misc/cron_job
     ```
   (Replace `/home/username/public_html/crm` with your actual path)

### Step 3: Verify Cron is Working

After configuring cron:

1. Wait 5 minutes
2. Go to **Setup → Settings → Cron Job**
3. Check "Cron Job Last Run" - should show current time
4. Go to **Reporting Dashboard → Manage Schedules**
5. Check if your schedule's "Last Run" updated

## Testing Your Schedule

### Method 1: Short Interval Test

1. **Create a test schedule:**
   - Name: "Cron Test"
   - Frequency: Daily
   - Time: Current time + 2 minutes
   - Add your WhatsApp number
   - Save

2. **Wait for cron to run** (max 5 minutes if cron is every 5 min)

3. **Check results:**
   - Go to Manage Schedules
   - Click blue icon (📄) next to "Cron Test"
   - Look for new log entry

### Method 2: Manual Execution Test

1. **Run test script:**
   ```
   http://localhost/crm/test_schedule_execution.php
   ```

2. **Execute your schedule manually**

3. **Check logs immediately**

## Common Issues and Fixes

### Issue 1: Schedule shows "DUE NOW" but won't execute

**Causes:**
- Cron not configured
- Cron not running frequently enough
- Schedule is paused

**Fix:**
1. Check if schedule is "Active" (green)
2. Run `test_schedule_execution.php` to force execution
3. Set up server cron (see above)

### Issue 2: Schedule executes but shows "Failed" status

**Causes:**
- No staff activity data for date range
- Invalid WhatsApp numbers
- Missing API credentials

**Fix:**
1. Click blue icon (📄) to view logs
2. Read error message in "Error / Notes" column
3. Common errors:
   - "No staff activity data" → Adjust date range in schedule
   - "No WhatsApp numbers" → Add recipients
   - WhatsApp API error → Check credentials in AutographFeedbackInsights module

### Issue 3: Report generated but WhatsApp failed (Partial status)

**Causes:**
- Invalid phone number format
- WhatsApp API credentials issue
- Network problem

**Fix:**
1. Verify numbers are in international format: `+1234567890`
2. Check WhatsApp API settings in AutographFeedbackInsights
3. Test WhatsApp API separately

### Issue 4: "Next Run" time keeps resetting to future

**This is NORMAL behavior:**
- After execution, "Next Run" automatically calculates next time
- Daily schedule: +1 day
- Weekly schedule: +7 days
- Monthly schedule: +1 month

## Verification Checklist

Use this checklist to verify everything is working:

- [ ] Schedule created and shows "Active" status
- [ ] Schedule has WhatsApp numbers configured
- [ ] Schedule has staff members selected (or "all")
- [ ] "Next Run" time is set and in the past/present
- [ ] Server cron job is configured
- [ ] Perfex "Cron Job Last Run" shows recent time
- [ ] Manual test script successfully executes schedule
- [ ] Logs show execution with "Success" or "Partial" status
- [ ] WhatsApp message received on test number

## Quick Test Command Summary

**Test everything now:**
1. Open: `http://localhost/crm/test_schedule_execution.php`
2. Click "EXECUTE ALL DUE SCHEDULES NOW"
3. Wait for results
4. Check logs in dashboard
5. Check WhatsApp for message

**Just trigger cron:**
1. Open: `http://localhost/crm/trigger_cron.php`
2. Check logs in dashboard

## Understanding Schedule Timing

### How "Next Run" is Calculated:

**Daily Schedule at 10:00 AM:**
- First run: Today at 10:00 AM (if created before 10 AM)
- Next run: Tomorrow at 10:00 AM
- Pattern: Same time every day

**Weekly Schedule on Monday at 9:00 AM:**
- First run: Next Monday at 9:00 AM
- Next run: Following Monday at 9:00 AM
- Pattern: Same day/time every week

**Monthly Schedule on 1st at 8:00 AM:**
- First run: 1st of next month at 8:00 AM
- Next run: 1st of month after at 8:00 AM
- Pattern: Same day of month, same time

### Important Notes:

1. **Schedule won't execute in the past:**
   - If you set "Daily at 10 AM" and it's already 11 AM
   - First run: Tomorrow at 10 AM
   - NOT: Today at 10 AM (missed)

2. **Execution window:**
   - Schedule executes when: `current_time >= next_run_time`
   - If cron runs every 5 minutes, execution can be up to 5 minutes late
   - Example: Schedule due at 10:00, cron runs at 10:03 → executes at 10:03

3. **Timezone:**
   - Uses server timezone
   - Check: **Setup → Settings → General → Default Timezone**

## For Developers: Debug Queries

If you have database access, check these:

**See all schedules:**
```sql
SELECT * FROM tblreporting_dashboard_staff_report_schedules 
WHERE active = 1;
```

**See due schedules:**
```sql
SELECT * FROM tblreporting_dashboard_staff_report_schedules 
WHERE active = 1 
AND next_run <= NOW();
```

**See recent execution logs:**
```sql
SELECT * FROM tblreporting_dashboard_schedule_logs 
ORDER BY execution_time DESC 
LIMIT 10;
```

**Check cron last run:**
```sql
SELECT * FROM tbloptions 
WHERE name = 'last_cron_run';
```

## Get Help

If schedules still won't execute after following this guide:

1. **Run test script** and save the output
2. **Check logs** and screenshot any errors
3. **Verify cron** in Setup → Settings → Cron Job
4. **Check server logs** for PHP errors
5. **Contact support** with:
   - Schedule configuration (frequency, time)
   - Cron configuration status
   - Error messages from logs
   - Test script output

## Security Reminder

**After testing, DELETE these files:**
- `test_schedule_execution.php`
- `trigger_cron.php`

These files should NOT remain on production servers as they bypass normal security.

---

## Quick Fix Summary

**Can't wait for cron setup? Use this now:**

1. Visit: `http://localhost/crm/test_schedule_execution.php`
2. Click: "EXECUTE ALL DUE SCHEDULES NOW"
3. Done! Check your WhatsApp.

**For permanent solution:**
- Set up server cron (see "Long-term Solution" above)
- Schedules will then run automatically every 5 minutes

---

**Last Updated:** November 15, 2025

