<?php
echo "<h1>Template File Direct Test</h1>";

$template_file = 'application/views/admin/leads/_notes_template.php';

echo "<h2>File Contents Preview (first 500 chars):</h2>";
if (file_exists($template_file)) {
    $content = file_get_contents($template_file);
    echo "<pre>" . htmlspecialchars(substr($content, 0, 500)) . "...</pre>";
    
    echo "<h2>File Statistics:</h2>";
    echo "<p>File size: " . strlen($content) . " bytes</p>";
    echo "<p>Lines: " . substr_count($content, "\n") . "</p>";
    echo "<p>Contains 'v5.0': " . (strpos($content, 'v5.0') !== false ? 'YES' : 'NO') . "</p>";
    echo "<p>Contains alert: " . (strpos($content, 'alert') !== false ? 'YES' : 'NO') . "</p>";
} else {
    echo "<p style='color: red;'>Template file not found!</p>";
}

echo "<h2>Search for other notes templates:</h2>";
$files = glob('application/views/**/leads/*notes*.php', GLOB_BRACE);
foreach ($files as $file) {
    echo "<p>" . $file . " (modified: " . date('Y-m-d H:i:s', filemtime($file)) . ")</p>";
}
?>
