<?php
// This is a temporary file to add to the Leads controller

public function check_phone_exists()
{
    if (!is_staff_member()) {
        ajax_access_denied();
    }

    $phone = $this->input->post('phone');
    if (empty($phone)) {
        echo json_encode(['exists' => false]);
        return;
    }

    $exclude_id = $this->input->post('lead_id') ?: null;
    
    // Clean the phone number (remove spaces, dashes, etc.)
    $phone = preg_replace('/\D/', '', $phone);
    
    // Check primary phone number
    $this->db->select(db_prefix() . 'leads.id, ' . db_prefix() . 'leads.name, ' . db_prefix() . 'leads.email, ' . 
                    db_prefix() . 'leads.phonenumber, ' . db_prefix() . 'leads.company, ' . 
                    db_prefix() . 'leads_status.name as status_name');
    $this->db->join(db_prefix() . 'leads_status', db_prefix() . 'leads_status.id=' . db_prefix() . 'leads.status', 'left');
    $this->db->where("REPLACE(REPLACE(REPLACE(REPLACE(phonenumber, ' ', ''), '-', ''), '(', ''), ')', '') = ", $phone);
    
    if ($exclude_id) {
        $this->db->where(db_prefix() . 'leads.id !=', $exclude_id);
    }
    
    $result = $this->db->get(db_prefix() . 'leads')->row();
    
    if ($result) {
        // Found in primary phone
        echo json_encode([
            'exists' => true,
            'lead' => [
                'id' => $result->id,
                'name' => $result->name,
                'email' => $result->email,
                'phone' => $result->phonenumber,
                'company' => $result->company,
                'status' => $result->status_name
            ]
        ]);
        return;
    }
    
    // Check additional phone numbers (stored as JSON in phone_numbers column)
    $this->db->select(db_prefix() . 'leads.id, ' . db_prefix() . 'leads.name, ' . db_prefix() . 'leads.email, ' . 
                    db_prefix() . 'leads.phonenumber, ' . db_prefix() . 'leads.company, ' . db_prefix() . 'leads.phone_numbers, ' .
                    db_prefix() . 'leads_status.name as status_name');
    $this->db->join(db_prefix() . 'leads_status', db_prefix() . 'leads_status.id=' . db_prefix() . 'leads.status', 'left');
    $this->db->where('phone_numbers IS NOT NULL');
    
    if ($exclude_id) {
        $this->db->where(db_prefix() . 'leads.id !=', $exclude_id);
    }
    
    $leads_with_additional = $this->db->get(db_prefix() . 'leads')->result();
    
    foreach ($leads_with_additional as $lead) {
        $additional_numbers = json_decode($lead->phone_numbers, true);
        if (!is_array($additional_numbers)) {
            continue;
        }
        
        foreach ($additional_numbers as $additional_phone) {
            $clean_additional = preg_replace('/\D/', '', $additional_phone);
            if ($clean_additional === $phone) {
                // Found in additional phones
                echo json_encode([
                    'exists' => true,
                    'lead' => [
                        'id' => $lead->id,
                        'name' => $lead->name,
                        'email' => $lead->email,
                        'phone' => $additional_phone . ' (additional)',
                        'company' => $lead->company,
                        'status' => $lead->status_name
                    ]
                ]);
                return;
            }
        }
    }
    
    // Phone number doesn't exist
    echo json_encode(['exists' => false]);
}
?>
