<?php

defined('BASEPATH') or exit('No direct script access allowed');

// Include App_pdf from the correct path
require_once(APPPATH . 'libraries/pdf/App_pdf.php');

class Reporting_dashboard_pdf extends App_pdf
{
    protected $filters;
    protected $data;

    public function __construct($filters = [])
    {
        parent::__construct();
        $this->filters = $filters;
    }

    public function prepare()
    {
        $this->SetTitle('Staff Activity Report - ' . date('Y-m-d'));
        
        // Get CodeIgniter instance
        $CI = &get_instance();
        
        // Load the model if not already loaded
        if (!isset($CI->reporting_dashboard_model)) {
            $CI->load->model('reporting_dashboard/reporting_dashboard_model');
        }
        
        // Get all report data using standalone scripts for now (to avoid model dependency issues)
        $this->data = $this->get_report_data($this->filters);

        $this->set_view_vars($this->data);

        return $this->build();
    }
    
    private function get_report_data($filters)
    {
        // Use existing model methods to ensure consistency with dashboard
        $CI = &get_instance();
        $model = $CI->reporting_dashboard_model;

        $kpis = $model->get_kpis($filters);
        $activityTypePie = $model->get_activity_type_pie($filters); // returns labels/data
        $activityLog = $model->get_activity_log($filters, 50); // already limited
        $followupByStaff = $model->get_followup_types_by_staff($filters);

        return [
            'kpis' => $kpis,
            'activity_types' => [
                'chart_data' => [
                    'labels' => $activityTypePie['labels'],
                    'datasets' => [ ['data' => $activityTypePie['data']] ]
                ]
            ],
            'activity_log' => ['data' => $activityLog],
            'followup_types' => $followupByStaff,
            'filters' => $filters
        ];
    }

    protected function type()
    {
        return 'reporting-dashboard';
    }

    protected function file_path()
    {
        $customPath = FCPATH . 'modules/reporting_dashboard/views/pdf_template.php';
        $actualPath = FCPATH . 'modules/reporting_dashboard/views/pdf_template.php';

        if (file_exists($customPath)) {
            return $customPath;
        }

        return $actualPath;
    }

    public function get_format_array()
    {
        return [
            'orientation' => 'P', // Portrait
            'format'      => 'A4',
        ];
    }
}
