<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<?php
$CI = &get_instance();
// Ensure security library loaded
if (!isset($CI->security)) {
  $CI->load->library('security');
}
if (isset($CI->security)) {
  $rd_csrf_token_name = $CI->security->get_csrf_token_name();
  $rd_csrf_hash = $CI->security->get_csrf_hash();
?>
<script>
// Expose CodeIgniter CSRF token (used by direct-api.js auto injection)
var csrf_token_name = <?= json_encode($rd_csrf_token_name); ?>;
var csrf_hash = <?= json_encode($rd_csrf_hash); ?>;
console.log('[Reporting Dashboard] CSRF vars injected', csrf_token_name);

// Helper function to add CSRF token to data
function addCSRFToken(data) {
    var result = Object.assign({}, data);
    result[csrf_token_name] = csrf_hash;
    return result;
}

// Helper function to make CSRF-safe fetch requests
function safeFetch(url, options) {
    options = options || {};
    if (options.method === 'POST' && options.body) {
        // If body is URLSearchParams, convert to object, add CSRF, convert back
        if (options.body instanceof URLSearchParams) {
            var data = {};
            for (var pair of options.body.entries()) {
                data[pair[0]] = pair[1];
            }
            data[csrf_token_name] = csrf_hash;
            options.body = new URLSearchParams(data);
        }
    }
    return fetch(url, options);
}
</script>
<?php } ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js@2.9.4/dist/Chart.min.js"></script>
<!-- Include direct-api helper -->
<script src="<?= module_dir_url('reporting_dashboard', 'assets/js/direct-api.js'); ?>"></script>
<style>
/* Enhanced Activity Table Styling */
#activity-log-table {
    width: 100% !important;
    table-layout: auto !important;
    display: table !important;
    visibility: visible !important;
    font-size: 13px;
    opacity: 1 !important;
    height: auto !important;
    min-height: 200px !important;
    margin-bottom: 0 !important; /* Remove default table margin */
}

/* Sticky table header */
#activity-log-table thead {
    position: sticky;
    top: 0;
    z-index: 10;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

#activity-log-table thead th {
    position: sticky;
    top: 0;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    z-index: 11;
}

/* Force DataTables wrapper visibility */
.dataTables_wrapper {
    display: block !important;
    visibility: visible !important;
    opacity: 1 !important;
    height: auto !important;
    min-height: 300px !important;
}

.dataTables_wrapper .dataTables_processing {
    display: none !important;
}

#activity-log-table_wrapper {
    display: block !important;
    visibility: visible !important;
    opacity: 1 !important;
}

#activity-log-table tbody tr {
    display: table-row !important;
    visibility: visible !important;
    opacity: 1 !important;
    height: auto !important;
}

#activity-log-table tbody td {
    display: table-cell !important;
    visibility: visible !important;
    opacity: 1 !important;
    padding: 8px !important;
}

.modern-activity-table {
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.modern-activity-table thead {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.modern-activity-table thead th {
    border: none;
    padding: 15px 8px;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 11px;
    letter-spacing: 0.5px;
}

.modern-activity-table thead th i {
    margin-right: 5px;
    opacity: 0.8;
}

.table-responsive {
    overflow-x: auto;
    clear: both;
    display: block !important;
    min-height: 200px;
    max-height: 60vh; /* Limit height to 60% of viewport */
    overflow-y: auto; /* Enable vertical scrolling */
    position: relative;
    border: 1px solid #ddd;
    border-radius: 5px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

/* Custom scrollbar styling */
.table-responsive::-webkit-scrollbar {
    width: 8px;
    height: 8px;
}

.table-responsive::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
}

.table-responsive::-webkit-scrollbar-thumb {
    background: #667eea;
    border-radius: 4px;
}

.table-responsive::-webkit-scrollbar-thumb:hover {
    background: #5a6fd8;
}

/* Smooth scrolling */
.table-responsive {
    scroll-behavior: smooth;
}

/* Ensure table shows immediately */
#activity-log-table tbody {
    display: table-row-group !important;
    background: #fff;
}

#activity-log-table tbody tr {
    transition: all 0.2s ease;
    border-bottom: 1px solid #f0f0f0;
}

#activity-log-table tbody tr:hover {
    background-color: #f8f9ff !important;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(102, 126, 234, 0.15);
}

#activity-log-table thead {
    display: table-header-group !important;
}

#activity-log-table .btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 5px rgba(0,0,0,0.2);
}

/* Activity type specific row styling */
.activity-recent {
    border-left: 4px solid #28a745;
}

.activity-today {
    border-left: 4px solid #17a2b8;
}

.activity-type-whatsapp {
    background-color: #e8f5e9;
}

.activity-type-phone-call {
    background-color: #e3f2fd;
}

.activity-type-email {
    background-color: #fff3e0;
}

.activity-type-sms {
    background-color: #f3e5f5;
}

/* Loading overlay */
.loading-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(255, 255, 255, 0.9);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1000;
}

.loading-content {
    text-align: center;
    color: #667eea;
}

.loading-content i {
    margin-bottom: 10px;
}

/* Badge styling for time ago and types */
.badge {
    border-radius: 20px;
    padding: 4px 8px;
    font-size: 10px;
    font-weight: 500;
}

.badge-success {
    background-color: #28a745;
}

.badge-info {
    background-color: #17a2b8;
}

.badge-warning {
    background-color: #ffc107;
    color: #212529;
}

.badge-secondary {
    background-color: #6c757d;
}

#activity-log-table .followup-type-col {
    min-width: 120px;
}

/* Ensure proper spacing */
.reporting-dashboard .panel_s {
    margin-bottom: 20px;
}

/* Fix for date filter form */
.form-inline .form-group {
    display: inline-block;
    margin-bottom: 0;
    vertical-align: middle;
}

/* Reminder count badges */
.panel-title .badge {
    font-size: 11px;
    margin-left: 8px;
    padding: 3px 7px;
    border-radius: 10px;
    font-weight: 600;
}

.badge-warning {
    background-color: #f39c12;
    color: white;
}

.badge-danger {
    background-color: #e74c3c;
    color: white;
}

.badge-info {
    background-color: #3498db;
    color: white;
}

/* Ensure buttons don't break layout */
.btn-group-sm > .btn {
    white-space: nowrap;
}

/* Fix clearfix issues */
.clearfix::after {
    content: "";
    display: table;
    clear: both;
}

/* Reminder styling */
.reminder-item:hover {
    background-color: #f8f9fa !important;
    transform: translateX(2px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.reminder-item {
    border-radius: 4px;
    margin-bottom: 2px;
    transition: all 0.2s ease;
}

.reminder-item:hover .text-primary {
    color: #007bff !important;
    font-weight: bold;
}

.reminder-item .row {
    margin: 0;
}

.reminder-item .col-md-8,
.reminder-item .col-md-4 {
    padding: 8px 12px;
}

/* Enhanced reminder info styling */
.reminder-item .text-muted {
    font-size: 0.85em;
    margin-bottom: 2px;
}

.reminder-item .fa {
    width: 12px;
    text-align: center;
    margin-right: 4px;
}

.reminder-item strong {
    color: #2c3e50;
}

/* Reminder badges */
.reminder-item .badge {
    font-size: 10px;
    padding: 2px 6px;
}

/* Activity table styling */
#activity-log-table tbody tr:hover {
    background-color: #f8f9fa;
}

#activity-log-table .btn:hover {
    transform: scale(1.05);
}

/* Follow-up type styling */
#activity-log-table .followup-type-col {
    min-width: 120px;
    text-align: center;
}

.followup-type-icon {
    font-size: 14px;
    margin-right: 5px;
}

/* Activity type badges */
.activity-type-badge {
    padding: 3px 8px;
    border-radius: 3px;
    font-size: 11px;
    font-weight: bold;
}

/* Dropdown fixes */
.bootstrap-select {
    width: 100% !important;
}

.bootstrap-select .dropdown-toggle {
    width: 100%;
    padding: 6px 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

/* Fallback for regular select if bootstrap-select fails */
select[multiple] {
    height: auto !important;
    min-height: 34px;
}

#staff-filter, #activity-type-filter {
    width: 100%;
}

/* Ensure dropdowns are visible */
.selectpicker {
    display: block !important;
}

/* Date picker styling */
.datepicker {
    width: 100%;
}

/* Fallback styling for date inputs */
input[type="date"] {
    width: 100%;
    padding: 6px 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

/* Ensure all form controls have consistent styling */
#date-from, #date-to, #activity-date-from, #activity-date-to {
    width: 100%;
}

/* Loading state for filters */
.filters-loading {
    opacity: 0.6;
    pointer-events: none;
}
</style>
<div id="wrapper">
  <div class="content reporting-dashboard">
    <div class="row">
      <div class="col-md-12">
        <div class="panel_s">
          <div class="panel-body">
            <div class="clearfix">
              <div class="pull-left">
                <h4 class="tw-font-semibold tw-text-lg tw-text-neutral-800"><?= _l('Reporting Dashboard'); ?></h4>
                <?php if (isset($show_permission_link) && $show_permission_link): ?>
                  <a href="<?= admin_url('reporting_dashboard/permissions'); ?>" class="btn btn-warning btn-xs">
                    <i class="fa fa-lock"></i> Manage Permissions
                  </a>
                <?php endif; ?>
              </div>
              <div class="pull-right">
                <div class="btn-group">
                  <button id="export-pdf" class="btn btn-danger btn-sm"><i class="fa fa-file-pdf-o"></i> Download PDF</button>
                  <button id="export-csv" class="btn btn-default btn-sm"><i class="fa fa-download"></i> CSV</button>
                  <button id="export-excel" class="btn btn-default btn-sm"><i class="fa fa-file-excel-o"></i> Excel</button>
                  <button id="export-print" class="btn btn-default btn-sm"><i class="fa fa-print"></i> Print</button>
                </div>
              </div>
            </div>
            <hr class="mtop15 mbot15">

            <!-- Filters -->
            <div class="panel_s">
              <div class="panel-body">
                <h5 class="tw-font-medium tw-text-neutral-800 tw-mb-3"><?= _l('Filters'); ?></h5>
                <div class="row">
                  <div class="col-md-4">
                    <div class="form-group">
                      <label class="control-label"><?= _l('Date Range'); ?></label>
                      <div class="btn-group btn-group-sm mbot10" style="display: block;">
                        <button type="button" class="btn btn-default preset-btn" data-preset="today">Today</button>
                        <button type="button" class="btn btn-default preset-btn" data-preset="week">This Week</button>
                        <button type="button" class="btn btn-default preset-btn active" data-preset="month">This Month</button>
                      </div>
                      <div class="row">
                        <div class="col-md-6">
                          <input type="date" class="form-control" id="date-from" placeholder="From" autocomplete="off">
                        </div>
                        <div class="col-md-6">
                          <input type="date" class="form-control" id="date-to" placeholder="To" autocomplete="off">
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label class="control-label"><?= _l('Staff'); ?></label>
                      <select id="staff-filter" class="form-control selectpicker" data-live-search="true" data-actions-box="true" multiple>
                        <?php if (!empty($staff_list)) : ?>
                          <?php foreach ($staff_list as $s): ?>
                            <option value="<?= (int)$s['staffid']; ?>" title="<?= e(($s['firstname'] ?? '') . ' ' . ($s['lastname'] ?? '')); ?>">
                              <?= e(($s['firstname'] ?? '') . ' ' . ($s['lastname'] ?? '')); ?>
                            </option>
                          <?php endforeach; ?>
                        <?php else: ?>
                          <option value="" disabled>No staff available</option>
                        <?php endif; ?>
                      </select>
                      <small class="text-muted">
                        <?php if (!empty($staff_list)): ?>
                          <?= count($staff_list); ?> staff member(s) available
                        <?php else: ?>
                          No staff members available based on your permissions
                        <?php endif; ?>
                      </small>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label class="control-label"><?= _l('Activity Type'); ?></label>
                      <select id="activity-type-filter" class="form-control selectpicker" multiple>
                        <option value="Lead">Lead Activities</option>
                        <option value="Task">Tasks</option>
                        <option value="Project">Projects</option>
                        <option value="Invoice">Invoices</option>
                        <option value="Auth">Login/Logout</option>
                        <option value="Other">Other</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-2">
                    <div class="form-group">
                      <label class="control-label">&nbsp;</label>
                      <button id="apply-filters" class="btn btn-primary btn-block"><i class="fa fa-filter"></i> <?= _l('Apply'); ?></button>
                      <button id="refresh-dropdowns" class="btn btn-default btn-block btn-xs" style="margin-top: 5px;"><i class="fa fa-refresh"></i> Refresh Filters</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Detailed Activity Log -->
            <div class="panel_s mtop20">
              <div class="panel-body">
                <div class="clearfix">
                  <div class="pull-left">
                    <h5 class="panel-title">Detailed Activity Log</h5>
                  </div>
                  <div class="pull-right">
                    <div class="btn-group btn-group-sm">
                      <button class="btn btn-default" id="table-export-csv"><i class="fa fa-download"></i> CSV</button>
                      <button class="btn btn-default" id="table-export-excel"><i class="fa fa-file-excel-o"></i> Excel</button>
                    </div>
                  </div>
                </div>
                <div class="row mtop10">
                  <div class="col-md-12">
                    <div class="form-inline pull-right">
                      <div class="form-group">
                        <label for="activity-date-from" style="margin-right: 5px;">From:</label>
                        <input type="date" id="activity-date-from" class="form-control input-sm" style="width: 140px;">
                      </div>
                      <div class="form-group" style="margin-left: 10px;">
                        <label for="activity-date-to" style="margin-right: 5px;">To:</label>
                        <input type="date" id="activity-date-to" class="form-control input-sm" style="width: 140px;">
                      </div>
                      <button type="button" id="activity-apply-filter" class="btn btn-primary btn-sm" style="margin-left: 10px;">
                        <i class="fa fa-filter"></i> Filter
                      </button>
                    </div>
                  </div>
                </div>
                <hr class="mtop15 mbot15">
                
                <!-- Enhanced Activity Table Controls -->
                <div class="row mbot15">
                  <div class="col-md-6">
                    <div class="btn-group" role="group">
                      <button type="button" class="btn btn-default btn-sm" id="refresh-activity-table">
                        <i class="fa fa-refresh"></i> Refresh
                      </button>
                      <button type="button" class="btn btn-default btn-sm" id="export-activity-table">
                        <i class="fa fa-download"></i> Export
                      </button>
                      <button type="button" class="btn btn-default btn-sm" id="toggle-auto-refresh">
                        <i class="fa fa-clock-o"></i> Auto Refresh: <span id="auto-refresh-status">OFF</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-md-6 text-right">
                    <div class="input-group input-group-sm" style="width: 200px; display: inline-block;">
                      <input type="text" class="form-control" placeholder="Search activities..." id="activity-search">
                      <span class="input-group-btn">
                        <button class="btn btn-default" type="button" id="search-activity">
                          <i class="fa fa-search"></i>
                        </button>
                      </span>
                    </div>
                  </div>
                </div>

                <!-- Enhanced Activity Stats -->
                <div class="row mbot15">
                  <div class="col-md-12">
                    <div class="alert alert-info" id="activity-stats" style="margin: 0; padding: 10px;">
                      <i class="fa fa-info-circle"></i> 
                      <span id="activity-count">Loading activity statistics...</span>
                      <span class="pull-right">
                        <small>Last updated: <span id="last-update-time">-</span></small>
                      </span>
                    </div>
                  </div>
                </div>
                
                <div class="table-responsive">
                  <table id="activity-log-table" class="table table-striped table-bordered dt-table modern-activity-table">
                    <thead>
                      <tr>
                        <th data-priority="1">
                          <i class="fa fa-clock-o"></i> Date & Time
                        </th>
                        <th data-priority="2">
                          <i class="fa fa-user"></i> Staff Member
                        </th>
                        <th data-priority="3">
                          <i class="fa fa-user-o"></i> Lead/Contact
                        </th>
                        <th data-priority="4">
                          <i class="fa fa-tag"></i> Follow-up Type
                        </th>
                        <th data-priority="5">
                          <i class="fa fa-file-text-o"></i> Description
                        </th>
                        <th data-priority="6">
                          <i class="fa fa-cog"></i> Actions
                        </th>
                      </tr>
                    </thead>
                    <tbody></tbody>
                  </table>
                </div>
                
                <!-- Loading overlay for table -->
                <div id="activity-table-loading" class="loading-overlay" style="display: none;">
                  <div class="loading-content">
                    <i class="fa fa-spinner fa-spin fa-3x"></i>
                    <p>Loading activities...</p>
                  </div>
                </div>
              </div>
            </div>

            <!-- KPIs -->
            <div class="row mtop20">
              <div class="col-md-3">
                <div class="panel_s">
                  <div class="panel-body text-center">
                    <div class="text-primary">
                      <i class="fa fa-calendar fa-2x"></i>
                    </div>
                    <h3 class="mtop10 mbot5" id="kpi-today">0</h3>
                    <p class="text-muted mbot0">Activities Today</p>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="panel_s">
                  <div class="panel-body text-center">
                    <div class="text-success">
                      <i class="fa fa-calendar-check-o fa-2x"></i>
                    </div>
                    <h3 class="mtop10 mbot5" id="kpi-week">0</h3>
                    <p class="text-muted mbot0">This Week</p>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="panel_s">
                  <div class="panel-body text-center">
                    <div class="text-info">
                      <i class="fa fa-calendar-o fa-2x"></i>
                    </div>
                    <h3 class="mtop10 mbot5" id="kpi-month">0</h3>
                    <p class="text-muted mbot0">This Month</p>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="panel_s">
                  <div class="panel-body text-center">
                    <div class="text-warning">
                      <i class="fa fa-sign-in fa-2x"></i>
                    </div>
                    <h3 class="mtop10 mbot5" id="kpi-logins">0</h3>
                    <p class="text-muted mbot0">Logins Today</p>
                  </div>
                </div>
              </div>
            </div>

            <!-- Dealer Interest KPIs -->
            <div class="row mtop20">
              <div class="col-md-12">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-users"></i> Dealer Interest Statistics</h5>
                    <div class="row">
                      <div class="col-md-3">
                        <div class="text-center">
                          <div class="text-primary">
                            <i class="fa fa-users fa-2x"></i>
                          </div>
                          <h3 class="mtop10 mbot5" id="dealer-total">0</h3>
                          <p class="text-muted mbot0">Total Dealers</p>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="text-center">
                          <div class="text-success">
                            <i class="fa fa-thumbs-up fa-2x"></i>
                          </div>
                          <h3 class="mtop10 mbot5" id="dealer-interested">0</h3>
                          <p class="text-muted mbot0">Interested</p>
                          <small class="text-success" id="dealer-interested-percentage">0%</small>
                          <div class="mtop10">
                            <button class="btn btn-success btn-sm" onclick="openDealerModal('interested')">
                              <i class="fa fa-list"></i> View List
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="text-center">
                          <div class="text-danger">
                            <i class="fa fa-thumbs-down fa-2x"></i>
                          </div>
                          <h3 class="mtop10 mbot5" id="dealer-not-interested">0</h3>
                          <p class="text-muted mbot0">Not Interested</p>
                          <small class="text-danger" id="dealer-not-interested-percentage">0%</small>
                          <div class="mtop10">
                            <button class="btn btn-danger btn-sm" onclick="openDealerModal('not_interested')">
                              <i class="fa fa-list"></i> View List
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="text-center">
                          <div class="text-warning">
                            <i class="fa fa-question fa-2x"></i>
                          </div>
                          <h3 class="mtop10 mbot5" id="dealer-no-response">0</h3>
                          <p class="text-muted mbot0">No Response</p>
                          <small class="text-warning" id="dealer-no-response-percentage">0%</small>
                          <div class="mtop10">
                            <button class="btn btn-warning btn-sm" onclick="openDealerModal('no_response')">
                              <i class="fa fa-list"></i> View List
                            </button>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>


            <!-- Charts -->
            <div class="row mtop20">
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">Activities by Staff</h5>
                    <div class="chart-container" style="position: relative; height: 300px;">
                      <canvas id="activitiesChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">Activities Over Time</h5>
                    <div class="chart-container" style="position: relative; height: 300px;">
                      <canvas id="activitiesOverTimeChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
            <div class="row mtop20">
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">Activity Type Distribution</h5>
                    <div class="chart-container" style="position: relative; height: 300px;">
                      <canvas id="activityTypesChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-users"></i> Top Active Staff</h5>
                    <div id="top-staff-list">
                      <div class="text-muted text-center">Loading...</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
            <!-- Staff Performance Chart -->
            <div class="row mtop20">
              <div class="col-md-12">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-bar-chart"></i> Staff Performance by Activity Type</h5>
                    <div class="chart-container" style="position: relative; height: 400px;">
                      <canvas id="staffPerformanceChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Follow-up Types Chart -->
            <div class="row mtop20">
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">
                      <i class="fa fa-pie-chart text-success"></i> Follow-up Types Distribution
                    </h5>
                    <p class="text-muted">Distribution of follow-up types across all staff.</p>
                    <div class="chart-container" style="position: relative; height: 400px;">
                      <canvas id="followupTypesChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">
                      <i class="fa fa-table text-success"></i> Follow-up Types by Staff
                    </h5>
                    <p class="text-muted">Detailed breakdown by staff member.</p>
                    <div id="followup-types-by-staff" style="max-height: 400px; overflow-y: auto;">
                      <div class="text-muted text-center">Loading follow-up types data...</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Reminders & Followups Section -->
            <div class="row mtop20">
              <div class="col-md-4">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-bell text-warning"></i> Today's Reminders</h5>
                    <div id="todays-reminders">
                      <div class="text-muted text-center">Loading...</div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-4">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-exclamation-triangle text-danger"></i> Due Reminders</h5>
                    <div id="due-reminders">
                      <div class="text-muted text-center">Loading...</div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-4">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-calendar text-info"></i> Upcoming Reminders</h5>
                    <div id="upcoming-reminders">
                      <div class="text-muted text-center">Loading...</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
</div>



<!-- Modal -->
<div class="modal fade" id="rdLogModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">Log Details</h4>
      </div>
      <div class="modal-body" id="rd-log-details">
        <div class="text-center"><i class="fa fa-spinner fa-spin"></i></div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><?= _l('close'); ?></button>
      </div>
    </div>
  </div>
</div>

<script>
// Global variables
var baseUrl = window.location.origin + window.location.pathname.split('/admin/')[0] + '/admin/';
var currentFilters = {};

// Function to force table rendering
// Add safeguard to prevent multiple simultaneous renders
var isTableRendering = false;

function forceTableRender() {
    if (isTableRendering) {
        // Table render already in progress, skipping...
        return;
    }
    
    isTableRendering = true;
    
    var table = document.getElementById('activity-log-table');
    var container = document.querySelector('.table-responsive');
    
    if (table && container) {
        // Force visibility
        table.style.display = 'table';
        table.style.visibility = 'visible';
        container.style.display = 'block';
        
        // Force reflow
        table.offsetHeight;
        container.offsetHeight;
        
        // Table rendering completed
    }
    
    // Reset the flag after a short delay
    setTimeout(function() {
        isTableRendering = false;
    }, 500);
}

// Function to normalize chart responses from real API (labels+data) or mock (chart_data)
function normalizeSimpleToDataset(obj, type){
  if(!obj) return null;
  // Mock shape already nested
  if(obj.chart_data) return obj.chart_data;
  // Real shape: {labels:[], data:[]} -> wrap
  if(Array.isArray(obj.labels) && Array.isArray(obj.data)){
    var colorSets = {
      bar: '#4e73df',
      line: '#1cc88a',
      pie: ['#4e73df','#1cc88a','#36b9cc','#f6c23e','#e74a3b','#858796']
    };
    var ds = {labels: obj.labels, datasets: []};
    if(type==='pie'){
      ds.datasets.push({data: obj.data, backgroundColor: colorSets.pie.slice(0, obj.data.length)});
    } else if(type==='line') {
      ds.datasets.push({label:'Activities', data: obj.data, borderColor: colorSets.line, fill:false});
    } else { // bar default
      ds.datasets.push({label:'Activities', data: obj.data, backgroundColor: colorSets.bar});
    }
    return ds;
  }
  return null;
}

// Function to load charts
function loadCharts(baseUrl, filters) {
    // Load Activities by Staff Chart
    safeFetch(baseUrl + 'reporting_dashboard/get_staff_activity_chart', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams(filters)
    })
    .then(response => response.json())
  .then(data => {
    var chartData = normalizeSimpleToDataset(data,'bar');
    if(chartData) createActivitiesByStaffChart(chartData);
    })
    .catch(error => {
        console.error('Activities by staff chart failed:', error.message);
    });
    
    // Load Activities Over Time Chart
    safeFetch(baseUrl + 'reporting_dashboard/get_activity_over_time_chart', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams(filters)
    })
    .then(response => response.json())
  .then(data => {
    var chartData = normalizeSimpleToDataset(data,'line');
    if(chartData) createActivitiesOverTimeChart(chartData);
    })
    .catch(error => {
        console.error('Activities over time chart failed:', error.message);
    });
    
    // Load Activity Types Chart
    safeFetch(baseUrl + 'reporting_dashboard/get_activity_type_pie', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams(filters)
    })
    .then(response => response.json())
  .then(data => {
    var chartData = normalizeSimpleToDataset(data,'pie');
    if(chartData) createActivityTypesChart(chartData);
    })
    .catch(error => {
        console.error('Activity types chart failed:', error.message);
    });
    
    // Load Reminders data
    console.log('Loading reminders with filters:', filters);
    safeFetch(baseUrl + 'reporting_dashboard/get_reminders', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams(filters)
    })
    .then(response => {
        console.log('Reminders response status:', response.status);
        return response.json();
    })
    .then(data => {
        console.log('Reminders data received:', data);
        loadReminders(data);
    })
    .catch(error => {
        console.error('Reminders load failed:', error);
        // Show error in UI
        document.getElementById('todays-reminders').innerHTML = '<div class="alert alert-danger">Failed to load reminders: ' + error.message + '</div>';
        document.getElementById('due-reminders').innerHTML = '<div class="alert alert-danger">Failed to load reminders: ' + error.message + '</div>';
        document.getElementById('upcoming-reminders').innerHTML = '<div class="alert alert-danger">Failed to load reminders: ' + error.message + '</div>';
    });
}

// Function to apply filters and load data
function applyFilters() {
    // Ensure selectpickers are refreshed before getting values
    if (typeof $ !== 'undefined' && $.fn.selectpicker) {
        $('#staff-filter').selectpicker('refresh');
        $('#activity-type-filter').selectpicker('refresh');
    }
    
    var filters = {
        from: document.getElementById('date-from').value,
        to: document.getElementById('date-to').value,
        staff: Array.from(document.getElementById('staff-filter').selectedOptions).map(opt => opt.value),
        activity_type: Array.from(document.getElementById('activity-type-filter').selectedOptions).map(opt => opt.value),
        // Remove manual pagination parameters - DataTables will handle this
    };
    
    // Synchronize activity log date filters with main date filters
    if (filters.from) {
        document.getElementById('activity-date-from').value = filters.from;
    }
    if (filters.to) {
        document.getElementById('activity-date-to').value = filters.to;
    }
    
    // Debug: Log filters being sent
    console.log('Apply Filters called with:', filters);
    console.log('Staff filter array:', filters.staff);
    console.log('Staff filter length:', filters.staff.length);
    
    currentFilters = filters;
    
    // Load KPIs
    var kpiUrl = baseUrl + 'reporting_dashboard/get_kpis';
    
    console.log('[KPI] Starting KPI load...');
    console.log('[KPI] URL:', kpiUrl);
    console.log('[KPI] Filters:', filters);
    
    safeFetch(kpiUrl, {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams(filters)
    })
    .then(response => {
        console.log('[KPI] Response status:', response.status);
        if (!response.ok) {
            throw new Error(`HTTP ${response.status}: ${response.statusText}`);
        }
        return response.json();
    })
    .then(data => {
        console.log('[KPI] Data received:', data);
        // Update KPI displays
        document.getElementById('kpi-today').textContent = data.today || 0;
        document.getElementById('kpi-week').textContent = data.week || 0;
        document.getElementById('kpi-month').textContent = data.month || 0;
        document.getElementById('kpi-logins').textContent = data.logins_today || 0;
        
        // Update top staff list
        if (data.top_staff && data.top_staff.length > 0) {
            var staffHtml = '<div class="list-group">';
            data.top_staff.forEach(function(staff) {
                staffHtml += '<div class="list-group-item">' +
                    '<div class="row">' +
                    '<div class="col-md-8">' + staff.staff_name + '</div>' +
                    '<div class="col-md-4 text-right"><span class="badge badge-primary">' + staff.total + '</span></div>' +
                    '</div></div>';
            });
            staffHtml += '</div>';
            document.getElementById('top-staff-list').innerHTML = staffHtml;
        }
        
        console.log('[KPI] KPI update completed, loading activity table...');
        
        // Load activity table data manually
        console.log('[Activity Table] Starting activity table load...');
        console.log('[Activity Table] URL:', baseUrl + 'reporting_dashboard/get_activity_table');
        console.log('[Activity Table] Filters:', filters);
        
        safeFetch(baseUrl + 'reporting_dashboard/get_activity_table', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: new URLSearchParams(filters)
        })
        .then(response => {
            console.log('[Activity Table] Response status:', response.status);
            if (!response.ok) {
                throw new Error(`HTTP ${response.status}: ${response.statusText}`);
            }
            return response.json();
        })
        .then(data => {
            console.log('[Activity Table] Data received:', data);
            // Initialize or reload DataTable with the received data
            loadActivityLog(data);
        })
        .catch(error => {
            console.error('[Activity Table] Load failed:', error.message);
            // Show error in table
            var tbody = document.querySelector('#activity-log-table tbody');
            if (tbody) {
                tbody.innerHTML = '<tr><td colspan="6" class="text-center text-danger">Error loading activity data: ' + error.message + '</td></tr>';
            }
        });
        
        // Load charts
        safeFetch(baseUrl + 'reporting_dashboard/get_staff_activity_chart', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: new URLSearchParams(filters)
        })
        .then(response => response.json())
        .then(data => {
            try {
                // Reuse by creating normalized dataset with single bar series
                var chartData = normalizeSimpleToDataset(data,'bar');
                if(chartData && chartData.datasets && chartData.datasets.length > 0){
                    // For staff performance we want stacked? If only one dataset, just pass
                    createStaffPerformanceChart({labels: chartData.labels, datasets: {'Activities': chartData.datasets[0]}});
                } else {
                    console.warn('No chart data available for staff performance chart');
                }
            } catch (chartError) {
                console.error('Error creating staff performance chart:', chartError);
            }
        })
        .catch(error => {
            console.error('Staff performance load failed:', error.message);
        });
        
        // Load follow-up types chart
        console.log('Loading follow-up types chart...');
        safeFetch(baseUrl + 'reporting_dashboard/get_followup_types_chart', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: new URLSearchParams(filters)
        })
        .then(response => {
            console.log('Follow-up types chart response status:', response.status);
            return response.json();
        })
        .then(data => {
            console.log('Follow-up types chart data received:', data);
            createFollowupTypesChart(data);
        })
        .catch(error => {
            console.error('Follow-up types chart load failed:', error.message);
            // Show error in chart area
            var ctx = document.getElementById('followupTypesChart');
            if (ctx) {
                var canvasParent = ctx.parentElement;
                canvasParent.innerHTML = '<div class="alert alert-danger text-center" style="margin-top: 50px;">Error loading follow-up types chart: ' + error.message + '</div>';
            }
        });
        
        // Load dealer statistics
        safeFetch(baseUrl + 'reporting_dashboard/get_dealer_statistics', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: new URLSearchParams(filters)
        })
        .then(response => response.json())
        .then(data => {
            updateDealerStatistics(data);
            // Dealer lists are now accessed via buttons in the statistics row
        })
        .catch(error => {
            console.error('Dealer statistics load failed:', error.message);
        });
        
        // Load follow-up types by staff
        safeFetch(baseUrl + 'reporting_dashboard/get_followup_types_by_staff', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: new URLSearchParams(filters)
        })
        .then(response => response.json())
        .then(data => {
            displayFollowupTypesByStaff(data);
        })
        .catch(error => {
            console.error('Follow-up types by staff load failed:', error.message);
        });

        // Load reminders with the same filters
        console.log('Loading reminders with filters:', filters);
        safeFetch(baseUrl + 'reporting_dashboard/get_reminders', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: new URLSearchParams(filters)
        })
        .then(response => {
            console.log('Reminders response status:', response.status);
            return response.json();
        })
        .then(data => {
            console.log('Reminders data received:', data);
            loadReminders(data);
        })
        .catch(error => {
            console.error('Reminders load failed:', error);
            // Show error in UI
            document.getElementById('todays-reminders').innerHTML = '<div class="alert alert-danger">Failed to load reminders: ' + error.message + '</div>';
            document.getElementById('due-reminders').innerHTML = '<div class="alert alert-danger">Failed to load reminders: ' + error.message + '</div>';
            document.getElementById('upcoming-reminders').innerHTML = '<div class="alert alert-danger">Failed to load reminders: ' + error.message + '</div>';
        });
    })
    .catch(error => {
        console.error('[KPI] Load failed:', error.message);
    });
}

// Function to get follow-up type with appropriate icon
function getFollowupTypeWithIcon(followupType, activityType) {
    if (!followupType || followupType.trim() === '') {
        // Return appropriate icon for non-followup activities
        switch(activityType) {
            case 'Reminder Created':
                return '<span class="text-warning"><i class="fa fa-bell"></i> Reminder</span>';
            case 'Lead Created':
                return '<span class="text-success"><i class="fa fa-plus-circle"></i> New Lead</span>';
            case 'Lead Assigned':
                return '<span class="text-info"><i class="fa fa-user"></i> Assignment</span>';
            default:
                return '<span class="text-muted"><i class="fa fa-circle-o"></i> N/A</span>';
        }
    }
    
    // Get appropriate icon and color for follow-up types
    var icon = 'fa-comment';
    var colorClass = 'text-primary';
    var typeText = followupType.toLowerCase();
    
    if (typeText.includes('call') || typeText.includes('phone')) {
        icon = 'fa-phone';
        colorClass = 'text-success';
    } else if (typeText.includes('email') || typeText.includes('mail')) {
        icon = 'fa-envelope';
        colorClass = 'text-info';
    } else if (typeText.includes('meeting') || typeText.includes('visit')) {
        icon = 'fa-calendar';
        colorClass = 'text-warning';
    } else if (typeText.includes('whatsapp') || typeText.includes('message')) {
        icon = 'fa-whatsapp';
        colorClass = 'text-success';
    } else if (typeText.includes('sms') || typeText.includes('text')) {
        icon = 'fa-mobile';
        colorClass = 'text-primary';
    } else if (typeText.includes('proposal') || typeText.includes('quote')) {
        icon = 'fa-file-text';
        colorClass = 'text-warning';
    } else if (typeText.includes('contract') || typeText.includes('agreement')) {
        icon = 'fa-handshake-o';
        colorClass = 'text-danger';
    }
    
    return '<span class="' + colorClass + '"><i class="fa ' + icon + '"></i> ' + followupType + '</span>';
}

// Function to load activity log
function loadActivityLog(data) {
    console.log('Enhanced loadActivityLog called with:', data);
    console.log('Data array length:', data.data ? data.data.length : 'No data array');
    console.log('Sample data item:', data.data && data.data.length > 0 ? data.data[0] : 'No data');
    
    // TEMPORARY: Let's use basic table to see if data is rendering
    console.log('TESTING: Using basic table to verify data rendering');
    loadActivityLogBasic(data);
    return;
    
    // DataTables code will be re-enabled once we confirm basic rendering works
    console.log('DataTables available:', typeof $.fn.DataTable !== 'undefined');
    
    // TEMPORARILY USE CLIENT-SIDE UNTIL SERVER ISSUE IS FIXED
    console.log('Using client-side DataTables to avoid server issues');
    
    // Check if DataTables is available
    if (typeof $.fn.DataTable === 'undefined') {
        console.error('DataTables is not available! Falling back to basic table.');
        loadActivityLogBasic(data);
        return;
    }
    
    var table = $('#activity-log-table');
    console.log('Table element found:', table.length > 0);
    
    // Destroy existing DataTable if it exists
    if ($.fn.DataTable.isDataTable('#activity-log-table')) {
        console.log('Destroying existing DataTable');
        table.DataTable().destroy();
        table.empty(); // Clear any remaining content
    }
    
    console.log('Initializing client-side DataTable...');
    
    // Initialize DataTable with client-side processing for now
    try {
        // Get saved page length preference
        var savedPageLength = localStorage.getItem('reporting_dashboard_page_length');
        var initialPageLength = savedPageLength ? parseInt(savedPageLength) : 25;
        
        console.log('Initializing DataTable with page length:', initialPageLength);
        
        var dataTable = table.DataTable({
            data: data.data || [],
            destroy: true,
            processing: false,
            serverSide: false,
            pageLength: initialPageLength,
            lengthMenu: [[25, 50, 100, -1], [25, 50, 100, "All"]],
            order: [[0, 'desc']], // Sort by date descending
            responsive: true,
            language: {
                emptyTable: "No activity data found for the selected filters.",
                zeroRecords: "No matching records found.",
                lengthMenu: "Show _MENU_ activities per page",
                info: "Showing _START_ to _END_ of _TOTAL_ activities",
                infoEmpty: "Showing 0 to 0 of 0 activities",
                infoFiltered: "(filtered from _MAX_ total activities)"
            },
        columns: [
            {
                title: 'Date & Time',
                data: 'date',
                render: function(data, type, row) {
                    if (type === 'display') {
                        return `
                            <div>
                                <strong>${data || 'N/A'}</strong><br>
                                <small class="text-muted">${row.readable_date || ''}</small><br>
                                ${row.time_ago || ''}
                            </div>
                        `;
                    }
                    return data;
                }
            },
            {
                title: 'Staff Member',
                data: 'staff',
                render: function(data, type, row) {
                    if (type === 'display') {
                        return `
                            <div>
                                <i class="fa fa-user"></i> ${data || 'System'}
                                ${row.staff_id ? `<br><small class="text-muted">ID: ${row.staff_id}</small>` : ''}
                            </div>
                        `;
                    }
                    return data;
                }
            },
            {
                title: 'Lead/Contact',
                data: 'lead',
                render: function(data, type, row) {
                    return data || 'N/A';
                }
            },
            {
                title: 'Follow-up Type',
                data: 'followup_type',
                render: function(data, type, row) {
                    if (type === 'display') {
                        return getEnhancedFollowupType(data, row.priority);
                    }
                    return data;
                }
            },
            {
                title: 'Description',
                data: 'description',
                render: function(data, type, row) {
                    if (type === 'display') {
                        return getEnhancedDescription(data || row.raw_description || 'No description');
                    }
                    return data;
                }
            },
            {
                title: 'Actions',
                data: null,
                orderable: false,
                render: function(data, type, row) {
                    if (type === 'display') {
                        return createEnhancedActions(row);
                    }
                    return '';
                }
            }
        ],
        drawCallback: function(settings) {
            // Update activity statistics after table is drawn
            updateActivityStats(data);
            
            // Update last update time
            document.getElementById('last-update-time').textContent = new Date().toLocaleTimeString();
            
            console.log('DataTable drawn. Current page length:', settings._iDisplayLength);
            console.log('Total records:', settings.fnRecordsTotal());
            console.log('Filtered records:', settings.fnRecordsDisplay());
        },
        initComplete: function(settings, json) {
            console.log('DataTable initialization complete');
            console.log('Initial page length:', settings._iDisplayLength);
        }
    });
    
    console.log('DataTable initialized successfully');
    
    // Handle page length change event to ensure it works properly
    dataTable.on('length.dt', function(e, settings, len) {
        console.log('Page length changed to:', len);
        console.log('Total records available:', dataTable.data().length);
        
        // Store the new page length preference
        localStorage.setItem('reporting_dashboard_page_length', len);
        
        console.log('Page length change handled successfully');
    });
    
    // Handle search to ensure it works with pagination
    dataTable.on('search.dt', function() {
        console.log('Search applied, filtered records:', dataTable.page.info().recordsDisplay);
    });
    
    // Handle page change events
    dataTable.on('page.dt', function() {
        console.log('Page changed, current page:', dataTable.page.info().page);
    });
    
    } catch (error) {
        console.error('DataTable initialization failed:', error);
        console.error('Error stack:', error.stack);
        console.log('Falling back to basic table rendering');
        
        // Clear any partial DataTable setup
        if ($.fn.DataTable.isDataTable('#activity-log-table')) {
            $('#activity-log-table').DataTable().destroy();
        }
        $('#activity-log-table').empty();
        
        loadActivityLogBasic(data);
    }
}

// Fallback function for when DataTables is not available
function loadActivityLogBasic(data) {
    console.log('Using basic table fallback');
    console.log('Data received:', data);
    console.log('Data array:', data.data);
    
    var tbody = document.querySelector('#activity-log-table tbody');
    if (!tbody) {
        console.error('Activity table tbody not found!');
        console.log('Trying to find table element...');
        var table = document.querySelector('#activity-log-table');
        console.log('Table element found:', table);
        if (table) {
            console.log('Table innerHTML:', table.innerHTML.substring(0, 200));
        }
        return;
    }
    
    console.log('tbody element found:', tbody);
    
    // Update activity statistics
    updateActivityStats(data);
    
    tbody.innerHTML = '';
    console.log('tbody cleared');
    
    if (data.data && data.data.length > 0) {
        console.log('Processing', data.data.length, 'activities');
        
        // Clear tbody for DataTables initialization
        tbody.innerHTML = '';
        
        // Prepare data for DataTables
        var tableData = data.data.map(function(activity) {
            // Add data-lead-id attribute for event delegation
            var viewBtn = '<button class="btn btn-xs btn-primary view-lead-btn" data-lead-id="' + (activity.lead_id || '') + '">View</button>';
            return [
                activity.date || 'N/A',
                activity.staff || 'N/A',
                activity.lead || 'N/A',
                activity.followup_type || 'N/A',
                (activity.description || '').substring(0, 100) || 'N/A',
                viewBtn
            ];
        });
        
        console.log('Prepared', tableData.length, 'rows for DataTables');
        
        // Initialize DataTables with data
        try {
            console.log('TEMPORARILY DISABLING DATATABLES - TESTING BASIC TABLE');
            
            // Create basic table rows for all data
            data.data.forEach(function(activity, index) {
                try {
                    var row = document.createElement('tr');
                    row.style.display = 'table-row';
                    row.style.visibility = 'visible';
                    row.style.opacity = '1';
                    var leadId = activity.lead_id || '';
                    row.innerHTML = `
                        <td style="padding: 8px; border: 1px solid #ddd; background: #fff;">${activity.date || 'N/A'}</td>
                        <td style="padding: 8px; border: 1px solid #ddd; background: #fff;">${activity.staff || 'N/A'}</td>
                        <td style="padding: 8px; border: 1px solid #ddd; background: #fff;">${activity.lead || 'N/A'}</td>
                        <td style="padding: 8px; border: 1px solid #ddd; background: #fff;">${activity.followup_type || 'N/A'}</td>
                        <td style="padding: 8px; border: 1px solid #ddd; background: #fff;">${(activity.description || '').substring(0, 100) || 'N/A'}</td>
                        <td style="padding: 8px; border: 1px solid #ddd; background: #fff;"><button class="btn btn-xs btn-primary view-lead-btn" data-lead-id="${leadId}">View</button></td>
                    `;
                    tbody.appendChild(row);
                    if (index < 5 || index % 50 === 0) { // Log progress for first 5 and every 50th row
                        console.log('Added basic row', index);
                    }
                } catch (error) {
                    console.error('Error creating basic row', index, ':', error);
                }
            });
// Event delegation for dynamically created View buttons in activity log
document.addEventListener('click', function(e) {
    if (e.target && e.target.classList.contains('view-lead-btn')) {
        var leadId = e.target.getAttribute('data-lead-id');
        if (leadId) {
            // Use the correct admin base URL from PHP
            var adminBaseUrl = (typeof window.admin_url !== 'undefined') ? window.admin_url : '<?php echo admin_url(); ?>';
            // Open the lead details page in a new tab (Perfex CRM default lead URL)
            var url = adminBaseUrl + 'leads/index/' + leadId;
            window.open(url, '_blank');
        } else {
            alert('No lead ID found for this activity.');
        }
    }
});
            
            console.log('Basic table approach completed - added', data.data.length, 'rows');
            
            // Add simple pagination controls
            addSimplePagination(data.data.length);
            
            /*
            var table = $('#activity-log-table');
            
            // Destroy existing DataTable if it exists
            if ($.fn.DataTable.isDataTable('#activity-log-table')) {
                table.DataTable().destroy();
                console.log('Existing DataTable destroyed');
            }
            
            // Initialize new DataTable with client-side processing and data
            table.DataTable({
                "data": tableData,
                "processing": false,
                "serverSide": false,
                "searching": true,
                "paging": true,
                "info": true,
                "ordering": true,
                "pageLength": parseInt(localStorage.getItem('activity_page_length') || 25),
                "lengthMenu": [[25, 50, 100, -1], [25, 50, 100, "All"]],
                "order": [[0, 'desc']], // Sort by date column (descending)
                "columnDefs": [
                    { "orderable": false, "targets": [5] }, // Disable sorting on action column
                    { "width": "15%", "targets": [0] }, // Date column
                    { "width": "15%", "targets": [1] }, // Staff column
                    { "width": "25%", "targets": [2] }, // Lead column
                    { "width": "15%", "targets": [3] }, // Type column
                    { "width": "20%", "targets": [4] }, // Description column
                    { "width": "10%", "targets": [5] }  // Actions column
                ],
                "columns": [
                    { "title": "Date" },
                    { "title": "Staff" },
                    { "title": "Lead" },
                    { "title": "Type" },
                    { "title": "Description" },
                    { "title": "Actions" }
                ],
                "language": {
                    "search": "Search activities:",
                    "lengthMenu": "Show _MENU_ activities per page",
                    "info": "Showing _START_ to _END_ of _TOTAL_ activities",
                    "paginate": {
                        "first": "First",
                        "last": "Last",
                        "next": "Next",
                        "previous": "Previous"
                    },
                    "emptyTable": "No activity data available",
                    "zeroRecords": "No matching activities found"
                },
                "drawCallback": function(settings) {
                    // Save page length preference
                    var pageLength = this.api().page.len();
                    if (pageLength !== -1) {
                        localStorage.setItem('activity_page_length', pageLength);
                    }
                    console.log('DataTable redrawn with', settings.fnRecordsDisplay(), 'records displayed');
                }
            });
            
            console.log('DataTable initialized successfully with', tableData.length, 'records');
            */
            
            // Debug: Check table visibility and structure
            setTimeout(function() {
                console.log('=== POST-INITIALIZATION DEBUG ===');
                var tableElement = document.getElementById('activity-log-table');
                var wrapperElement = document.querySelector('.dataTables_wrapper');
                
                console.log('Table element:', tableElement);
                console.log('Table style display:', tableElement ? tableElement.style.display : 'N/A');
                console.log('Table computed display:', tableElement ? window.getComputedStyle(tableElement).display : 'N/A');
                console.log('Table visibility:', tableElement ? window.getComputedStyle(tableElement).visibility : 'N/A');
                console.log('Table height:', tableElement ? window.getComputedStyle(tableElement).height : 'N/A');
                
                console.log('DataTables wrapper:', wrapperElement);
                console.log('Wrapper style display:', wrapperElement ? wrapperElement.style.display : 'N/A');
                console.log('Wrapper computed display:', wrapperElement ? window.getComputedStyle(wrapperElement).display : 'N/A');
                
                var tbody = tableElement ? tableElement.querySelector('tbody') : null;
                console.log('Table tbody:', tbody);
                console.log('Tbody children count:', tbody ? tbody.children.length : 0);
                
                if (tbody && tbody.children.length > 0) {
                    console.log('First row HTML:', tbody.children[0].outerHTML.substring(0, 200));
                    console.log('First row display:', window.getComputedStyle(tbody.children[0]).display);
                    console.log('First row visibility:', window.getComputedStyle(tbody.children[0]).visibility);
                }
                
                // Force visibility
                if (tableElement) {
                    tableElement.style.display = 'table !important';
                    tableElement.style.visibility = 'visible !important';
                    tableElement.style.opacity = '1 !important';
                    tableElement.style.height = 'auto !important';
                }
                
                if (wrapperElement) {
                    wrapperElement.style.display = 'block !important';
                    wrapperElement.style.visibility = 'visible !important';
                    wrapperElement.style.opacity = '1 !important';
                }
                
                console.log('=== FORCED VISIBILITY APPLIED ===');
            }, 500);
            
            
        } catch (error) {
            console.error('Error initializing DataTable:', error);
            console.log('Falling back to basic table display');
            
            // Fallback: Create basic rows
            data.data.forEach(function(activity, index) {
                try {
                    var row = document.createElement('tr');
                    row.innerHTML = `
                        <td>${activity.date || 'N/A'}</td>
                        <td>${activity.staff || 'N/A'}</td>
                        <td>${activity.lead || 'N/A'}</td>
                        <td>${activity.followup_type || 'N/A'}</td>
                        <td>${(activity.description || '').substring(0, 100) || 'N/A'}</td>
                        <td><button class="btn btn-xs btn-primary">View</button></td>
                    `;
                    tbody.appendChild(row);
                } catch (error) {
                    console.error('Error creating row', index, ':', error);
                }
            });
            console.log('Fallback: All', data.data.length, 'rows processed successfully');
        }
        
        // Debug: Force table visibility
        var table = document.querySelector('#activity-log-table');
        if (table) {
            table.style.display = 'table';
            table.style.visibility = 'visible';
            console.log('Forced table visibility');
        }
    } else {
        console.log('No data available, showing empty message');
        tbody.innerHTML = `
            <tr>
                <td colspan="6" class="text-center text-muted" style="padding: 40px;">
                    <i class="fa fa-info-circle fa-2x" style="margin-bottom: 10px; opacity: 0.5;"></i><br>
                    No activity data found for the selected filters.<br>
                    <small>Try adjusting your date range or removing filters.</small>
                </td>
            </tr>
        `;
    }
    
    // Update last update time
    document.getElementById('last-update-time').textContent = new Date().toLocaleTimeString();
    
    console.log('Basic table loading completed');
}

// Simple pagination function
function addSimplePagination(totalRows) {
    try {
        // Create pagination info
        var tableContainer = document.querySelector('.table-responsive');
        if (!tableContainer) {
            console.log('Table container not found for pagination');
            return;
        }
        
        // Remove existing pagination if any
        var existingPagination = document.getElementById('simple-pagination');
        if (existingPagination) {
            existingPagination.remove();
        }
        
        // Create pagination container
        var paginationDiv = document.createElement('div');
        paginationDiv.id = 'simple-pagination';
        paginationDiv.style.cssText = 'margin-top: 15px; padding: 15px; background: #f8f9fa; border-radius: 5px; text-align: center;';
        
        // Add page size selector
        var pageSizeLabel = document.createElement('label');
        pageSizeLabel.style.cssText = 'margin-right: 15px; font-weight: bold;';
        pageSizeLabel.innerHTML = 'Show: ';
        
        var pageSizeSelect = document.createElement('select');
        pageSizeSelect.id = 'page-size-select';
        pageSizeSelect.style.cssText = 'margin-right: 15px; padding: 5px; border: 1px solid #ddd; border-radius: 3px;';
        pageSizeSelect.innerHTML = `
            <option value="25">25 entries</option>
            <option value="50">50 entries</option>
            <option value="100">100 entries</option>
            <option value="${totalRows}">All ${totalRows} entries</option>
        `;
        
        // Set saved preference
        var savedPageSize = localStorage.getItem('activity_page_length') || '25';
        pageSizeSelect.value = savedPageSize;
        
        // Add event listener
        pageSizeSelect.addEventListener('change', function() {
            var newPageSize = parseInt(this.value);
            localStorage.setItem('activity_page_length', newPageSize);
            
            // Show/hide rows based on selection
            var tableRows = document.querySelectorAll('#activity-log-table tbody tr');
            tableRows.forEach(function(row, index) {
                if (newPageSize >= totalRows || index < newPageSize) {
                    row.style.display = 'table-row';
                } else {
                    row.style.display = 'none';
                }
            });
            
            // Update display info
            var displayInfo = document.getElementById('pagination-info');
            if (displayInfo) {
                var visibleRows = Math.min(newPageSize, totalRows);
                displayInfo.textContent = `Showing ${visibleRows} of ${totalRows} activities`;
            }
            
            console.log('Page size changed to:', newPageSize);
        });
        
        // Add display info
        var displayInfo = document.createElement('span');
        displayInfo.id = 'pagination-info';
        displayInfo.style.cssText = 'margin-left: 15px; color: #666; font-size: 14px;';
        var visibleRows = Math.min(parseInt(savedPageSize), totalRows);
        displayInfo.textContent = `Showing ${visibleRows} of ${totalRows} activities`;
        
        // Assemble pagination
        paginationDiv.appendChild(pageSizeLabel);
        paginationDiv.appendChild(pageSizeSelect);
        paginationDiv.appendChild(displayInfo);
        
        // Insert after table
        tableContainer.appendChild(paginationDiv);
        
        // Add scroll indicator if content exceeds viewport
        addScrollIndicator(tableContainer, totalRows);
        
        // Apply initial page size limit
        if (parseInt(savedPageSize) < totalRows) {
            var tableRows = document.querySelectorAll('#activity-log-table tbody tr');
            tableRows.forEach(function(row, index) {
                if (index >= parseInt(savedPageSize)) {
                    row.style.display = 'none';
                }
            });
        }
        
        console.log('Simple pagination added - page size:', savedPageSize, 'total rows:', totalRows);
        
    } catch (error) {
        console.error('Error adding pagination:', error);
    }
}

// Add scroll indicator function
function addScrollIndicator(tableContainer, totalRows) {
    try {
        // Remove existing indicator
        var existingIndicator = document.getElementById('scroll-indicator');
        if (existingIndicator) {
            existingIndicator.remove();
        }
        
        // Create scroll indicator
        var scrollIndicator = document.createElement('div');
        scrollIndicator.id = 'scroll-indicator';
        scrollIndicator.style.cssText = `
            position: absolute;
            bottom: 10px;
            right: 15px;
            background: rgba(102, 126, 234, 0.9);
            color: white;
            padding: 5px 10px;
            border-radius: 15px;
            font-size: 12px;
            z-index: 5;
            display: none;
            box-shadow: 0 2px 5px rgba(0,0,0,0.2);
        `;
        scrollIndicator.innerHTML = '↓ Scroll for more activities';
        
        tableContainer.style.position = 'relative';
        tableContainer.appendChild(scrollIndicator);
        
        // Show/hide indicator based on scroll position
        tableContainer.addEventListener('scroll', function() {
            var scrollTop = this.scrollTop;
            var scrollHeight = this.scrollHeight;
            var clientHeight = this.clientHeight;
            var scrollPercentage = (scrollTop / (scrollHeight - clientHeight)) * 100;
            
            // Show indicator if not scrolled to bottom and there's content to scroll
            if (scrollPercentage < 90 && scrollHeight > clientHeight) {
                scrollIndicator.style.display = 'block';
            } else {
                scrollIndicator.style.display = 'none';
            }
        });
        
        // Initial check for scroll indicator
        setTimeout(function() {
            if (tableContainer.scrollHeight > tableContainer.clientHeight) {
                scrollIndicator.style.display = 'block';
                
                // Auto-hide after 3 seconds
                setTimeout(function() {
                    if (scrollIndicator.style.display === 'block') {
                        scrollIndicator.style.opacity = '0';
                        scrollIndicator.style.transition = 'opacity 0.5s';
                        setTimeout(function() {
                            scrollIndicator.style.display = 'none';
                            scrollIndicator.style.opacity = '1';
                        }, 500);
                    }
                }, 3000);
            }
        }, 500);
        
        console.log('Scroll indicator added');
        
    } catch (error) {
        console.error('Error adding scroll indicator:', error);
    }
}

// Function to get current filters
function getCurrentFilters() {
    try {
        var staffFilter = document.getElementById('staff-filter');
        var activityFilter = document.getElementById('activity-type-filter');
        var dateFrom = document.getElementById('date-from');
        var dateTo = document.getElementById('date-to');
        
        return {
            from: dateFrom ? dateFrom.value : '',
            to: dateTo ? dateTo.value : '',
            staff: staffFilter ? Array.from(staffFilter.selectedOptions).map(opt => opt.value) : [],
            activity_type: activityFilter ? Array.from(activityFilter.selectedOptions).map(opt => opt.value) : []
        };
    } catch (error) {
        console.error('Error getting current filters:', error);
        return {
            from: '',
            to: '',
            staff: [],
            activity_type: []
        };
    }
}function createEnhancedActivityRow(activity) {
    var row = document.createElement('tr');
    
    // Add CSS classes for enhanced styling
    if (activity.DT_RowClass) {
        row.className = activity.DT_RowClass;
    }
    
    if (activity.DT_RowId) {
        row.id = activity.DT_RowId;
    }
    
    // Enhanced date display with time ago
    var dateHtml = `
        <div>
            <strong>${activity.date || 'N/A'}</strong><br>
            <small class="text-muted">${activity.readable_date || ''}</small><br>
            ${activity.time_ago || ''}
        </div>
    `;
    
    // Enhanced staff display
    var staffHtml = `
        <div>
            <i class="fa fa-user"></i> ${activity.staff || 'System'}
            ${activity.staff_id ? `<br><small class="text-muted">ID: ${activity.staff_id}</small>` : ''}
        </div>
    `;
    
    // Enhanced lead display with contact info
    var leadHtml = activity.lead || 'N/A';
    
    // Enhanced followup type with icon and priority
    var followupTypeHtml = getEnhancedFollowupType(activity.followup_type, activity.priority);
    
    // Enhanced description with truncation
    var descriptionHtml = getEnhancedDescription(activity.description || activity.raw_description || 'No description');
    
    // Enhanced actions
    var actionsHtml = createEnhancedActions(activity);
    
    row.innerHTML = `
        <td>${dateHtml}</td>
        <td>${staffHtml}</td>
        <td>${leadHtml}</td>
        <td>${followupTypeHtml}</td>
        <td>${descriptionHtml}</td>
        <td>${actionsHtml}</td>
    `;
    
    return row;
}

function getEnhancedFollowupType(type, priority) {
    var icons = {
        'WhatsApp Message': 'fa-whatsapp',
        'WhatsApp Call': 'fa-whatsapp',
        'Phone Call': 'fa-phone',
        'Call': 'fa-phone',
        'Email': 'fa-envelope',
        'Message': 'fa-comment',
        'SMS': 'fa-comment',
        'Visit': 'fa-map-marker',
        'Meeting': 'fa-handshake-o',
        'Reminder': 'fa-clock-o',
        'Status Update': 'fa-refresh',
        'Proposal': 'fa-file-text',
        'Contract': 'fa-file-contract',
        'Invoice': 'fa-money',
        'Note': 'fa-sticky-note',
        'Assignment': 'fa-user-plus',
        'Demo': 'fa-play-circle',
        'Site Visit': 'fa-map-marker',
        'Activity Created': 'fa-plus-circle',
        'Activity Added': 'fa-plus',
        'General': 'fa-info-circle'
    };
    
    var colors = {
        'WhatsApp Message': 'success',
        'WhatsApp Call': 'success',
        'Phone Call': 'primary',
        'Call': 'primary',
        'Email': 'warning',
        'Message': 'info',
        'SMS': 'info',
        'Visit': 'danger',
        'Meeting': 'danger',
        'Reminder': 'default',
        'Status Update': 'info',
        'Note': 'default',
        'Activity Created': 'success',
        'Activity Added': 'success',
        'General': 'default'
    };
    
    var icon = icons[type] || 'fa-info-circle';
    var color = colors[type] || 'default';
    
    // Show only the followup type without priority indicators
    return `
        <span class="label label-${color}" style="font-size: 11px;">
            <i class="fa ${icon}"></i> ${type || 'General'}
        </span>
    `;
}

function getEnhancedDescription(description) {
    var maxLength = 100;
    var truncated = description.length > maxLength ? description.substring(0, maxLength) + '...' : description;
    
    return `
        <div title="${description}">
            ${truncated}
            ${description.length > maxLength ? 
                `<br><small><a href="#" onclick="showFullDescription('${description.replace(/'/g, "\\'")}'); return false;">Show more</a></small>` : 
                ''
            }
        </div>
    `;
}

function createEnhancedActions(activity) {
    var actions = [];
    
    if (activity.lead_id && activity.lead_id > 0) {
        actions.push(`
            <a href="${baseUrl}leads/index/${activity.lead_id}" class="btn btn-xs btn-primary" title="View Lead">
                <i class="fa fa-eye"></i>
            </a>
        `);
    }
    
    actions.push(`
        <button class="btn btn-xs btn-default" onclick="showActivityDetails(${activity.id})" title="Details">
            <i class="fa fa-info-circle"></i>
        </button>
    `);
    
    if (activity.followup_type !== 'General') {
        actions.push(`
            <button class="btn btn-xs btn-success" onclick="createFollowup(${activity.lead_id})" title="Create Follow-up">
                <i class="fa fa-plus"></i>
            </button>
        `);
    }
    
    return actions.join(' ');
}

function updateActivityStats(data) {
    var countElement = document.getElementById('activity-count');
    if (countElement && data) {
        var total = data.recordsTotal || 0;
        var filtered = data.recordsFiltered || 0;
        var displayed = (data.data && data.data.length) || 0;
        
        countElement.innerHTML = `
            Showing ${displayed} of ${filtered} activities
            ${total !== filtered ? ` (${total} total)` : ''}
        `;
    }
}

// Enhanced utility functions
function showFullDescription(description) {
    alert(description);
}

function showActivityDetails(activityId) {
    console.log('Show details for activity:', activityId);
    // Implement activity details modal
}

function createFollowup(leadId) {
    if (leadId) {
        window.location.href = baseUrl + 'leads/index/' + leadId + '#tab_notes';
    }
}

// Auto-refresh functionality
var autoRefreshInterval = null;
var autoRefreshEnabled = false;

function toggleAutoRefresh() {
    var button = document.getElementById('toggle-auto-refresh');
    var status = document.getElementById('auto-refresh-status');
    
    if (autoRefreshEnabled) {
        clearInterval(autoRefreshInterval);
        autoRefreshEnabled = false;
        status.textContent = 'OFF';
        button.classList.remove('btn-success');
        button.classList.add('btn-default');
    } else {
        autoRefreshInterval = setInterval(function() {
            applyFilters();
        }, 30000); // Refresh every 30 seconds
        autoRefreshEnabled = true;
        status.textContent = 'ON';
        button.classList.remove('btn-default');
        button.classList.add('btn-success');
    }
}

// Enhanced event listeners
document.addEventListener('DOMContentLoaded', function() {
    // Refresh button
    var refreshBtn = document.getElementById('refresh-activity-table');
    if (refreshBtn) {
        refreshBtn.addEventListener('click', function() {
            applyFilters();
        });
    }
    
    // Auto-refresh toggle
    var autoRefreshBtn = document.getElementById('toggle-auto-refresh');
    if (autoRefreshBtn) {
        autoRefreshBtn.addEventListener('click', toggleAutoRefresh);
    }
    
    // Search functionality
    var searchInput = document.getElementById('activity-search');
    var searchBtn = document.getElementById('search-activity');
    
    if (searchInput && searchBtn) {
        searchBtn.addEventListener('click', function() {
            // Implement search functionality
            console.log('Search for:', searchInput.value);
        });
        
        searchInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                searchBtn.click();
            }
        });
    }
});

// Function to load reminders
function loadReminders(data) {
    console.log('loadReminders called with data:', data);
    
    // Check if data has the expected structure
    if (!data || typeof data !== 'object') {
        console.error('Invalid reminders data:', data);
        return;
    }
    
    // Helper function to format reminder item
    function formatReminderItem(reminder, borderColor, dateColor, dateIcon) {
        var staffInfo = reminder.staff_name ? 
            '<small class="text-muted"><i class="fa fa-user"></i> ' + reminder.staff_name + '</small><br>' : '';
        
        var relatedInfo = '';
        if (reminder.related_name && reminder.related_name !== reminder.rel_type + ' #' + reminder.rel_id) {
            relatedInfo = '<small class="text-muted"><i class="fa fa-link"></i> ' + 
                         reminder.rel_type.charAt(0).toUpperCase() + reminder.rel_type.slice(1) + 
                         ': <strong>' + reminder.related_name + '</strong></small><br>';
        }
        
        var emailInfo = reminder.related_email ? 
            '<small class="text-muted"><i class="fa fa-envelope"></i> ' + reminder.related_email + '</small>' : '';
        
        return '<div class="list-group-item reminder-item" onclick="viewReminderDetails(\'' + 
               reminder.id + '\', \'' + reminder.rel_type + '\', \'' + reminder.rel_id + 
               '\')" style="cursor: pointer; transition: all 0.2s; border-left: 4px solid ' + borderColor + ';">' +
               '<div class="row">' +
               '<div class="col-md-8">' +
                   '<strong>' + (reminder.description || 'No description') + '</strong><br>' +
                   staffInfo +
                   relatedInfo +
                   emailInfo +
               '</div>' +
               '<div class="col-md-4 text-right">' +
                   '<small class="' + dateColor + '"><i class="fa ' + dateIcon + '"></i> ' + reminder.date + '</small><br>' +
                   '<small class="text-primary"><i class="fa fa-external-link"></i> Click to view</small>' +
               '</div>' +
               '</div></div>';
    }
    
    // Load today's reminders
    console.log('Processing today\'s reminders:', data.todays);
    if (data.todays && data.todays.length > 0) {
        var html = '<div class="list-group">';
        data.todays.forEach(function(reminder) {
            html += formatReminderItem(reminder, '#f39c12', 'text-warning', 'fa-clock-o');
        });
        html += '</div>';
        document.getElementById('todays-reminders').innerHTML = html;
        
        // Update heading with count
        var heading = document.querySelector('#todays-reminders').previousElementSibling;
        if (heading) {
            heading.innerHTML = '<i class="fa fa-bell text-warning"></i> Today\'s Reminders <span class="badge badge-warning">' + data.todays.length + '</span>';
        }
    } else {
        console.log('No today\'s reminders found');
        document.getElementById('todays-reminders').innerHTML = '<div class="text-muted text-center" style="padding: 20px;"><i class="fa fa-calendar-check-o fa-2x"></i><br>No reminders for today</div>';
    }
    
    // Load due reminders
    console.log('Processing due reminders:', data.due);
    if (data.due && data.due.length > 0) {
        var html = '<div class="list-group">';
        data.due.forEach(function(reminder) {
            html += formatReminderItem(reminder, '#e74c3c', 'text-danger', 'fa-exclamation-triangle');
        });
        html += '</div>';
        document.getElementById('due-reminders').innerHTML = html;
        
        // Update heading with count
        var heading = document.querySelector('#due-reminders').previousElementSibling;
        // Update heading with count
        var heading = document.querySelector('#due-reminders').previousElementSibling;
        if (heading) {
            heading.innerHTML = '<i class="fa fa-exclamation-triangle text-danger"></i> Due Reminders <span class="badge badge-danger">' + data.due.length + '</span>' +
                              '<br><small class="text-muted" style="font-weight: normal; font-size: 11px;">Unread missed reminders (excludes read/completed and lost/junk leads)</small>';
        }
    } else {
        console.log('No due reminders found');
        document.getElementById('due-reminders').innerHTML = '<div class="text-muted text-center" style="padding: 20px;"><i class="fa fa-check-circle fa-2x"></i><br>No unread missed reminders<br><small>All past reminders have been read or handled</small></div>';
    }
    
    // Load upcoming reminders
    if (data.upcoming && data.upcoming.length > 0) {
        var html = '<div class="list-group">';
        data.upcoming.forEach(function(reminder) {
            html += formatReminderItem(reminder, '#3498db', 'text-info', 'fa-calendar');
        });
        html += '</div>';
        document.getElementById('upcoming-reminders').innerHTML = html;
        
        // Update heading with count
        var heading = document.querySelector('#upcoming-reminders').previousElementSibling;
        if (heading) {
            heading.innerHTML = '<i class="fa fa-calendar text-info"></i> Upcoming Reminders <span class="badge badge-info">' + data.upcoming.length + '</span>';
        }
    } else {
        document.getElementById('upcoming-reminders').innerHTML = '<div class="text-muted text-center" style="padding: 20px;"><i class="fa fa-calendar-o fa-2x"></i><br>No upcoming reminders</div>';
    }
}

// Chart creation functions
function createActivitiesByStaffChart(chartData) {
    var ctx = document.getElementById('activitiesChart');
    if (!ctx) return;
    
    if (window.activitiesChart && typeof window.activitiesChart.destroy === 'function') {
        window.activitiesChart.destroy();
    }
    
    window.activitiesChart = new Chart(ctx, {
        type: 'bar',
        data: chartData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero: true
                    }
                }]
            }
        }
    });
}

function createActivitiesOverTimeChart(chartData) {
    var ctx = document.getElementById('activitiesOverTimeChart');
    if (!ctx) return;
    
    if (window.activitiesOverTimeChart && typeof window.activitiesOverTimeChart.destroy === 'function') {
        window.activitiesOverTimeChart.destroy();
    }
    
    window.activitiesOverTimeChart = new Chart(ctx, {
        type: 'line',
        data: chartData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero: true
                    }
                }]
            }
        }
    });
}

function createActivityTypesChart(chartData) {
    var ctx = document.getElementById('activityTypesChart');
    if (!ctx) return;
    
    if (window.activityTypesChart && typeof window.activityTypesChart.destroy === 'function') {
        window.activityTypesChart.destroy();
    }
    
    window.activityTypesChart = new Chart(ctx, {
        type: 'pie',
        data: chartData,
        options: {
            responsive: true,
            maintainAspectRatio: false
        }
    });
}

function createStaffPerformanceChart(chartData) {
    var ctx = document.getElementById('staffPerformanceChart');
    if (!ctx) return;
    
    if (window.staffPerformanceChart && typeof window.staffPerformanceChart.destroy === 'function') {
        window.staffPerformanceChart.destroy();
    }
    
    // Convert data format for stacked bar chart
    var datasets = [];
    if (chartData.datasets) {
        Object.keys(chartData.datasets).forEach(function(key) {
            datasets.push(chartData.datasets[key]);
        });
    }
    
    window.staffPerformanceChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: chartData.labels || [],
            datasets: datasets
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                xAxes: [{
                    stacked: true
                }],
                yAxes: [{
                    stacked: true,
                    ticks: {
                        beginAtZero: true
                    }
                }]
            }
        }
    });
}

function createFollowupTypesChart(chartData) {
    console.log('Creating follow-up types chart with data:', chartData);
    
    var ctx = document.getElementById('followupTypesChart');
    if (!ctx) {
        console.error('Follow-up types chart canvas not found');
        return;
    }
    
    if (window.followupTypesChart && typeof window.followupTypesChart.destroy === 'function') {
        window.followupTypesChart.destroy();
    }
    
    // Check if we have data
    if (!chartData || !chartData.labels || !chartData.data || chartData.labels.length === 0) {
        console.warn('No data available for follow-up types chart');
        // Show a message on the canvas
        var canvasParent = ctx.parentElement;
        canvasParent.innerHTML = '<div class="alert alert-info text-center" style="margin-top: 50px;">No follow-up data available for the selected period.</div>';
        return;
    }
    
    // Generate colors for pie chart
    var colors = [
        '#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b', 
        '#858796', '#2c9faf', '#6f42c1', '#17a673', '#fd7e14',
        '#20c997', '#6610f2', '#e83e8c', '#fd7e14', '#28a745'
    ];
    
    var backgroundColors = chartData.labels.map(function(label, index) {
        return colors[index % colors.length];
    });
    
    window.followupTypesChart = new Chart(ctx, {
        type: 'pie',
        data: {
            labels: chartData.labels,
            datasets: [{
                data: chartData.data,
                backgroundColor: backgroundColors,
                borderColor: '#fff',
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            legend: {
                position: 'bottom',
                labels: {
                    padding: 20,
                    usePointStyle: true
                }
            },
            tooltips: {
                callbacks: {
                    label: function(tooltipItem, data) {
                        var dataset = data.datasets[tooltipItem.datasetIndex];
                        var total = dataset.data.reduce(function(sum, value) {
                            return sum + value;
                        }, 0);
                        var currentValue = dataset.data[tooltipItem.index];
                        var percentage = Math.round((currentValue / total) * 100);
                        return data.labels[tooltipItem.index] + ': ' + currentValue + ' (' + percentage + '%)';
                    }
                }
            }
        }
    });
}

// Function to view activity details
function viewActivityDetails(activityId) {
    // For now, just show basic info
    var modal = document.getElementById('rdLogModal');
    var modalBody = document.getElementById('rd-log-details');
    
    if (modal && modalBody) {
        modalBody.innerHTML = '<div class="text-center">' +
            '<h4>Activity Details</h4>' +
            '<p><strong>Activity ID:</strong> ' + activityId + '</p>' +
            '<p>Detailed information for this activity would be displayed here.</p>' +
            '</div>';
        
        // Show the modal using vanilla JavaScript
        modal.style.display = 'block';
    }
}

// Function to view reminder details
function viewReminderDetails(reminderId, relType, relId) {
    // Get the admin base URL from PHP
    var adminBaseUrl = '<?php echo admin_url(); ?>';
    
    // Determine the appropriate URL based on the related type
    var targetUrl = '';
    
    switch(relType) {
        case 'lead':
            targetUrl = adminBaseUrl + 'leads/index/' + relId;
            break;
        case 'client':
            targetUrl = adminBaseUrl + 'clients/client/' + relId;
            break;
        case 'task':
            targetUrl = adminBaseUrl + 'tasks/view/' + relId;
            break;
        case 'project':
            targetUrl = adminBaseUrl + 'projects/view/' + relId;
            break;
        case 'invoice':
            targetUrl = adminBaseUrl + 'invoices/list_invoices/' + relId;
            break;
        case 'estimate':
            targetUrl = adminBaseUrl + 'estimates/list_estimates/' + relId;
            break;
        case 'proposal':
            targetUrl = adminBaseUrl + 'proposals/list_proposals/' + relId;
            break;
        case 'contract':
            targetUrl = adminBaseUrl + 'contracts/contract/' + relId;
            break;
        case 'expense':
            targetUrl = adminBaseUrl + 'expenses/expense/' + relId;
            break;
        case 'credit_note':
            targetUrl = adminBaseUrl + 'credit_notes/list_credit_notes/' + relId;
            break;
        default:
            // For unknown types, try to show in a modal
            showReminderModal(reminderId, relType, relId);
            return;
    }
    
    // Navigate to the target page
    if (targetUrl) {
        window.open(targetUrl, '_blank');
    }
}

// Function to show reminder details in modal
function showReminderModal(reminderId, relType, relId) {
    var modal = document.getElementById('rdLogModal');
    var modalBody = document.getElementById('rd-log-details');
    
    if (modal && modalBody) {
        modalBody.innerHTML = '<div class="text-center">' +
            '<i class="fa fa-bell fa-3x text-warning" style="margin-bottom: 15px;"></i>' +
            '<h4>Reminder Details</h4>' +
            '<div class="well text-left" style="margin: 20px 0;">' +
                '<p><strong><i class="fa fa-hashtag"></i> Reminder ID:</strong> ' + reminderId + '</p>' +
                '<p><strong><i class="fa fa-tag"></i> Type:</strong> ' + relType.charAt(0).toUpperCase() + relType.slice(1) + '</p>' +
                '<p><strong><i class="fa fa-link"></i> Related ID:</strong> ' + relId + '</p>' +
            '</div>' +
            '<div class="alert alert-info">' +
                '<i class="fa fa-info-circle"></i> This reminder is linked to a <strong>' + relType + '</strong> with ID <strong>' + relId + '</strong>.' +
                '<br>The system could not determine the exact page to navigate to for this item type.' +
            '</div>' +
            '<div class="text-center">' +
                '<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>' +
            '</div>' +
            '</div>';
        
        // Show the modal using Bootstrap if available, otherwise vanilla JS
        if (typeof $ !== 'undefined' && $.fn.modal) {
            $(modal).modal('show');
        } else {
            modal.style.display = 'block';
            modal.classList.add('in');
        }
    }
}

// Function to set up event listeners
function setupEventListeners() {
    // Apply filters button
    document.getElementById('apply-filters').addEventListener('click', applyFilters);
    
    // Refresh dropdowns button
    document.getElementById('refresh-dropdowns').addEventListener('click', function() {
        console.log('[Reporting Dashboard] Manual refresh requested');
        
        // Reinitialize date pickers
        try {
            console.log('[Reporting Dashboard] Refreshing date inputs');
            // Ensure HTML5 date inputs are properly set
            if (typeof $ !== 'undefined') {
                $('#date-from, #date-to, #activity-date-from, #activity-date-to').attr('type', 'date');
                
                // Optional: Refresh Bootstrap datepicker if it exists
                if ($.fn.datepicker && $('.datepicker').length > 0) {
                    $('.datepicker').datepicker('destroy');
                    $('.datepicker').datepicker({
                        format: 'yyyy-mm-dd',
                        autoclose: true,
                        todayHighlight: true,
                        clearBtn: true,
                        orientation: 'bottom auto'
                    });
                }
            } else {
                // Fallback for vanilla JS
                var dateInputs = document.querySelectorAll('#date-from, #date-to, #activity-date-from, #activity-date-to');
                for (var i = 0; i < dateInputs.length; i++) {
                    dateInputs[i].type = 'date';
                }
            }
            console.log('[Reporting Dashboard] Date inputs refreshed');
        } catch (error) {
            console.error('[Reporting Dashboard] Date input refresh failed:', error);
        }
        
        // Reinitialize dropdowns
        try {
            if (typeof $ !== 'undefined' && $.fn.selectpicker) {
                $('#staff-filter, #activity-type-filter').selectpicker('destroy');
                
                setTimeout(function() {
                    // Set Bootstrap version manually
                    if ($.fn.selectpicker.Constructor) {
                        $.fn.selectpicker.Constructor.BootstrapVersion = '3.3.7';
                    }
                    
                    $('#staff-filter').selectpicker({
                        liveSearch: true,
                        actionsBox: true,
                        noneSelectedText: 'Select Staff Members',
                        style: 'btn-default'
                    });
                    
                    $('#activity-type-filter').selectpicker({
                        noneSelectedText: 'Select Activity Types',
                        style: 'btn-default'
                    });
                    
                    console.log('[Reporting Dashboard] Dropdowns manually refreshed');
                }, 100);
            }
        } catch (error) {
            console.error('[Reporting Dashboard] Dropdown refresh failed:', error);
        }
    });
    
    // Selectpicker change events
    if (typeof $ !== 'undefined' && $.fn.selectpicker) {
        $('#staff-filter').on('changed.bs.select', function() {
            console.log('Staff filter changed');
        });
        
        $('#activity-type-filter').on('changed.bs.select', function() {
            console.log('Activity type filter changed');
        });
    }
    
    // Sync main date filters with activity date filters
    document.getElementById('date-from').addEventListener('change', function() {
        document.getElementById('activity-date-from').value = this.value;
    });
    
    document.getElementById('date-to').addEventListener('change', function() {
        document.getElementById('activity-date-to').value = this.value;
    });
    
    // Sync activity date filters with main date filters
    document.getElementById('activity-date-from').addEventListener('change', function() {
        document.getElementById('date-from').value = this.value;
    });
    
    document.getElementById('activity-date-to').addEventListener('change', function() {
        document.getElementById('date-to').value = this.value;
    });
    
    // Date preset buttons
    document.querySelectorAll('.preset-btn').forEach(function(btn) {
        btn.addEventListener('click', function() {
            // Remove active class from all buttons
            document.querySelectorAll('.preset-btn').forEach(b => b.classList.remove('active'));
            // Add active class to clicked button
            this.classList.add('active');
            
            var preset = this.dataset.preset;
            var today = new Date();
            var fromDate, toDate;
            
            switch(preset) {
                case 'today':
                    fromDate = today.toISOString().split('T')[0];
                    toDate = today.toISOString().split('T')[0];
                    break;
                case 'week':
                    var dayOfWeek = today.getDay();
                    var diff = today.getDate() - dayOfWeek + (dayOfWeek === 0 ? -6 : 1);
                    fromDate = new Date(today.setDate(diff)).toISOString().split('T')[0];
                    toDate = new Date().toISOString().split('T')[0];
                    break;
                case 'month':
                    fromDate = new Date(today.getFullYear(), today.getMonth(), 1).toISOString().split('T')[0];
                    toDate = new Date().toISOString().split('T')[0];
                    break;
            }
            
            document.getElementById('date-from').value = fromDate;
            document.getElementById('date-to').value = toDate;
            
            // Apply filters
            applyFilters();
        });
    });
    
    // Activity log date filter
    document.getElementById('activity-apply-filter').addEventListener('click', function() {
        var activityFilters = {
            from: document.getElementById('activity-date-from').value,
            to: document.getElementById('activity-date-to').value,
            staff: Array.from(document.getElementById('staff-filter').selectedOptions).map(opt => opt.value),
            activity_type: Array.from(document.getElementById('activity-type-filter').selectedOptions).map(opt => opt.value)
        };
        
        // Synchronize main date filters with activity log date filters
        if (activityFilters.from) {
            document.getElementById('date-from').value = activityFilters.from;
        }
        if (activityFilters.to) {
            document.getElementById('date-to').value = activityFilters.to;
        }
        
        // Apply all filters (this will reload everything including activity log)
        applyFilters();
    });
    
    // PDF export button
    document.getElementById('export-pdf').addEventListener('click', function() {
        var currentFilters = {
            from: document.getElementById('date-from').value,
            to: document.getElementById('date-to').value,
            staff: Array.from(document.getElementById('staff-filter').selectedOptions).map(opt => opt.value),
            activity_type: Array.from(document.getElementById('activity-type-filter').selectedOptions).map(opt => opt.value)
        };
        
        var pdfUrl = baseUrl + 'reporting_dashboard/download_pdf?' + new URLSearchParams(currentFilters);
        window.open(pdfUrl, '_blank');
    });
    
    // CSV export button
    document.getElementById('export-csv').addEventListener('click', function() {
        // Implement CSV export
        alert('CSV export functionality will be implemented here');
    });
    
    // Excel export button
    document.getElementById('export-excel').addEventListener('click', function() {
        // Implement Excel export
        alert('Excel export functionality will be implemented here');
    });
    
    // Print button
    document.getElementById('export-print').addEventListener('click', function() {
        window.print();
    });
    
    // Table export buttons
    document.getElementById('table-export-csv').addEventListener('click', function() {
        // Implement table CSV export
        alert('Table CSV export functionality will be implemented here');
    });
    
    document.getElementById('table-export-excel').addEventListener('click', function() {
        // Implement table Excel export
        alert('Table Excel export functionality will be implemented here');
    });
}

// Initialize when document is ready - with jQuery safety
(function() {
    'use strict';
    
    var initAttempts = 0;
    var maxAttempts = 50; // 5 seconds maximum wait
    
    function waitForJQuery() {
        initAttempts++;
        
        if (typeof jQuery !== 'undefined' && jQuery.fn && jQuery.fn.jquery) {
            console.log('[Reporting Dashboard] jQuery available after', initAttempts, 'attempts, version:', jQuery.fn.jquery);
            jQuery(document).ready(function($) {
                initializeDashboard($);
            });
            return;
        }
        
        if (initAttempts >= maxAttempts) {
            console.error('[Reporting Dashboard] jQuery not available after', maxAttempts, 'attempts');
            // Try to initialize with basic JavaScript
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', function() {
                    initializeDashboard(null);
                });
            } else {
                initializeDashboard(null);
            }
            return;
        }
        
        setTimeout(waitForJQuery, 100);
    }
    
    function initializeDashboard($) {
        console.log('[Reporting Dashboard] Document ready, initializing...');
        
        // Debug: Staff list data passed from PHP
        var staffListData = <?php echo json_encode($staff_list ?? []); ?>;
        var canViewAllStaff = <?php echo json_encode($can_view_all_staff ?? false); ?>;
        var userStaffId = <?php echo json_encode($user_staff_id ?? 0); ?>;
        console.log('[Reporting Dashboard] Staff list data:', staffListData);
        console.log('[Reporting Dashboard] Can view all staff:', canViewAllStaff);
        console.log('[Reporting Dashboard] Current user staff ID:', userStaffId);
        
        if (!$ && typeof jQuery !== 'undefined') {
            $ = jQuery;
        }
        
        // Initialize date pickers (simplified for HTML5 date inputs)
        function initializeDatePickers() {
            console.log('[Reporting Dashboard] Initializing date pickers...');
            
            // If jQuery is not available, use vanilla JavaScript fallback
            if (!$) {
                var dateInputs = document.querySelectorAll('#date-from, #date-to, #activity-date-from, #activity-date-to');
                for (var i = 0; i < dateInputs.length; i++) {
                    dateInputs[i].type = 'date';
                }
                return dateInputs.length > 0;
            }
            
            try {
                // Since we're using HTML5 date inputs, just ensure they're properly set up
                var dateInputs = $('#date-from, #date-to, #activity-date-from, #activity-date-to');
                dateInputs.attr('type', 'date');
                
                // Optional: Try to enhance with Bootstrap datepicker if available
                if ($.fn.datepicker && dateInputs.hasClass('datepicker')) {
                console.log('[Reporting Dashboard] Enhancing with Bootstrap datepicker');
                $('.datepicker').datepicker({
                    format: 'yyyy-mm-dd',
                    autoclose: true,
                    todayHighlight: true,
                    clearBtn: true,
                    orientation: 'bottom auto'
                });
            }
            
            console.log('[Reporting Dashboard] Date inputs initialized successfully');
            return true;
        } catch (error) {
            console.error('[Reporting Dashboard] Date picker initialization failed:', error);
            // Ensure HTML5 date inputs as fallback
            $('#date-from, #date-to, #activity-date-from, #activity-date-to').attr('type', 'date');
            return true;
        }
    }
    
    // Initialize selectpicker dropdowns using multiple methods
    function initializeDropdowns() {
        console.log('[Reporting Dashboard] Initializing dropdowns...');
        
        try {
            // Method 1: Manual Bootstrap Select initialization (more reliable)
            if ($.fn.selectpicker) {
                console.log('[Reporting Dashboard] Using direct selectpicker initialization');
                
                // Destroy any existing instances first
                $('#staff-filter, #activity-type-filter').selectpicker('destroy');
                
                // Set Bootstrap version manually to avoid detection issues
                if ($.fn.selectpicker.Constructor && !$.fn.selectpicker.Constructor.BootstrapVersion) {
                    $.fn.selectpicker.Constructor.BootstrapVersion = '3.3.7';
                }
                
                // Initialize staff filter
                $('#staff-filter').selectpicker({
                    liveSearch: true,
                    actionsBox: true,
                    noneSelectedText: 'Select Staff Members',
                    selectAllText: 'Select All',
                    deselectAllText: 'Deselect All',
                    countSelectedText: function(numSelected, numTotal) {
                        return numSelected + ' of ' + numTotal + ' selected';
                    },
                    style: 'btn-default',
                    size: 10
                });
                
                // Initialize activity type filter  
                $('#activity-type-filter').selectpicker({
                    noneSelectedText: 'Select Activity Types',
                    countSelectedText: function(numSelected, numTotal) {
                        return numSelected + ' of ' + numTotal + ' selected';
                    },
                    style: 'btn-default',
                    size: 10
                });
                
                console.log('[Reporting Dashboard] Direct selectpicker initialization successful');
                return true;
            }
        } catch (error) {
            console.warn('[Reporting Dashboard] Direct selectpicker failed:', error);
        }
        
        try {
            // Method 2: Try Perfex's init_selectpicker function as fallback
            if (typeof init_selectpicker === 'function') {
                console.log('[Reporting Dashboard] Trying Perfex init_selectpicker as fallback');
                init_selectpicker();
                console.log('[Reporting Dashboard] Perfex init_selectpicker successful');
                return true;
            }
        } catch (error) {
            console.warn('[Reporting Dashboard] Perfex init_selectpicker failed:', error);
        }
        
        // Method 3: Fallback - ensure dropdowns are at least functional
        console.warn('[Reporting Dashboard] Using fallback dropdown initialization');
        $('#staff-filter, #activity-type-filter').addClass('form-control');
        
        return false;
    }
    
    // Initialize both date pickers and dropdowns
    var datePickersInitialized = initializeDatePickers();
    var dropdownsInitialized = initializeDropdowns();
    
    // Set initial date values
    function setInitialDates() {
        var today = new Date();
        // Use last 60 days instead of current month to capture more test data
        var startDay = new Date(today);
        startDay.setDate(today.getDate() - 60);
        var todayStr = today.toISOString().split('T')[0];
        var startDayStr = startDay.toISOString().split('T')[0];
        
        // Set main filter dates
        $('#date-from').val(startDayStr);
        $('#date-to').val(todayStr);
        
        // Set activity log filter dates
        $('#activity-date-from').val(startDayStr);
        $('#activity-date-to').val(todayStr);
        
        console.log('[Reporting Dashboard] Initial dates set:', startDayStr, 'to', todayStr);
    }
    
    // Set dates after a brief delay to ensure elements are ready
    setTimeout(setInitialDates, 100);
    
    // Add change event handlers for dropdowns
    $('#staff-filter').on('changed.bs.select change', function() {
        console.log('[Reporting Dashboard] Staff filter changed');
    });
    
    $('#activity-type-filter').on('changed.bs.select change', function() {
        console.log('[Reporting Dashboard] Activity type filter changed'); 
    });
    
    // Add change event handlers for date inputs
    $('#date-from, #date-to').on('change changeDate', function() {
        console.log('[Reporting Dashboard] Date filter changed');
    });
    
    // Add diagnostic information to console
    setTimeout(function() {
        console.log('[Reporting Dashboard] DIAGNOSTIC INFO:');
        console.log('- jQuery available:', typeof $ !== 'undefined');
        console.log('- jQuery version:', typeof $ !== 'undefined' ? $.fn.jquery : 'N/A');
        console.log('- Bootstrap Select available:', typeof $ !== 'undefined' && $.fn.selectpicker);
        console.log('- Datepicker available:', typeof $ !== 'undefined' && $.fn.datepicker);
        console.log('- appDatepicker function available:', typeof appDatepicker === 'function');
        console.log('- init_selectpicker function available:', typeof init_selectpicker === 'function');
        
        // Only run jQuery-dependent diagnostics if $ is available
        if (typeof $ !== 'undefined') {
            console.log('- Staff filter element exists:', $('#staff-filter').length > 0);
            console.log('- Activity filter element exists:', $('#activity-type-filter').length > 0);
            console.log('- Date from element exists:', $('#date-from').length > 0);
            console.log('- Date to element exists:', $('#date-to').length > 0);
            console.log('- Staff options count:', $('#staff-filter option').length);
            console.log('- Activity options count:', $('#activity-type-filter option').length);
            
            // Check if elements are properly initialized
            var staffBootstrap = $('#staff-filter').parent().hasClass('bootstrap-select');
            var activityBootstrap = $('#activity-type-filter').parent().hasClass('bootstrap-select');
            console.log('- Staff filter has bootstrap-select wrapper:', staffBootstrap);
            console.log('- Activity filter has bootstrap-select wrapper:', activityBootstrap);
            
            // Check date picker initialization
            var dateFromInit = $('#date-from').hasClass('hasDatepicker') || $('#date-from').attr('type') === 'date';
            var dateToInit = $('#date-to').hasClass('hasDatepicker') || $('#date-to').attr('type') === 'date';
            console.log('- Date from initialized:', dateFromInit);
            console.log('- Date to initialized:', dateToInit);
        } else {
            console.log('- Skipping jQuery-dependent diagnostics ($ not available)');
        }
        
        // Retry initialization if needed (only if jQuery is available)
        if (typeof $ !== 'undefined') {
            if (!staffBootstrap || !activityBootstrap) {
                console.warn('[Reporting Dashboard] Dropdowns not properly initialized, retrying...');
                setTimeout(function() {
                    initializeDropdowns();
                }, 500);
            }
            
            if (!dateFromInit || !dateToInit) {
                console.warn('[Reporting Dashboard] Date pickers not properly initialized, retrying...');
                setTimeout(function() {
                    initializeDatePickers();
                }, 500);
            }
        }
    }, 1000);
    
    // Wait a moment for everything to settle, then initialize charts and data
    setTimeout(function() {
        // Initialize charts if Chart.js is available
        if (typeof Chart !== 'undefined') {
            loadCharts(baseUrl, {});
        } else {
            console.error('[Reporting Dashboard] Chart.js not loaded');
        }
        
        // Load initial data
        applyFilters();
        
        // Set up event listeners
        setupEventListeners();
        
        // Force table render
        setTimeout(function() {
            forceTableRender();
        }, 1000);
        
    }, 1500);
    
    } // End initializeDashboard function
    
    // Start waiting for jQuery
    waitForJQuery();
})();

// Global functions for dashboard functionality
function updateDealerStatistics(data) {
    console.log('Updating dealer statistics:', data);
    
    // Update KPI numbers
    document.getElementById('dealer-total').textContent = data.total_dealers || 0;
    document.getElementById('dealer-interested').textContent = data.interested_dealers || 0;
    document.getElementById('dealer-not-interested').textContent = data.not_interested_dealers || 0;
    document.getElementById('dealer-no-response').textContent = data.no_response_dealers || 0;
    
    // Badges are no longer needed since we removed the separate dealer list sections
    
    // Calculate percentages
    var total = data.total_dealers || 0;
    if (total > 0) {
        var interestedPct = Math.round((data.interested_dealers || 0) / total * 100);
        var notInterestedPct = Math.round((data.not_interested_dealers || 0) / total * 100);
        var noResponsePct = Math.round((data.no_response_dealers || 0) / total * 100);
        
        document.getElementById('dealer-interested-percentage').textContent = interestedPct + '%';
        document.getElementById('dealer-not-interested-percentage').textContent = notInterestedPct + '%';
        document.getElementById('dealer-no-response-percentage').textContent = noResponsePct + '%';
    } else {
        document.getElementById('dealer-interested-percentage').textContent = '0%';
        document.getElementById('dealer-not-interested-percentage').textContent = '0%';
        document.getElementById('dealer-no-response-percentage').textContent = '0%';
    }
}



function displayFollowupTypesByStaff(data) {
    console.log('Displaying follow-up types by staff:', data);
    
    var container = document.getElementById('followup-types-by-staff');
    if (!container) {
        console.error('Follow-up types container not found');
        return;
    }
    
    if (!data || Object.keys(data).length === 0) {
        container.innerHTML = '<div class="alert alert-info">No follow-up data available for the selected period.</div>';
        return;
    }
    
    // Build table HTML
    var html = '<div class="table-responsive">';
    html += '<table class="table table-striped table-bordered">';
    html += '<thead><tr style="background-color: #f8f9fa;">';
    html += '<th>Staff Member</th>';
    
    // Get all unique follow-up types
    var allTypes = new Set();
    Object.values(data).forEach(function(staffData) {
        staffData.forEach(function(item) {
            allTypes.add(item.followup_type);
        });
    });
    
    // Add column headers for each type
    Array.from(allTypes).forEach(function(type) {
        html += '<th class="text-center">' + type + '</th>';
    });
    html += '<th class="text-center" style="background-color: #e9ecef;"><strong>Total</strong></th>';
    html += '</tr></thead><tbody>';
    
    // Add data rows
    Object.keys(data).forEach(function(staffName, index) {
        html += '<tr' + (index % 2 === 0 ? ' style="background-color: #f9f9f9;"' : '') + '>';
        html += '<td><strong>' + staffName + '</strong></td>';
        
        var staffData = data[staffName];
        var rowTotal = 0;
        
        Array.from(allTypes).forEach(function(type) {
            var count = 0;
            staffData.forEach(function(item) {
                if (item.followup_type === type) {
                    count = item.count;
                }
            });
            rowTotal += count;
            html += '<td class="text-center">' + (count > 0 ? '<span class="badge badge-primary">' + count + '</span>' : '0') + '</td>';
        });
        
        html += '<td class="text-center" style="background-color: #e9ecef;"><strong>' + rowTotal + '</strong></td>';
        html += '</tr>';
    });
    
    html += '</tbody></table></div>';
    
    container.innerHTML = html;
}

// Dealer List Modal Functions
function openDealerModal(type) {
    console.log('Opening dealer modal for type:', type);
    
    // Set modal title based on type
    var titleMap = {
        'interested': 'Interested Dealers',
        'not_interested': 'Not Interested Dealers',
        'no_response': 'No Response Dealers'
    };
    
    document.getElementById('modal-title-text').textContent = titleMap[type] || 'Dealer List';
    
    // Load dealer data
    loadDealerModalData(type);
    
    // Show modal
    $('#dealerListModal').modal('show');
}

function loadDealerModalData(type) {
    console.log('Loading dealer modal data for type:', type);
    
    // Get current filters
    var filters = getCurrentFilters();
    
    // Show loading state
    document.getElementById('dealerListTableBody').innerHTML = '<tr><td colspan="6" class="text-center">Loading...</td></tr>';
    
    // Build query string
    var queryParams = new URLSearchParams(filters);
    var queryString = queryParams.toString();
    
    // Load dealer data
    safeFetch(baseUrl + 'reporting_dashboard/get_dealer_list?interest_status=' + type + '&' + queryString, {
        method: 'GET'
    })
    .then(response => {
        if (!response.ok) {
            throw new Error(`HTTP ${response.status}: ${response.statusText}`);
        }
        return response.json();
    })
    .then(data => {
        console.log('Dealer modal data received:', data);
        displayDealerModalData(data.data || []);
        setupDealerModalEvents(type);
    })
    .catch(error => {
        console.error('Dealer modal data load failed:', error.message);
        document.getElementById('dealerListTableBody').innerHTML = '<tr><td colspan="6" class="text-center text-danger">Error loading dealer data: ' + error.message + '</td></tr>';
    });
}

function displayDealerModalData(dealers) {
    var tbody = document.getElementById('dealerListTableBody');
    
    if (dealers.length === 0) {
        tbody.innerHTML = '<tr><td colspan="7" class="text-center text-muted">No dealers found</td></tr>';
        return;
    }
    var html = '';
    dealers.forEach(function(dealer) {
        html += '<tr>';
        html += '<td>' + (dealer.name || 'N/A') + '</td>';
        html += '<td>' + (dealer.company || 'N/A') + '</td>';
        html += '<td>' + (dealer.email || 'N/A') + '</td>';
        html += '<td>' + (dealer.phonenumber || 'N/A') + '</td>';
        html += '<td>' + (dealer.dateadded ? new Date(dealer.dateadded).toLocaleDateString() : 'N/A') + '</td>';
        html += '<td>' + (dealer.interest_date ? new Date(dealer.interest_date).toLocaleDateString() : 'N/A') + '</td>';
        // Add View button if lead_id or id is present, else show debug info
        var leadId = dealer.lead_id || dealer.id;
        if (leadId) {
            html += '<td><button class="btn btn-xs btn-primary view-lead-btn" data-lead-id="' + leadId + '"><i class="fa fa-eye"></i> View</button></td>';
        } else {
            html += '<td style="color:red;font-size:11px;">No lead_id<br><span style="color:#888;">Debug: ' + JSON.stringify(dealer) + '</span></td>';
        }
        html += '</tr>';
    });
    tbody.innerHTML = html;
}

function setupDealerModalEvents(type) {
    // Setup search functionality
    var searchInput = document.getElementById('dealerSearchInput');
    var clearBtn = document.getElementById('clearSearchBtn');
    var downloadBtn = document.getElementById('downloadDealerListBtn');
    
    // Clear previous event listeners
    searchInput.onkeyup = null;
    clearBtn.onclick = null;
    downloadBtn.onclick = null;
    
    // Search functionality
    searchInput.onkeyup = function() {
        var searchTerm = this.value.toLowerCase();
        var rows = document.querySelectorAll('#dealerListTableBody tr');
        
        rows.forEach(function(row) {
            var text = row.textContent.toLowerCase();
            if (text.includes(searchTerm)) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    };
    
    // Clear search
    clearBtn.onclick = function() {
        searchInput.value = '';
        var rows = document.querySelectorAll('#dealerListTableBody tr');
        rows.forEach(function(row) {
            row.style.display = '';
        });
    };
    
    // Download functionality
    downloadBtn.onclick = function() {
        downloadDealerList(type);
    };
}

function downloadDealerList(type) {
    console.log('Downloading dealer list for type:', type);
    
    // Get current filters
    var filters = getCurrentFilters();
    
    // Build query string
    var queryParams = new URLSearchParams(filters);
    var queryString = queryParams.toString();
    
    // Create download URL
    var downloadUrl = baseUrl + 'reporting_dashboard/download_dealers_list?interest_status=' + type + '&' + queryString;
    
    // Trigger download
    window.open(downloadUrl, '_blank');
}

function getCurrentFilters() {
    // Safely get form values with null checks - using correct IDs
    var dateFromElement = document.getElementById('date-from');
    var dateToElement = document.getElementById('date-to');
    
    console.log('Getting current filters...');
    console.log('Date from element:', dateFromElement);
    console.log('Date to element:', dateToElement);
    
    var filters = {
        from: (dateFromElement && dateFromElement.value) ? dateFromElement.value : '',
        to: (dateToElement && dateToElement.value) ? dateToElement.value : '',
        staff: getSelectedStaffIds(),
        activity_type: getSelectedActivityTypes()
    };
    
    console.log('Current filters:', filters);
    return filters;
}

function getSelectedStaffIds() {
    var staffSelect = document.getElementById('staff-filter');
    if (!staffSelect) {
        console.log('Staff filter element not found, returning empty array');
        return [];
    }
    
    var selected = [];
    for (var i = 0; i < staffSelect.options.length; i++) {
        if (staffSelect.options[i].selected) {
            selected.push(staffSelect.options[i].value);
        }
    }
    return selected;
}

function getSelectedActivityTypes() {
    var activitySelect = document.getElementById('activity-type-filter');
    if (!activitySelect) {
        console.log('Activity type filter element not found, returning empty array');
        return [];
    }
    
    var selected = [];
    for (var i = 0; i < activitySelect.options.length; i++) {
        if (activitySelect.options[i].selected) {
            selected.push(activitySelect.options[i].value);
        }
    }
    return selected;
}
</script>

<!-- Dealer List Modal -->
<div class="modal fade" id="dealerListModal" tabindex="-1" role="dialog" aria-labelledby="dealerListModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="dealerListModalLabel">
          <i class="fa fa-users"></i> <span id="modal-title-text">Dealer List</span>
        </h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row mb-3">
          <div class="col-md-6">
            <div class="input-group">
              <input type="text" class="form-control" id="dealerSearchInput" placeholder="Search dealers...">
              <div class="input-group-append">
                <button class="btn btn-outline-secondary" type="button" id="clearSearchBtn">
                  <i class="fa fa-times"></i>
                </button>
              </div>
            </div>
          </div>
          <div class="col-md-6 text-right">
            <button class="btn btn-success" id="downloadDealerListBtn">
              <i class="fa fa-download"></i> Download CSV
            </button>
          </div>
        </div>
        <div class="table-responsive">
          <table class="table table-striped table-hover" id="dealerListTable">
            <thead class="thead-dark">
              <tr>
                <th>Name</th>
                <th>Company</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Date Added</th>
                <th>Interest Date</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody id="dealerListTableBody">
              <!-- Dealer data will be loaded here -->
            </tbody>
          </table>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<?php init_tail(); ?>
