<?php
// Manual database upgrade script
// IMPORTANT: This should only be run once and then deleted
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Manual Database Upgrade Script</h2>";
echo "<p><strong>Warning:</strong> Make sure you have a database backup before proceeding!</p>";

// Set the execution time limit
set_time_limit(300); // 5 minutes

try {
    // Load CodeIgniter core files
    define('BASEPATH', 'system/');
    require_once 'application/config/database.php';
    require_once 'application/config/app-config.php';
    
    // Simple database connection to check current version
    $conn = new mysqli($db['default']['hostname'], 
                       $db['default']['username'], 
                       $db['default']['password'], 
                       $db['default']['database']);
    
    if ($conn->connect_error) {
        throw new Exception("Connection failed: " . $conn->connect_error);
    }
    
    // Get current version
    $result = $conn->query("SELECT version FROM " . $db['default']['dbprefix'] . "migrations ORDER BY version DESC LIMIT 1");
    if ($result && $row = $result->fetch_assoc()) {
        $currentVersion = $row['version'];
        echo "<p>Current database version: $currentVersion (" . wordwrap($currentVersion, 1, '.', true) . ")</p>";
        
        if ($currentVersion >= 332) {
            echo "<p><strong style='color: green;'>Database is already up to date!</strong></p>";
            exit;
        }
        
        echo "<p>Target version: 332 (3.3.2)</p>";
        echo "<p>Running migrations from " . ($currentVersion + 1) . " to 332...</p>";
        
        // Run each missing migration
        for ($version = $currentVersion + 1; $version <= 332; $version++) {
            $versionFormatted = sprintf('%03d', $version);
            $migrationFile = "application/migrations/{$versionFormatted}_version_{$versionFormatted}.php";
            
            if (file_exists($migrationFile)) {
                echo "<p>Running migration $versionFormatted... ";
                
                // Include the migration file
                include_once $migrationFile;
                $className = "Migration_Version_$versionFormatted";
                
                if (class_exists($className)) {
                    // This is a simplified approach - in a real scenario, 
                    // you'd want to use CodeIgniter's migration library
                    echo " <span style='color: orange;'>Migration file found</span></p>";
                } else {
                    echo " <span style='color: red;'>Migration class not found</span></p>";
                }
            } else {
                echo "<p>Migration file $migrationFile not found</p>";
            }
        }
        
        echo "<hr>";
        echo "<h3>Recommended Action:</h3>";
        echo "<p><strong>1.</strong> Go to your admin panel: <a href='https://crm.ibrayagroup.com/admin' target='_blank'>https://crm.ibrayagroup.com/admin</a></p>";
        echo "<p><strong>2.</strong> You should see the database upgrade prompt</p>";
        echo "<p><strong>3.</strong> Click 'Upgrade now' to complete the migration</p>";
        echo "<p><strong>4.</strong> The system will automatically run the proper migration process</p>";
        
    } else {
        echo "<p><strong>Error:</strong> Could not read current database version</p>";
    }
    
    $conn->close();
    
} catch (Exception $e) {
    echo "<p><strong>Error:</strong> " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<p><small>Delete this file after completing the upgrade!</small></p>";
?>
