<?php
// Run this script to install/update the reporting dashboard permissions table
require_once('index.php');

$CI =& get_instance();

// Create reporting dashboard permissions table
$table_name = db_prefix() . 'reporting_dashboard_permissions';

if (!$CI->db->table_exists($table_name)) {
    $CI->db->query("CREATE TABLE `$table_name` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `staff_id` int(11) NOT NULL,
        `permission_type` enum('view_all_staff','view_own_only','view_specific_staff') NOT NULL DEFAULT 'view_own_only',
        `allowed_staff_ids` text NULL COMMENT 'JSON array of staff IDs when permission_type is view_specific_staff',
        `granted_by` int(11) NOT NULL,
        `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
        `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        UNIQUE KEY `staff_id` (`staff_id`),
        KEY `granted_by` (`granted_by`),
        CONSTRAINT `fk_rd_permissions_staff` FOREIGN KEY (`staff_id`) REFERENCES `" . db_prefix() . "staff` (`staffid`) ON DELETE CASCADE,
        CONSTRAINT `fk_rd_permissions_granted_by` FOREIGN KEY (`granted_by`) REFERENCES `" . db_prefix() . "staff` (`staffid`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;");
    
    echo "Reporting dashboard permissions table created successfully.\n";
} else {
    // Check if we need to add the new columns for enhanced permissions
    $columns = $CI->db->list_fields($table_name);
    
    if (!in_array('allowed_staff_ids', $columns)) {
        $CI->db->query("ALTER TABLE `$table_name` ADD COLUMN `allowed_staff_ids` text NULL COMMENT 'JSON array of staff IDs when permission_type is view_specific_staff' AFTER `permission_type`");
        echo "Added allowed_staff_ids column.\n";
    }
    
    // Update permission_type enum to include new option
    try {
        $CI->db->query("ALTER TABLE `$table_name` MODIFY COLUMN `permission_type` enum('view_all_staff','view_own_only','view_specific_staff') NOT NULL DEFAULT 'view_own_only'");
        echo "Updated permission_type enum with view_specific_staff option.\n";
    } catch (Exception $e) {
        echo "Permission type already updated or error: " . $e->getMessage() . "\n";
    }
    
    echo "Reporting dashboard permissions table updated successfully.\n";
}

echo "Installation/Update completed!\n";
echo "You can now access the permission management at: " . admin_url('reporting_dashboard_permissions') . "\n";
?>
