// Lead Attachment Description Debug Script
// Add this to the browser console when you have a lead open with the attachments tab

console.log("=== LEAD ATTACHMENT DESCRIPTION DEBUG ===");

// Function to test the description functionality
function debugLeadAttachmentDescription() {
    console.log("1. Checking for required elements...");
    
    // Check for textarea
    const descTextarea = document.getElementById('attachment_description');
    if (descTextarea) {
        console.log("✓ Description textarea found");
        console.log("  - ID:", descTextarea.id);
        console.log("  - Name:", descTextarea.name);
        console.log("  - Current value:", '"' + descTextarea.value + '"');
        console.log("  - Placeholder:", descTextarea.placeholder);
    } else {
        console.error("✗ Description textarea NOT found");
        return false;
    }
    
    // Check for dropzone
    const dropzoneElement = document.getElementById('lead-attachment-upload');
    if (dropzoneElement) {
        console.log("✓ Dropzone element found");
        
        // Check if Dropzone instance exists
        if (window.leadAttachmentsDropzone) {
            console.log("✓ leadAttachmentsDropzone instance exists");
            
            // Check dropzone options
            const options = window.leadAttachmentsDropzone.options;
            console.log("  - Auto process queue:", options.autoProcessQueue);
            console.log("  - Parallel uploads:", options.parallelUploads);
            
            // Check if sending function exists
            if (options.sending) {
                console.log("✓ Sending function configured");
            } else {
                console.error("✗ No sending function configured");
            }
        } else {
            console.error("✗ leadAttachmentsDropzone instance NOT found");
        }
    } else {
        console.error("✗ Dropzone element NOT found");
        return false;
    }
    
    console.log("2. Testing description capture...");
    
    // Set a test description
    const testDescription = "TEST DESCRIPTION - " + new Date().toISOString();
    descTextarea.value = testDescription;
    console.log("Set test description:", testDescription);
    
    // Test jQuery selector
    const jQueryValue = $("#attachment_description").val();
    console.log("jQuery retrieval:", jQueryValue);
    
    if (jQueryValue === testDescription) {
        console.log("✓ jQuery selector working correctly");
    } else {
        console.error("✗ jQuery selector not working");
    }
    
    console.log("3. Monitoring next upload...");
    
    // Override the sending function to monitor what's being sent
    if (window.leadAttachmentsDropzone) {
        const originalSending = window.leadAttachmentsDropzone.options.sending;
        
        window.leadAttachmentsDropzone.options.sending = function(file, xhr, formData) {
            console.log("=== UPLOAD STARTING ===");
            console.log("File:", file.name);
            
            // Call original function first
            if (originalSending) {
                originalSending.call(this, file, xhr, formData);
            }
            
            // Check what's in the form data
            console.log("FormData contents:");
            for (let pair of formData.entries()) {
                console.log(`  ${pair[0]}: ${pair[1]}`);
            }
            
            // Specifically check for description
            const sentDescription = formData.get('description');
            if (sentDescription) {
                console.log("✓ Description found in FormData:", sentDescription);
            } else {
                console.error("✗ No description in FormData");
                
                // Try to get it manually and add it
                const currentDesc = $("#attachment_description").val();
                console.log("Manually retrieved description:", currentDesc);
                if (currentDesc) {
                    formData.append('description', currentDesc);
                    console.log("Manually added description to FormData");
                }
            }
            
            console.log("=== UPLOAD DATA READY ===");
        };
        
        console.log("✓ Upload monitoring enabled - try uploading a file now");
    }
    
    return true;
}

// Function to test without actually uploading
function testDescriptionCapture() {
    const testDesc = "Manual test description - " + Math.random().toString(36).substr(2, 9);
    
    // Set description
    $("#attachment_description").val(testDesc);
    
    // Test retrieval
    const retrieved = $("#attachment_description").val();
    
    console.log("Set:", testDesc);
    console.log("Retrieved:", retrieved);
    console.log("Match:", testDesc === retrieved ? "✓ YES" : "✗ NO");
    
    return testDesc === retrieved;
}

// Auto-run the debug
console.log("Running automatic debug...");
const debugResult = debugLeadAttachmentDescription();

if (debugResult) {
    console.log("✓ Basic setup looks good");
    console.log("Now test uploading a file to see if description is captured");
} else {
    console.error("✗ Setup issues detected");
    console.log("Make sure you have a lead open and are on the Attachments tab");
}

// Add a button to the page for easy testing
try {
    if (!document.getElementById('debug-attachment-desc')) {
        const debugButton = document.createElement('button');
        debugButton.id = 'debug-attachment-desc';
        debugButton.innerHTML = 'Debug Attachment Description';
        debugButton.style.cssText = 'position: fixed; top: 10px; right: 10px; z-index: 9999; background: orange; color: white; padding: 10px; border: none; border-radius: 5px; cursor: pointer;';
        debugButton.onclick = function() {
            debugLeadAttachmentDescription();
            testDescriptionCapture();
        };
        document.body.appendChild(debugButton);
        console.log("Added debug button to page");
    }
} catch (e) {
    console.log("Could not add debug button:", e.message);
}
