<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4 class="no-margin">
                            <i class="fa fa-cogs"></i> <?php echo $title; ?>
                        </h4>
                        <hr class="hr-panel-heading">
                        
                        <div class="row">
                            <div class="col-md-12">
                                <p>Manage custom fine-tuned models for AI lead analysis. You can add existing fine-tuned models or create new ones.</p>
                            </div>
                        </div>

                        <!-- Add Fine-Tuned Model -->
                        <div class="row mtop20">
                            <div class="col-md-6">
                                <div class="panel panel-primary">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-plus"></i> Add Fine-Tuned Model
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php echo form_open(admin_url('ai_setup/save_fine_tuned_model')); ?>
                                        
                                        <div class="form-group">
                                            <label for="model_id" class="control-label">Model ID <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="model_id" id="model_id" 
                                                   placeholder="ft:gpt-3.5-turbo-0613:company::xxxxxxxx" required>
                                            <small class="help-block">The fine-tuned model ID from OpenAI (starts with 'ft:')</small>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="model_name" class="control-label">Display Name <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="model_name" id="model_name" 
                                                   placeholder="Lead Analysis Model v1" required>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="description" class="control-label">Description</label>
                                            <textarea class="form-control" name="description" id="description" rows="3"
                                                      placeholder="Model trained on lead data for better conversion prediction..."></textarea>
                                        </div>
                                        
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fa fa-save"></i> Add Model
                                        </button>
                                        
                                        <?php echo form_close(); ?>
                                    </div>
                                </div>
                            </div>

                            <!-- Create New Fine-Tuning Job -->
                            <div class="col-md-6">
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-upload"></i> Create Fine-Tuning Job
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php echo form_open_multipart(admin_url('ai_setup/create_fine_tuning_job')); ?>
                                        
                                        <div class="form-group">
                                            <label for="training_file" class="control-label">Training File <span class="text-danger">*</span></label>
                                            <input type="file" class="form-control" name="training_file" id="training_file" 
                                                   accept=".jsonl" required>
                                            <small class="help-block">JSONL file with training examples (max 100MB)</small>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="base_model" class="control-label">Base Model</label>
                                            <select class="form-control" name="base_model" id="base_model">
                                                <option value="gpt-3.5-turbo-0613">GPT-3.5 Turbo</option>
                                                <option value="gpt-4-0613">GPT-4</option>
                                                <option value="babbage-002">Babbage-002</option>
                                                <option value="davinci-002">Davinci-002</option>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="suffix" class="control-label">Model Suffix</label>
                                            <input type="text" class="form-control" name="suffix" id="suffix" 
                                                   value="lead-analysis" maxlength="40">
                                            <small class="help-block">Optional suffix for model identification (max 40 chars)</small>
                                        </div>
                                        
                                        <button type="submit" class="btn btn-info">
                                            <i class="fa fa-rocket"></i> Create Job
                                        </button>
                                        
                                        <?php echo form_close(); ?>
                                        
                                        <hr>
                                        <div class="alert alert-info">
                                            <i class="fa fa-info-circle"></i>
                                            <strong>Note:</strong> Fine-tuning jobs can take several hours to complete. 
                                            You'll receive an email when the job is finished.
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Saved Fine-Tuned Models -->
                        <div class="row mtop20">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-list"></i> Saved Fine-Tuned Models
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php if (!empty($fine_tuned_models)): ?>
                                            <div class="table-responsive">
                                                <table class="table table-bordered">
                                                    <thead>
                                                        <tr>
                                                            <th>Model ID</th>
                                                            <th>Display Name</th>
                                                            <th>Description</th>
                                                            <th>Created</th>
                                                            <th>Actions</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach ($fine_tuned_models as $index => $model): ?>
                                                            <tr>
                                                                <td><code><?php echo htmlspecialchars($model['id']); ?></code></td>
                                                                <td><?php echo htmlspecialchars($model['name']); ?></td>
                                                                <td><?php echo htmlspecialchars($model['description'] ?? ''); ?></td>
                                                                <td><?php echo date('M j, Y H:i', strtotime($model['created_at'])); ?></td>
                                                                <td>
                                                                    <a href="<?php echo admin_url('ai_setup/delete_fine_tuned_model/' . $index); ?>" 
                                                                       class="btn btn-danger btn-xs" 
                                                                       onclick="return confirm('Are you sure you want to delete this model?')">
                                                                        <i class="fa fa-trash"></i> Delete
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        <?php else: ?>
                                            <div class="alert alert-info">
                                                <i class="fa fa-info-circle"></i>
                                                No fine-tuned models saved yet. Add one using the form above.
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- OpenAI Fine-Tuning Jobs -->
                        <div class="row mtop20">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-cog fa-spin"></i> OpenAI Fine-Tuning Jobs
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php if (!empty($openai_jobs)): ?>
                                            <div class="table-responsive">
                                                <table class="table table-bordered">
                                                    <thead>
                                                        <tr>
                                                            <th>Job ID</th>
                                                            <th>Model</th>
                                                            <th>Status</th>
                                                            <th>Created</th>
                                                            <th>Finished</th>
                                                            <th>Fine-Tuned Model</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach ($openai_jobs as $job): ?>
                                                            <tr>
                                                                <td><code><?php echo htmlspecialchars($job['id']); ?></code></td>
                                                                <td><?php echo htmlspecialchars($job['model']); ?></td>
                                                                <td>
                                                                    <?php
                                                                    $status_class = '';
                                                                    switch ($job['status']) {
                                                                        case 'succeeded':
                                                                            $status_class = 'label-success';
                                                                            break;
                                                                        case 'running':
                                                                            $status_class = 'label-info';
                                                                            break;
                                                                        case 'failed':
                                                                            $status_class = 'label-danger';
                                                                            break;
                                                                        default:
                                                                            $status_class = 'label-default';
                                                                    }
                                                                    ?>
                                                                    <span class="label <?php echo $status_class; ?>">
                                                                        <?php echo ucfirst($job['status']); ?>
                                                                    </span>
                                                                </td>
                                                                <td><?php echo date('M j, Y H:i', $job['created_at']); ?></td>
                                                                <td>
                                                                    <?php echo $job['finished_at'] ? date('M j, Y H:i', $job['finished_at']) : '-'; ?>
                                                                </td>
                                                                <td>
                                                                    <?php if ($job['fine_tuned_model']): ?>
                                                                        <code><?php echo htmlspecialchars($job['fine_tuned_model']); ?></code>
                                                                        <br>
                                                                        <button class="btn btn-xs btn-success mtop5" 
                                                                                onclick="addCompletedModel('<?php echo htmlspecialchars($job['fine_tuned_model']); ?>')">
                                                                            <i class="fa fa-plus"></i> Add to Models
                                                                        </button>
                                                                    <?php else: ?>
                                                                        -
                                                                    <?php endif; ?>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        <?php else: ?>
                                            <div class="alert alert-info">
                                                <i class="fa fa-info-circle"></i>
                                                No fine-tuning jobs found. Create one using the form above or check your OpenAI API configuration.
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Help Section -->
                        <div class="row mtop20">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-question-circle"></i> Help & Documentation
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <h5><i class="fa fa-book"></i> Training Data Format</h5>
                                        <p>Your training file should be in JSONL format with the following structure:</p>
                                        <pre><code>{"messages": [{"role": "system", "content": "You are an AI that analyzes leads..."}, {"role": "user", "content": "Analyze this lead..."}, {"role": "assistant", "content": "Based on the lead data..."}]}
{"messages": [{"role": "system", "content": "You are an AI that analyzes leads..."}, {"role": "user", "content": "Another lead example..."}, {"role": "assistant", "content": "This lead shows..."}]}</code></pre>
                                        
                                        <h5 class="mtop15"><i class="fa fa-lightbulb-o"></i> Best Practices</h5>
                                        <ul>
                                            <li>Include at least 10-50 high-quality training examples</li>
                                            <li>Ensure examples are diverse and representative of your lead data</li>
                                            <li>Use consistent formatting and terminology</li>
                                            <li>Test your model thoroughly before deploying to production</li>
                                        </ul>
                                        
                                        <h5 class="mtop15"><i class="fa fa-link"></i> Useful Links</h5>
                                        <ul>
                                            <li><a href="https://platform.openai.com/docs/guides/fine-tuning" target="_blank">OpenAI Fine-Tuning Guide</a></li>
                                            <li><a href="https://platform.openai.com/finetune" target="_blank">OpenAI Fine-Tuning Dashboard</a></li>
                                            <li><a href="https://cookbook.openai.com/examples/chat_finetuning_data_prep" target="_blank">Data Preparation Cookbook</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function addCompletedModel(modelId) {
    $('#model_id').val(modelId);
    $('#model_name').val('Fine-tuned Model - ' + modelId.substring(0, 20) + '...');
    $('html, body').animate({
        scrollTop: $('#model_id').offset().top - 100
    }, 500);
    $('#model_id').focus();
}
</script>

<?php init_tail(); ?>
