<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-8">
                                <h4 class="no-margin">
                                    <i class="fa fa-brain"></i> AI Reports - Static Test
                                </h4>
                            </div>
                        </div>
                        <hr class="hr-panel-heading">
                        
                        <!-- Simple Table -->
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered" id="simple-table">
                                <thead>
                                    <tr>
                                        <th>Report ID</th>
                                        <th>Lead</th>
                                        <th>Confidence</th>
                                        <th>Verdict</th>
                                        <th>Analysis Type</th>
                                        <th>Created Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    // Get data directly from database
                                    $this->load->database();
                                    $this->db->select('r.*, l.name as lead_name, l.company as lead_company, l.email as lead_email')
                                             ->from(db_prefix() . 'leads_ai_reports r')
                                             ->join(db_prefix() . 'leads l', 'l.id = r.lead_id', 'left')
                                             ->order_by('r.id', 'DESC')
                                             ->limit(10);
                                    
                                    $reports = $this->db->get()->result();
                                    
                                    if (empty($reports)): ?>
                                        <tr>
                                            <td colspan="7" class="text-center">No AI reports found</td>
                                        </tr>
                                    <?php else: ?>
                                        <?php foreach ($reports as $report): ?>
                                        <tr>
                                            <td>
                                                <a href="<?php echo admin_url('ai_reports/view/' . $report->id); ?>">
                                                    #<?php echo $report->id; ?>
                                                </a>
                                            </td>
                                            <td>
                                                <?php if ($report->lead_name): ?>
                                                    <a href="<?php echo admin_url('leads/index/' . $report->lead_id); ?>">
                                                        <?php echo $report->lead_name; ?>
                                                    </a>
                                                    <?php if ($report->lead_company): ?>
                                                        <br><small class="text-muted"><?php echo $report->lead_company; ?></small>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <span class="text-muted">Unknown Lead</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php 
                                                $score = $report->confidence_score ?: 0;
                                                $score_class = $score >= 80 ? 'success' : ($score >= 60 ? 'warning' : 'danger');
                                                ?>
                                                <div class="progress" style="margin-bottom: 0;">
                                                    <div class="progress-bar progress-bar-<?php echo $score_class; ?>" 
                                                         style="width: <?php echo $score; ?>%">
                                                        <?php echo $score; ?>%
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <?php 
                                                $verdict = $report->purchase_likelihood ?: 'Unknown';
                                                $badge_class = 'default';
                                                switch (strtolower($verdict)) {
                                                    case 'hot': $badge_class = 'danger'; break;
                                                    case 'warm': $badge_class = 'warning'; break;
                                                    case 'cold': $badge_class = 'info'; break;
                                                    case 'qualified': $badge_class = 'success'; break;
                                                }
                                                ?>
                                                <span class="label label-<?php echo $badge_class; ?>"><?php echo $verdict; ?></span>
                                            </td>
                                            <td><?php echo ucfirst(str_replace('_', ' ', $report->analysis_type)); ?></td>
                                            <td><?php echo _dt($report->created_at); ?></td>
                                            <td>
                                                <div class="btn-group">
                                                    <a href="<?php echo admin_url('ai_reports/view/' . $report->id); ?>" 
                                                       class="btn btn-default btn-xs" title="View">
                                                        <i class="fa fa-eye"></i>
                                                    </a>
                                                    <?php if (is_admin()): ?>
                                                    <a href="<?php echo admin_url('ai_reports/delete/' . $report->id); ?>" 
                                                       class="btn btn-danger btn-xs" 
                                                       onclick="return confirm('Are you sure?')" title="Delete">
                                                        <i class="fa fa-trash"></i>
                                                    </a>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <p class="text-muted">
                            <strong>Debug Info:</strong> 
                            Found <?php echo count($reports); ?> reports. 
                            User is admin: <?php echo is_admin() ? 'Yes' : 'No'; ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php init_tail(); ?>

<script>
// Wait for jQuery to be available
function waitForJQuery() {
    if (typeof jQuery !== 'undefined') {
        console.log('jQuery is available, version:', jQuery.fn.jquery);
        initializeTable();
    } else {
        console.log('Waiting for jQuery...');
        setTimeout(waitForJQuery, 100);
    }
}

function initializeTable() {
    jQuery(document).ready(function($) {
        console.log('Static table initialization starting...');
        console.log('Admin URL should be:', '<?php echo admin_url(); ?>');
        console.log('jQuery version:', $.fn.jquery);
        
        // Check if DataTables is available
        if (typeof $.fn.DataTable !== 'undefined') {
            console.log('DataTables is available');
            
            try {
                // Test if DataTables can work on static content
                $('#simple-table').DataTable({
                    searching: true,
                    ordering: true,
                    paging: true,
                    pageLength: 10,
                    language: {
                        emptyTable: "No AI reports found"
                    },
                    initComplete: function() {
                        console.log('DataTable initialized successfully');
                    }
                });
            } catch (e) {
                console.error('DataTable initialization error:', e);
            }
        } else {
            console.error('DataTables is not available');
            // Just make it a simple sortable table
            console.log('Using simple table without DataTables');
        }
    });
}

// Start waiting for jQuery
waitForJQuery();
</script>
