<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title><?php echo $title; ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            line-height: 1.6;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #007bff;
            padding-bottom: 20px;
        }
        .header h1 {
            color: #007bff;
            margin: 0;
            font-size: 24px;
        }
        .header .date {
            color: #666;
            font-size: 14px;
            margin-top: 5px;
        }
        .summary {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 30px;
        }
        .summary h2 {
            margin-top: 0;
            color: #007bff;
            font-size: 18px;
        }
        .summary-row {
            width: 100%;
            margin-bottom: 10px;
            overflow: hidden;
        }
        .summary-item {
            float: left;
            width: 30%;
            text-align: center;
            padding: 10px;
            background: white;
            border-radius: 3px;
            margin: 0 1.5%;
            box-sizing: border-box;
        }
        .summary-item strong {
            display: block;
            font-size: 18px;
            color: #007bff;
        }
        .reports-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .reports-table th,
        .reports-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .reports-table th {
            background-color: #007bff;
            color: white;
            font-weight: bold;
        }
        .reports-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .confidence-bar {
            width: 100px;
            height: 20px;
            background-color: #e9ecef;
            border-radius: 10px;
            overflow: hidden;
            position: relative;
        }
        .confidence-fill {
            height: 100%;
            border-radius: 10px;
            color: white;
            text-align: center;
            line-height: 20px;
            font-size: 12px;
            font-weight: bold;
        }
        .confidence-high { background-color: #28a745; }
        .confidence-medium { background-color: #ffc107; }
        .confidence-low { background-color: #dc3545; }
        .verdict-badge {
            padding: 3px 8px;
            border-radius: 3px;
            color: white;
            font-size: 11px;
            font-weight: bold;
        }
        .verdict-high { background-color: #28a745; }
        .verdict-medium { background-color: #ffc107; }
        .verdict-low { background-color: #dc3545; }
        .verdict-unknown { background-color: #6c757d; }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 12px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 20px;
        }
        .page-break {
            page-break-before: always;
        }
        
        /* Print styles */
        @media print {
            body {
                margin: 0;
                padding: 15px;
            }
            .no-print {
                display: none !important;
            }
        }
        
        /* Print button styles */
        .print-controls {
            position: fixed;
            top: 10px;
            right: 10px;
            z-index: 1000;
            background: white;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.2);
        }
        
        .btn {
            background: #007bff;
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 3px;
            cursor: pointer;
            margin: 0 5px;
        }
        
        .btn:hover {
            background: #0056b3;
        }
        
        .btn-secondary {
            background: #6c757d;
        }
        
        .btn-secondary:hover {
            background: #545b62;
        }
    </style>
</head>
<body>
    <div class="print-controls no-print">
        <button class="btn" onclick="window.print()">Print / Save as PDF</button>
        <button class="btn btn-secondary" onclick="window.close()">Close</button>
    </div>
    
    <div class="header">
        <h1><?php echo $title; ?></h1>
        <div class="date">Generated on <?php echo date('F j, Y \a\t g:i A'); ?></div>
    </div>

    <div class="summary">
        <h2>Summary Statistics</h2>
        <div class="summary-row">
            <div class="summary-item">
                <strong><?php echo count($reports); ?></strong>
                Total Reports
            </div>
            <div class="summary-item">
                <strong><?php echo count($reports) > 0 ? round(array_sum(array_column($reports, 'score')) / count($reports), 1) : 0; ?>%</strong>
                Average Confidence
            </div>
            <div class="summary-item">
                <strong><?php 
                $verdicts = array_count_values(array_column($reports, 'verdict'));
                echo count($verdicts);
                ?></strong>
                Unique Verdicts
            </div>
        </div>
        <div style="clear: both;"></div>
    </div>

    <table class="reports-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Lead</th>
                <th>Company</th>
                <th>Confidence</th>
                <th>Verdict</th>
                <th>Analysis Type</th>
                <th>Created By</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($reports as $report): ?>
            <tr>
                <td>#<?php echo $report->id; ?></td>
                <td><?php echo htmlspecialchars($report->lead_name ?: 'Unknown'); ?></td>
                <td><?php echo htmlspecialchars($report->lead_company ?: '-'); ?></td>
                <td>
                    <div class="confidence-bar">
                        <div class="confidence-fill confidence-<?php echo $report->score >= 70 ? 'high' : ($report->score >= 40 ? 'medium' : 'low'); ?>" 
                             style="width: <?php echo $report->score; ?>%">
                            <?php echo $report->score; ?>%
                        </div>
                    </div>
                </td>
                <td>
                    <span class="verdict-badge verdict-<?php echo strtolower($report->verdict ?: 'unknown'); ?>">
                        <?php echo $report->verdict ?: 'Unknown'; ?>
                    </span>
                </td>
                <td><?php echo ucfirst(str_replace('_', ' ', $report->analysis_type)); ?></td>
                <td><?php echo htmlspecialchars($report->created_by_name ?: 'Unknown'); ?></td>
                <td><?php echo date('M j, Y', strtotime($report->created_at)); ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <div class="footer">
        <p>AI Analysis Reports Export - Generated by Perfex CRM</p>
        <p><?php echo count($reports); ?> reports exported</p>
    </div>
</body>
</html>
