<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-8">
                                <h4 class="no-margin">
                                    <i class="fa fa-brain"></i> AI Reports - Simple Test
                                </h4>
                            </div>
                        </div>
                        <hr class="hr-panel-heading">
                        
                        <!-- Non-AJAX Table -->
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Report ID</th>
                                        <th>Lead</th>
                                        <th>Confidence</th>
                                        <th>Verdict</th>
                                        <th>Analysis Type</th>
                                        <th>Created Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    // Get data directly from database
                                    $this->load->database();
                                    $this->db->select('r.*, l.name as lead_name, l.company as lead_company, l.email as lead_email, 
                                                      CONCAT(s.firstname, " ", s.lastname) as created_by_name')
                                             ->from(db_prefix() . 'leads_ai_reports r')
                                             ->join(db_prefix() . 'leads l', 'l.id = r.lead_id', 'left')
                                             ->join(db_prefix() . 'staff s', 's.staffid = r.created_by', 'left')
                                             ->order_by('r.id', 'DESC')
                                             ->limit(25);
                                    
                                    $reports = $this->db->get()->result();
                                    
                                    if (empty($reports)): ?>
                                        <tr>
                                            <td colspan="7" class="text-center">No AI reports found</td>
                                        </tr>
                                    <?php else: ?>
                                        <?php foreach ($reports as $report): ?>
                                        <tr>
                                            <td>
                                                <a href="<?php echo admin_url('ai_reports/view/' . $report->id); ?>">#<?php echo $report->id; ?></a>
                                            </td>
                                            <td>
                                                <a href="<?php echo admin_url('leads/index/' . $report->lead_id); ?>"><?php echo e($report->lead_name); ?></a>
                                                <?php if (!empty($report->lead_company)): ?>
                                                    <br><small class="text-muted"><?php echo e($report->lead_company); ?></small>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php
                                                $score = $report->confidence_score ?: 0;
                                                $score_class = $score >= 80 ? 'success' : ($score >= 60 ? 'warning' : 'danger');
                                                ?>
                                                <div class="progress" style="margin-bottom: 0;">
                                                    <div class="progress-bar progress-bar-<?php echo $score_class; ?>" style="width: <?php echo $score; ?>%"><?php echo $score; ?>%</div>
                                                </div>
                                            </td>
                                            <td>
                                                <?php
                                                $verdict = $report->purchase_likelihood ?: 'Unknown';
                                                $badge_class = '';
                                                switch (strtolower($verdict)) {
                                                    case 'hot':
                                                    case 'high':
                                                        $badge_class = 'success';
                                                        break;
                                                    case 'warm':
                                                    case 'medium':
                                                        $badge_class = 'warning';
                                                        break;
                                                    case 'cold':
                                                    case 'low':
                                                        $badge_class = 'danger';
                                                        break;
                                                    default:
                                                        $badge_class = 'default';
                                                        break;
                                                }
                                                ?>
                                                <span class="label label-<?php echo $badge_class; ?>"><?php echo e($verdict); ?></span>
                                            </td>
                                            <td>
                                                <?php echo e(ucfirst(str_replace('_', ' ', $report->analysis_type))); ?>
                                            </td>
                                            <td>
                                                <?php echo e(_dt($report->created_at)); ?>
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    <a href="<?php echo admin_url('ai_reports/view/' . $report->id); ?>" class="btn btn-default btn-xs" title="View">
                                                        <i class="fa fa-eye"></i>
                                                    </a>
                                                    <?php if (is_admin()): ?>
                                                    <a href="<?php echo admin_url('ai_reports/delete/' . $report->id); ?>" 
                                                       class="btn btn-danger btn-xs" 
                                                       onclick="return confirm('Are you sure?')" 
                                                       title="Delete">
                                                        <i class="fa fa-trash"></i>
                                                    </a>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <p class="text-muted">
                                    <i class="fa fa-info-circle"></i> 
                                    This is a simple test view showing AI reports without AJAX. 
                                    Total reports found: <?php echo count($reports); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
