<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_334 extends CI_Migration
{
    public function up()
    {
        // Create tblleads_ai_reports table
        if (!$this->db->table_exists(db_prefix() . 'leads_ai_reports')) {
            $this->db->query('CREATE TABLE `' . db_prefix() . 'leads_ai_reports` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `lead_id` int(11) NOT NULL,
                `analysis_data` longtext NOT NULL COMMENT "JSON data from OpenAI analysis",
                `confidence_score` decimal(5,2) DEFAULT NULL COMMENT "0.00 to 100.00",
                `likelihood_category` varchar(20) DEFAULT NULL COMMENT "low, medium, high",
                `key_insights` text DEFAULT NULL COMMENT "Extracted key insights",
                `recommended_actions` text DEFAULT NULL COMMENT "Suggested next steps",
                `analysis_version` varchar(10) DEFAULT "1.0" COMMENT "Version of analysis algorithm",
                `analyzed_files` text DEFAULT NULL COMMENT "JSON array of analyzed file paths",
                `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
                `updated_at` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
                `created_by` int(11) DEFAULT NULL COMMENT "Staff ID who initiated analysis",
                PRIMARY KEY (`id`),
                KEY `lead_id` (`lead_id`),
                KEY `confidence_score` (`confidence_score`),
                KEY `likelihood_category` (`likelihood_category`),
                KEY `created_at` (`created_at`),
                CONSTRAINT `fk_leads_ai_reports_lead_id` FOREIGN KEY (`lead_id`) REFERENCES `' . db_prefix() . 'leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;');
        }

        // Create tblleads_ai_analysis_queue table for background processing
        if (!$this->db->table_exists(db_prefix() . 'leads_ai_analysis_queue')) {
            $this->db->query('CREATE TABLE `' . db_prefix() . 'leads_ai_analysis_queue` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `lead_id` int(11) NOT NULL,
                `priority` enum("low","normal","high") DEFAULT "normal",
                `status` enum("pending","processing","completed","failed") DEFAULT "pending",
                `attempt_count` int(11) DEFAULT 0,
                `last_error` text DEFAULT NULL,
                `scheduled_at` datetime DEFAULT CURRENT_TIMESTAMP,
                `started_at` datetime DEFAULT NULL,
                `completed_at` datetime DEFAULT NULL,
                `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
                `updated_at` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
                PRIMARY KEY (`id`),
                KEY `lead_id` (`lead_id`),
                KEY `status` (`status`),
                KEY `priority` (`priority`),
                KEY `scheduled_at` (`scheduled_at`),
                CONSTRAINT `fk_leads_ai_queue_lead_id` FOREIGN KEY (`lead_id`) REFERENCES `' . db_prefix() . 'leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;');
        }

        // Add AI analysis permission option
        $this->db->query("INSERT IGNORE INTO `" . db_prefix() . "options` (`name`, `value`, `autoload`) VALUES ('ai_analysis_enabled', '1', '1')");
        $this->db->query("INSERT IGNORE INTO `" . db_prefix() . "options` (`name`, `value`, `autoload`) VALUES ('ai_analysis_auto_analyze', '1', '1')");
        $this->db->query("INSERT IGNORE INTO `" . db_prefix() . "options` (`name`, `value`, `autoload`) VALUES ('ai_analysis_cleanup_days', '30', '1')");
        $this->db->query("INSERT IGNORE INTO `" . db_prefix() . "options` (`name`, `value`, `autoload`) VALUES ('ai_analysis_max_file_size', '10485760', '1')");
        $this->db->query("INSERT IGNORE INTO `" . db_prefix() . "options` (`name`, `value`, `autoload`) VALUES ('ai_analysis_allowed_types', 'jpg,jpeg,png,gif,pdf,doc,docx', '1')");

        // Add AI analysis permissions to staff permissions
        if ($this->db->table_exists(db_prefix() . 'staff_permissions')) {
            $this->db->query("INSERT IGNORE INTO `" . db_prefix() . "staff_permissions` (`staffid`, `feature`, `capability`) 
                             SELECT `staffid`, 'leads', 'ai_analysis' FROM `" . db_prefix() . "staff` WHERE `admin` = 1");
        }

        // Create upload directory if it doesn't exist
        $upload_path = FCPATH . 'uploads/ai_analysis/';
        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0755, true);
            
            // Create .htaccess for security
            $htaccess_content = "deny from all\n<Files ~ \"\\.(jpg|jpeg|png|gif|pdf|doc|docx)$\">\nallow from all\n</Files>";
            file_put_contents($upload_path . '.htaccess', $htaccess_content);
            
            // Create index.html to prevent directory listing
            file_put_contents($upload_path . 'index.html', '<!DOCTYPE html><html><head><title>403 Forbidden</title></head><body><h1>Directory access is forbidden.</h1></body></html>');
        }

        // Log the migration completion
        log_activity('AI Lead Analysis Migration Completed - Tables and settings created');
    }

    public function down()
    {
        // Remove tables
        $this->db->query('DROP TABLE IF EXISTS `' . db_prefix() . 'leads_ai_analysis_queue`');
        $this->db->query('DROP TABLE IF EXISTS `' . db_prefix() . 'leads_ai_reports`');

        // Remove options
        $this->db->where('name', 'ai_analysis_enabled')->delete(db_prefix() . 'options');
        $this->db->where('name', 'ai_analysis_auto_analyze')->delete(db_prefix() . 'options');
        $this->db->where('name', 'ai_analysis_cleanup_days')->delete(db_prefix() . 'options');
        $this->db->where('name', 'ai_analysis_max_file_size')->delete(db_prefix() . 'options');
        $this->db->where('name', 'ai_analysis_allowed_types')->delete(db_prefix() . 'options');

        // Remove permissions
        if ($this->db->table_exists(db_prefix() . 'staff_permissions')) {
            $this->db->where('feature', 'leads')
                     ->where('capability', 'ai_analysis')
                     ->delete(db_prefix() . 'staff_permissions');
        }

        // Log the rollback
        log_activity('AI Lead Analysis Migration Rolled Back - Tables and settings removed');
    }
}
