<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Debug_controller extends AdminController
{
    public function index()
    {
        if (!is_staff_member()) {
            echo "Access denied";
            return;
        }

        echo "<h2>Controller Debug Information</h2>";

        $controller_file = APPPATH . 'controllers/admin/Leads.php';
        
        if (!file_exists($controller_file)) {
            echo "<p style='color: red;'>Controller file not found!</p>";
            return;
        }

        $content = file_get_contents($controller_file);
        
        echo "<h3>1. Check if _create_automatic_followup_reminder method exists</h3>";
        if (strpos($content, '_create_automatic_followup_reminder') !== false) {
            echo "<p style='color: green;'>✓ Method found</p>";
            
            // Extract the method
            $start = strpos($content, 'private function _create_automatic_followup_reminder');
            if ($start === false) {
                $start = strpos($content, 'function _create_automatic_followup_reminder');
            }
            
            if ($start !== false) {
                $end = strpos($content, '}', $start);
                $method_count = 0;
                $pos = $start;
                while ($pos < strlen($content) && $method_count >= 0) {
                    if ($content[$pos] == '{') $method_count++;
                    if ($content[$pos] == '}') $method_count--;
                    $pos++;
                    if ($method_count == 0) break;
                }
                
                $method_code = substr($content, $start, $pos - $start);
                echo "<h4>Method Code:</h4>";
                echo "<pre style='background: #f0f0f0; padding: 10px; max-height: 400px; overflow-y: scroll;'>";
                echo htmlspecialchars($method_code);
                echo "</pre>";
            }
        } else {
            echo "<p style='color: red;'>✗ Method not found</p>";
        }

        echo "<h3>2. Check add_note method for reminder creation call</h3>";
        if (strpos($content, 'create_reminder') !== false) {
            echo "<p style='color: green;'>✓ create_reminder handling found</p>";
            
            // Find the add_note method
            $add_note_start = strpos($content, 'public function add_note(');
            if ($add_note_start !== false) {
                // Find the end of the method
                $pos = $add_note_start;
                $brace_count = 0;
                $in_method = false;
                
                while ($pos < strlen($content)) {
                    if ($content[$pos] == '{') {
                        $brace_count++;
                        $in_method = true;
                    }
                    if ($content[$pos] == '}') {
                        $brace_count--;
                        if ($brace_count == 0 && $in_method) break;
                    }
                    $pos++;
                }
                
                $add_note_method = substr($content, $add_note_start, $pos - $add_note_start + 1);
                
                // Check for specific parts
                if (strpos($add_note_method, '_create_automatic_followup_reminder') !== false) {
                    echo "<p style='color: green;'>✓ Reminder creation call found in add_note</p>";
                } else {
                    echo "<p style='color: red;'>✗ Reminder creation call NOT found in add_note</p>";
                }
                
                if (strpos($add_note_method, "data['create_reminder']") !== false) {
                    echo "<p style='color: green;'>✓ create_reminder checkbox check found</p>";
                } else {
                    echo "<p style='color: red;'>✗ create_reminder checkbox check NOT found</p>";
                }
                
                echo "<h4>Relevant parts of add_note method:</h4>";
                $lines = explode("\n", $add_note_method);
                $relevant_lines = [];
                foreach ($lines as $i => $line) {
                    if (stripos($line, 'reminder') !== false || 
                        stripos($line, 'next_followup') !== false ||
                        stripos($line, 'create_reminder') !== false) {
                        $relevant_lines[] = ($i + 1) . ": " . $line;
                    }
                }
                
                if (!empty($relevant_lines)) {
                    echo "<pre style='background: #f0f0f0; padding: 10px;'>";
                    echo htmlspecialchars(implode("\n", $relevant_lines));
                    echo "</pre>";
                } else {
                    echo "<p>No reminder-related code found in add_note method</p>";
                }
            }
        } else {
            echo "<p style='color: red;'>✗ create_reminder handling not found</p>";
        }

        echo "<h3>3. Check database structure</h3>";
        try {
            $this->load->database();
            
            // Check lead_notes table
            $columns = $this->db->query("SHOW COLUMNS FROM " . db_prefix() . "lead_notes")->result();
            echo "<h4>lead_notes table columns:</h4>";
            echo "<ul>";
            foreach ($columns as $col) {
                echo "<li>" . $col->Field . " (" . $col->Type . ")" . 
                     ($col->Field == 'next_followup_date' ? ' <strong style="color: green;">✓</strong>' : '') . "</li>";
            }
            echo "</ul>";
            
            // Check reminders table
            $rem_columns = $this->db->query("SHOW COLUMNS FROM " . db_prefix() . "reminders")->result();
            echo "<h4>reminders table columns:</h4>";
            echo "<ul>";
            foreach ($rem_columns as $col) {
                echo "<li>" . $col->Field . " (" . $col->Type . ")</li>";
            }
            echo "</ul>";
            
        } catch (Exception $e) {
            echo "<p style='color: red;'>Database error: " . $e->getMessage() . "</p>";
        }

        echo "<h3>4. Test URLs</h3>";
        echo "<ul>";
        echo "<li><a href='" . admin_url('test_reminder') . "'>Basic Reminder Test</a></li>";
        echo "<li><a href='" . admin_url('test_add_note') . "'>Add Note Simulation Test</a></li>";
        echo "<li><a href='" . admin_url('leads/lead/44') . "'>Lead 44 (for manual testing)</a></li>";
        echo "</ul>";
    }
}
?>
