<?php
defined('BASEPATH') or exit('No direct script access allowed');

// Admin controller for assigning interested dealers to staff
class Assign_interested_dealers extends AdminController {
    public function index() {
        if (!is_admin()) {
            access_denied('Assign Interested Dealers');
        }
        $this->load->model('staff_model');
        $this->load->database();

    // Fetch interested dealers by joining tblleads and tbllead_notes
    $this->db->select('tblleads.*');
    $this->db->from('tblleads');
    $this->db->join('tbllead_notes', 'tbllead_notes.leadid = tblleads.id', 'inner');
    $this->db->where('tbllead_notes.dealer_interest', 'interested');
    $this->db->group_by('tblleads.id');
    $dealers = $this->db->get()->result_array();
        // Fetch staff list
        $staff = $this->staff_model->get('', ['active' => 1]);

        // Handle assignment POST
        if ($this->input->method() === 'post' && $this->input->post('dealer_ids') && $this->input->post('staff_id')) {
            $dealer_ids = array_map('intval', (array)$this->input->post('dealer_ids'));
            $staff_id = (int)$this->input->post('staff_id');
            if ($dealer_ids && $staff_id) {
                $this->db->where_in('id', $dealer_ids)->update('tblleads', ['assigned' => $staff_id]);
                set_alert('success', 'Assigned ' . count($dealer_ids) . ' dealer(s) to staff ID ' . $staff_id . '.');
                redirect(admin_url('assign_interested_dealers'));
            }
        }

        $data['dealers'] = $dealers;
        $data['staff'] = $staff;
        $data['title'] = 'Assign Interested Dealers to Staff';
        $this->load->view('admin/assign_interested_dealers', $data);
    }
}
