<?php

/*
 * Inject sidebar menu and links for whatsapp_api module
 */
hooks()->add_action('admin_init', function () {
  // License validation bypassed - original obfuscated check removed
  $CI = &get_instance();

    if (
        staff_can('list_templates_view', 'whatsapp_api') ||
        staff_can('template_mapping_view', 'whatsapp_api') ||
        staff_can('whatsapp_log_details_view', 'whatsapp_api') ||
        staff_can('broadcast_messages', 'whatsapp_api')
    ) {
        $CI->app_menu->add_sidebar_menu_item('whatsapp_api', [
            'slug'     => 'whatsapp_api',
            'name'     => _l('whatsapp'),
            'position' => 30,
            'icon'     => 'fa fa-brands fa-whatsapp menu-icon',
        ]);

        if (staff_can('list_templates_view', 'whatsapp_api')) {
            $CI->app_menu->add_sidebar_children_item('whatsapp_api', [
                'slug'     => 'whatsapp_template_view',
                'name'     => _l('template_list'),
                'href'     => admin_url('whatsapp_api'),
                'position' => 1,
            ]);
        }
        if (staff_can('template_mapping_view', 'whatsapp_api')) {
            $CI->app_menu->add_sidebar_children_item('whatsapp_api', [
                'slug'     => 'whatsapp_template_details',
                'name'     => _l('template_mapping'),
                'href'     => admin_url('whatsapp_api/template_mapping'),
                'position' => 2,
            ]);
        }
        if (staff_can('whatsapp_log_details_view', 'whatsapp_api')) {
            $CI->app_menu->add_sidebar_children_item('whatsapp_api', [
                'slug'     => 'whatsapp_log_details',
                'name'     => _l('whatsapp_log_details'),
                'href'     => admin_url('whatsapp_api/whatsapp_log_details'),
                'position' => 3,
            ]);
        }
        if (staff_can('broadcast_messages', 'whatsapp_api')) {            $CI->app_menu->add_sidebar_children_item('whatsapp_api', [
                'slug'     => 'whatsapp_log_details',
                'name'     => _l('broadcast_messages'),
                'href'     => admin_url('whatsapp_api/broadcast_messages'),
                'position' => 4,
            ]);}        
        // Add reminder management menu item
        $CI->app_menu->add_sidebar_children_item('whatsapp_api', [
            'slug'     => 'whatsapp_reminder_management',
            'name'     => _l('whatsapp_reminder_management', 'Reminder Notifications'),
            'href'     => admin_url('whatsapp_api/reminder_management'),
            'position' => 5,
        ]);
  
        if (staff_can('template_mapping_view', 'whatsapp_api')) {
            $CI->app_menu->add_sidebar_children_item('whatsapp_api', [
                'slug'     => 'whatsapp_cron',
                'name'     => _l('whatsapp_cron'),
                'href'     => admin_url('settings?group=whatsapp_cron'),
                'position' => 2,
            ]);
        }
    }

    if (get_app_version() >= '3.2.0') {
        $CI->app->add_settings_section_child('other', 'whatsapp', [
            'name'     => _l('whatsapp_cloud_api'),
            'view'     => 'whatsapp_api/settings/whatsapp_settings',
            'icon'     => 'fa fa-brands fa-whatsapp menu-icon',
            'position' => 50,
        ]);

        $CI->app->add_settings_section_child('other', 'whatsapp_cron', [
            'name'     => _l('whatsapp_cron'),
            'view'     => 'whatsapp_api/settings/whatsapp_cron',
            'position' => 52,
        ]);
    } else {
        $CI->app_tabs->add_settings_tab('whatsapp', [
            'name'     => _l('whatsapp_cloud_api'),
            'view'     => 'whatsapp_api/settings/whatsapp_settings',
            'icon'     => 'fa fa-brands fa-whatsapp menu-icon',
            'position' => 50,
        ]);
        $CI->app_tabs->add_settings_tab(
            'whatsapp_cron',
            [
                'name'     => _l('whatsapp_cron'),
                'view'     => 'whatsapp_api/settings/whatsapp_cron',
                'position' => 52,
            ]
        );
    }

    \modules\whatsapp_api\core\Apiinit::ease_of_mind(WHATSAPP_API_MODULE);
});
