<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<style>
.specific-staff-selection {
    margin-top: 10px !important;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
    background-color: #f9f9f9;
    display: none; /* Initially hidden */
}
.specific-staff-selection.show {
    display: block !important;
    visibility: visible !important;
}
.staff-multi-select {
    width: 100%;
    min-height: 100px;
}
.permission-wrapper {
    min-width: 300px;
}
</style>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="clearfix"></div>
                        <h4 class="customer-profile-group-heading">
                            <i class="fa fa-lock" aria-hidden="true"></i>
                            Reporting Dashboard - Permissions Management
                        </h4>
                        <hr class="hr-panel-heading" />
                        
                        <div class="alert alert-info">
                            <strong>Permission Types:</strong><br>
                            <strong>View All Staff:</strong> Can see activity logs and reports for all staff members<br>
                            <strong>View Own Only:</strong> Can only see their own activity logs and reports<br>
                            <strong>View Specific Staff:</strong> Can see their own activity logs PLUS activity logs for selected specific staff members<br>
                            <strong>Can Generate & Schedule Reports:</strong> Allows generating AI-powered staff reports and scheduling automatic delivery via WhatsApp<br>
                            <em>Note: Staff members always have access to their own logs regardless of permission type. Administrators always have "View All Staff" and report generation permissions by default.</em>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="btn-group pull-right">
                                    <button type="button" class="btn btn-success" onclick="saveAllPermissions()">
                                        <i class="fa fa-save"></i> Save All Changes
                                    </button>
                                    <button type="button" class="btn btn-default" onclick="resetChanges()">
                                        <i class="fa fa-refresh"></i> Reset Changes
                                    </button>
                                </div>
                                <div class="clearfix"></div>
                                <br>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table table-striped table-bordered" id="permissions-table">
                                <thead>
                                    <tr>
                                        <th>Staff Member</th>
                                        <th>Email</th>
                                        <th>Current Permission</th>
                                        <th>New Permission</th>
                                        <th>Allowed Staff</th>
                                        <th>Last Updated</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($staff_permissions as $staff): ?>
                                    <tr data-staff-id="<?php echo $staff['staffid']; ?>">
                                        <td>
                                            <div class="media">
                                                <div class="media-left">
                                                    <?php echo staff_profile_image($staff['staffid'], ['staff-profile-image-small']); ?>
                                                </div>
                                                <div class="media-body media-middle">
                                                    <h5 class="media-heading no-mbot">
                                                        <?php echo $staff['firstname'] . ' ' . $staff['lastname']; ?>
                                                        <?php if(is_admin($staff['staffid'])): ?>
                                                            <span class="label label-primary">Admin</span>
                                                        <?php endif; ?>
                                                    </h5>
                                                </div>
                                            </div>
                                        </td>
                                        <td><?php echo $staff['email']; ?></td>
                                        <td>
                                            <?php 
                                            $current_permission = $staff['permission_type'];
                                            $is_default = $staff['is_default'];
                                            $label_class = 'label-warning';
                                            $permission_text = 'View Own Only';
                                            
                                            if ($current_permission === 'view_all_staff') {
                                                $label_class = 'label-success';
                                                $permission_text = 'View All Staff';
                                            } elseif ($current_permission === 'view_specific_staff') {
                                                $label_class = 'label-info';
                                                $permission_text = 'View Specific Staff';
                                            }
                                            ?>
                                            <span class="label <?php echo $label_class; ?>">
                                                <?php echo $permission_text; ?>
                                                <?php if($is_default): ?>
                                                    <small>(Default)</small>
                                                <?php endif; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <?php if(is_admin($staff['staffid'])): ?>
                                                <span class="text-muted">Admin - Always "View All Staff" & Can Generate Reports</span>
                                            <?php else: ?>
                                                <div class="permission-wrapper" data-staff-id="<?php echo $staff['staffid']; ?>">
                                                    <select class="form-control permission-select" data-staff-id="<?php echo $staff['staffid']; ?>">
                                                        <option value="view_own_only" <?php echo $current_permission === 'view_own_only' ? 'selected' : ''; ?>>
                                                            View Own Only
                                                        </option>
                                                        <option value="view_specific_staff" <?php echo $current_permission === 'view_specific_staff' ? 'selected' : ''; ?>>
                                                            View Specific Staff
                                                        </option>
                                                        <option value="view_all_staff" <?php echo $current_permission === 'view_all_staff' ? 'selected' : ''; ?>>
                                                            View All Staff
                                                        </option>
                                                    </select>
                                                    
                                                    <!-- Report Generation Permission -->
                                                    <div class="checkbox mtop10">
                                                        <label>
                                                            <input type="checkbox" class="can-generate-reports-checkbox" data-staff-id="<?php echo $staff['staffid']; ?>" <?php echo (!empty($staff['can_generate_reports']) ? 'checked' : ''); ?>>
                                                            <strong>Can Generate & Schedule Reports</strong>
                                                            <small class="text-muted">(Allow this user to generate AI reports and schedule automatic delivery)</small>
                                                        </label>
                                                    </div>
                                                    
                                                    <!-- Staff selection for specific staff permission -->
                                                    <div class="specific-staff-selection mt-2" data-initial-permission="<?php echo $current_permission; ?>">
                                                        <label><small>Select staff members:</small></label>
                                                        <select multiple class="form-control staff-multi-select" data-staff-id="<?php echo $staff['staffid']; ?>" size="4">
                                                            <?php
                                                            // Get all available staff except current one
                                                            $available_staff = $reporting_dashboard_permissions_model->get_available_staff_for_permission($staff['staffid']);
                                                            $selected_staff_ids = is_array($staff['allowed_staff_ids']) ? $staff['allowed_staff_ids'] : [];
                                                            
                                                            if (!empty($available_staff)):
                                                                foreach ($available_staff as $avail_staff): 
                                                                    $is_selected = in_array($avail_staff['staffid'], $selected_staff_ids);
                                                                ?>
                                                                    <option value="<?php echo $avail_staff['staffid']; ?>" <?php echo $is_selected ? 'selected' : ''; ?>>
                                                                        <?php echo $avail_staff['firstname'] . ' ' . $avail_staff['lastname']; ?>
                                                                    </option>
                                                                <?php endforeach;
                                                            else: ?>
                                                                <option disabled>No other staff available</option>
                                                            <?php endif; ?>
                                                        </select>
                                                        <small class="text-muted">
                                                            <i class="fa fa-info-circle"></i> 
                                                            This staff member will see their own logs PLUS the selected staff members' logs. 
                                                            Hold Ctrl/Cmd to select multiple staff members.
                                                        </small>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if(!empty($staff['updated_at'])): ?>
                                                <?php echo _dt($staff['updated_at']); ?><br>
                                                <small class="text-muted">
                                                    by <?php echo $staff['granted_by_firstname'] . ' ' . $staff['granted_by_lastname']; ?>
                                                </small>
                                            <?php else: ?>
                                                <span class="text-muted">Default</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if(!is_admin($staff['staffid'])): ?>
                                                <button type="button" class="btn btn-sm btn-info" onclick="updateSinglePermission(<?php echo $staff['staffid']; ?>)">
                                                    <i class="fa fa-save"></i> Update
                                                </button>
                                                <?php if(!$is_default): ?>
                                                    <button type="button" class="btn btn-sm btn-default" onclick="resetToDefault(<?php echo $staff['staffid']; ?>)">
                                                        <i class="fa fa-refresh"></i> Reset
                                                    </button>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <span class="text-muted">Admin - No action needed</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Ensure jQuery is available and prevent conflicts
var jq = jQuery.noConflict(true);

// Define CSRF data
var csrfData = {
    token_name: '<?php echo $this->security->get_csrf_token_name(); ?>',
    hash: '<?php echo $this->security->get_csrf_hash(); ?>'
};

// Wait for jQuery to be fully loaded and ready
(function() {
    var checkJQuery = function() {
        if (typeof jQuery !== 'undefined' && jQuery.fn && jQuery.fn.jquery) {
            // jQuery is loaded, initialize permissions
            initializePermissions();
        } else {
            // jQuery not ready, check again in 50ms
            setTimeout(checkJQuery, 50);
        }
    };
    
    // Start checking for jQuery
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', checkJQuery);
    } else {
        checkJQuery();
    }
})();

function initializePermissions() {
    // Ensure jQuery is available
    if (typeof jQuery === 'undefined') {
        console.error('jQuery is not available');
        return;
    }
    
    jQuery(document).ready(function($) {
        console.log('Permissions page loaded - jQuery ready');
        
        // Initialize permission handlers immediately
        setupPermissionHandlers();
    });
}

function setupPermissionHandlers() {
    // Ensure jQuery is available
    if (typeof jQuery === 'undefined') {
        console.error('jQuery is not available in setupPermissionHandlers');
        return;
    }
    
    var $ = jQuery;
    
    // Debug: Check if permission selects exist
    console.log('Setting up permission handlers...');
    console.log('Found permission selects:', $('.permission-select').length);
    console.log('Found staff selection divs:', $('.specific-staff-selection').length);
    
    // Remove any existing handlers
    $(document).off('change', '.permission-select');
    
    // Handle permission type change to show/hide staff selection
    $(document).on('change', '.permission-select', function() {
        var staffId = $(this).data('staff-id');
        var permissionType = $(this).val();
        var specificStaffDiv = $('.permission-wrapper[data-staff-id="' + staffId + '"] .specific-staff-selection');
        
        console.log('Permission changed for staff ID:', staffId, 'to:', permissionType);
        console.log('Staff selection div found:', specificStaffDiv.length > 0);
        console.log('Current display style:', specificStaffDiv.css('display'));
        
        if (permissionType === 'view_specific_staff') {
            specificStaffDiv.show();
            specificStaffDiv.addClass('show');
            specificStaffDiv.css('display', 'block');
            console.log('Showing staff selection for staff ID:', staffId);
            console.log('After show - display style:', specificStaffDiv.css('display'));
        } else {
            specificStaffDiv.hide();
            specificStaffDiv.removeClass('show');
            console.log('Hiding staff selection for staff ID:', staffId);
        }
    });
    
    // Initial setup - show/hide based on current values
    $('.permission-select').each(function() {
        var staffId = $(this).data('staff-id');
        var permissionType = $(this).val();
        var specificStaffDiv = $('.permission-wrapper[data-staff-id="' + staffId + '"] .specific-staff-selection');
        var initialPermission = specificStaffDiv.data('initial-permission');
        
        console.log('Initial setup for staff ID:', staffId, 'permission:', permissionType, 'initial:', initialPermission);
        
        if (permissionType === 'view_specific_staff' || initialPermission === 'view_specific_staff') {
            specificStaffDiv.show();
            specificStaffDiv.addClass('show');
            console.log('Initially showing staff selection for staff ID:', staffId);
        } else {
            specificStaffDiv.hide();
            specificStaffDiv.removeClass('show');
            console.log('Initially hiding staff selection for staff ID:', staffId);
        }
    });
    
    // Track original values for reset functionality
    window.originalPermissions = {};
    $('.permission-select').each(function() {
        var staffId = $(this).data('staff-id');
        var permissionType = $(this).val();
        var selectedStaff = [];
        
        if (permissionType === 'view_specific_staff') {
            selectedStaff = $('.staff-multi-select[data-staff-id="' + staffId + '"]').val() || [];
        }
        
        window.originalPermissions[staffId] = {
            type: permissionType,
            allowed_staff_ids: selectedStaff
        };
    });
}

function updateSinglePermission(staffId) {
    if (typeof jQuery === 'undefined') {
        console.error('jQuery is not available in updateSinglePermission');
        return;
    }
    
    var $ = jQuery;
    var permissionType = $('.permission-select[data-staff-id="' + staffId + '"]').val();
    var allowedStaffIds = [];
    var canGenerateReports = $('.can-generate-reports-checkbox[data-staff-id="' + staffId + '"]').is(':checked');
    
    if (permissionType === 'view_specific_staff') {
        allowedStaffIds = $('.staff-multi-select[data-staff-id="' + staffId + '"]').val() || [];
        
        if (allowedStaffIds.length === 0) {
            alert_float('warning', 'Please select at least one staff member for specific staff permission');
            return;
        }
    }
    
    $.ajax({
        url: '<?php echo admin_url('reporting_dashboard/update_permission'); ?>',
        type: 'POST',
        data: {
            staff_id: staffId,
            permission_type: permissionType,
            allowed_staff_ids: allowedStaffIds,
            can_generate_reports: canGenerateReports ? 1 : 0,
            [csrfData.token_name]: csrfData.hash
        },
        success: function(response) {
            var data = JSON.parse(response);
            if(data.success) {
                alert_float('success', data.message);
                // Update original value
                window.originalPermissions[staffId] = permissionType;
                // Reload page to show updated info
                setTimeout(function() {
                    location.reload();
                }, 1000);
            } else {
                alert_float('danger', data.message);
            }
        },
        error: function() {
            alert_float('danger', 'Error updating permission');
        }
    });
}

function resetToDefault(staffId) {
    if (typeof jQuery === 'undefined') {
        console.error('jQuery is not available in resetToDefault');
        return;
    }
    
    var $ = jQuery;
    if(confirm('Are you sure you want to reset this staff member\'s permission to default?')) {
        $.ajax({
            url: '<?php echo admin_url('reporting_dashboard/remove_permission'); ?>',
            type: 'POST',
            data: {
                staff_id: staffId,
                [csrfData.token_name]: csrfData.hash
            },
            success: function(response) {
                var data = JSON.parse(response);
                if(data.success) {
                    alert_float('success', data.message);
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                } else {
                    alert_float('danger', data.message);
                }
            },
            error: function() {
                alert_float('danger', 'Error resetting permission');
            }
        });
    }
}

function saveAllPermissions() {
    if (typeof jQuery === 'undefined') {
        console.error('jQuery is not available in saveAllPermissions');
        return;
    }
    
    var $ = jQuery;
    var permissions = {};
    var hasChanges = false;
    
    $('.permission-select').each(function() {
        var staffId = $(this).data('staff-id');
        var currentPermissionType = $(this).val();
        var currentAllowedStaff = [];
        
        if (currentPermissionType === 'view_specific_staff') {
            currentAllowedStaff = $('.staff-multi-select[data-staff-id="' + staffId + '"]').val() || [];
        }
        
        var currentPermission = {
            type: currentPermissionType,
            allowed_staff_ids: currentAllowedStaff
        };
        
        var originalPermission = window.originalPermissions[staffId];
        
        // Check if there are changes
        if (originalPermission.type !== currentPermission.type || 
            JSON.stringify(originalPermission.allowed_staff_ids.sort()) !== JSON.stringify(currentPermission.allowed_staff_ids.sort())) {
            
            if (currentPermissionType === 'view_specific_staff' && currentAllowedStaff.length === 0) {
                alert_float('warning', 'Please select at least one staff member for specific staff permissions before saving');
                return;
            }
            
            permissions[staffId] = currentPermission;
            hasChanges = true;
        }
    });
    
    if(!hasChanges) {
        alert_float('info', 'No changes to save');
        return;
    }
    
    if(confirm('Save all permission changes?')) {
        $.ajax({
            url: '<?php echo admin_url('reporting_dashboard/bulk_update'); ?>',
            type: 'POST',
            data: {
                permissions: permissions,
                [csrfData.token_name]: csrfData.hash
            },
            success: function(response) {
                var data = JSON.parse(response);
                if(data.success) {
                    alert_float('success', data.message);
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                } else {
                    alert_float('danger', data.message);
                    if(data.errors && data.errors.length > 0) {
                        console.log('Errors:', data.errors);
                    }
                }
            },
            error: function() {
                alert_float('danger', 'Error saving permissions');
            }
        });
    }
}

function resetChanges() {
    if (typeof jQuery === 'undefined') {
        console.error('jQuery is not available in resetChanges');
        return;
    }
    
    var $ = jQuery;
    $('.permission-select').each(function() {
        var staffId = $(this).data('staff-id');
        var originalPermission = window.originalPermissions[staffId];
        
        $(this).val(originalPermission.type);
        
        // Reset staff selection
        if (originalPermission.type === 'view_specific_staff') {
            $('.staff-multi-select[data-staff-id="' + staffId + '"]').val(originalPermission.allowed_staff_ids);
            $('.permission-wrapper[data-staff-id="' + staffId + '"] .specific-staff-selection').show();
        } else {
            $('.permission-wrapper[data-staff-id="' + staffId + '"] .specific-staff-selection').hide();
        }
    });
    alert_float('info', 'Changes reset to original values');
}
</script>

<?php init_tail(); ?>
</body>
</html>
