<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-8">
                                <h4 class="no-margin">
                                    Autograph Insights Report
                                </h4>
                                <small class="text-muted">
                                    Analyzed on: <?php echo date('F j, Y g:i A', strtotime($report->analysis_date)); ?>
                                </small>
                            </div>
                            <div class="col-md-4 text-right">
                                <a href="<?php echo admin_url('autograph_feedback_insights'); ?>" 
                                   class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> Back to Dashboard
                                </a>
                                <a href="<?php echo admin_url('autograph_feedback_insights/export_pdf/' . $report->id); ?>" 
                                   class="btn btn-danger">
                                    <i class="fa fa-file-pdf-o"></i> Export PDF
                                </a>
                                <button type="button"
                                        class="btn btn-success"
                                        onclick="window.location.href='<?php echo admin_url('autograph_feedback_insights'); ?>#whatsapp-<?php echo $report->id; ?>'; showWhatsAppModalFromReport(<?php echo $report->id; ?>);">
                                    <i class="fa fa-whatsapp"></i> Send to WhatsApp
                                </button>
                            </div>
                        </div>
                        <hr class="hr-panel-heading" />

                        <!-- Overall Sentiment -->
                        <div class="row mbot20">
                            <div class="col-md-12">
                                <h5 class="bold">Overall Sentiment</h5>
                                <?php
                                $sentiment = strtolower($report->sentiment);
                                $badge_class = 'default';
                                if ($sentiment == 'positive') {
                                    $badge_class = 'success';
                                } elseif ($sentiment == 'negative') {
                                    $badge_class = 'danger';
                                }
                                ?>
                                <span class="label label-<?php echo $badge_class; ?> label-lg">
                                    <?php echo ucfirst($sentiment); ?>
                                </span>
                                <?php if ($report->sentiment_score !== null): ?>
                                    <span class="ml-2">
                                        Score: <?php echo number_format($report->sentiment_score * 100, 1); ?>%
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Summary -->
                        <div class="row mbot20">
                            <div class="col-md-12">
                                <h5 class="bold">Summary</h5>
                                <p><?php echo nl2br(html_escape($report->summary)); ?></p>
                            </div>
                        </div>

                        <!-- Positive Highlights -->
                        <?php 
                        $positive_highlights = json_decode($report->positive_highlights, true);
                        if ($positive_highlights && !empty($positive_highlights)): 
                        ?>
                            <div class="row mbot20">
                                <div class="col-md-12">
                                    <h5 class="bold text-success">Key Positive Highlights</h5>
                                    <ul>
                                        <?php foreach ($positive_highlights as $highlight): ?>
                                            <li><?php echo html_escape($highlight); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                        <?php endif; ?>

                        <!-- Negative Concerns -->
                        <?php 
                        $negative_concerns = json_decode($report->negative_concerns, true);
                        if ($negative_concerns && !empty($negative_concerns)): 
                        ?>
                            <div class="row mbot20">
                                <div class="col-md-12">
                                    <h5 class="bold text-danger">Key Concerns / Objections</h5>
                                    <ul>
                                        <?php foreach ($negative_concerns as $concern): ?>
                                            <li><?php echo html_escape($concern); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                        <?php endif; ?>

                        <!-- Market Narrative -->
                        <?php if (!empty($report->market_narrative)): ?>
                            <div class="row mbot20">
                                <div class="col-md-12">
                                    <h5 class="bold">Market Narrative</h5>
                                    <p><?php echo nl2br(html_escape($report->market_narrative)); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>

                        <!-- Action Suggestions -->
                        <?php 
                        $action_suggestions = json_decode($report->action_suggestions, true);
                        if ($action_suggestions && !empty($action_suggestions)): 
                        ?>
                            <div class="row mbot20">
                                <div class="col-md-12">
                                    <h5 class="bold text-info">Action Suggestions to Improve Messaging</h5>
                                    <ul>
                                        <?php foreach ($action_suggestions as $suggestion): ?>
                                            <li><?php echo html_escape($suggestion); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                        <?php endif; ?>

                        <!-- Stats -->
                        <div class="row mtop20">
                            <div class="col-md-6">
                                <div class="alert alert-info">
                                    <strong>Notes Analyzed:</strong> 
                                    <?php echo $report->notes_analyzed; ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="alert alert-info">
                                    <strong>Leads Analyzed:</strong> 
                                    <?php echo $report->leads_analyzed; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- WhatsApp Send Modal -->
<div class="modal fade" id="whatsappModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Send Report to WhatsApp</h4>
            </div>
            <div class="modal-body">
                <input type="hidden" id="whatsapp_report_id" value="<?php echo $report->id; ?>">
                <div class="form-group">
                    <label>Select Phone Number(s) to Send To:</label>
                    <div id="whatsapp_numbers_list">
                        <!-- Will be populated by JavaScript -->
                    </div>
                </div>
                <div class="form-group">
                    <label>Or Enter Custom Number:</label>
                    <input type="text" 
                           id="custom_whatsapp_number" 
                           class="form-control" 
                           placeholder="+971501234567">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-success" onclick="sendToWhatsApp()">
                    <i class="fa fa-whatsapp"></i> Send
                </button>
            </div>
        </div>
    </div>
</div>

<?php init_tail(); ?>

<script>
// Get configured WhatsApp numbers from settings
var configuredNumbers = <?php 
    $CI = &get_instance();
    $CI->load->model('autograph_feedback_insights/autograph_feedback_insights_model');
    $whatsapp_phone = $CI->autograph_feedback_insights_model->get_setting('whatsapp_phone');
    $numbers = array_filter(array_map('trim', explode("\n", $whatsapp_phone)));
    echo json_encode($numbers);
?>;

function showWhatsAppModalFromReport(reportId) {
    // Populate number list
    var html = '';
    if (configuredNumbers.length > 0) {
        configuredNumbers.forEach(function(number) {
            html += '<div class="checkbox"><label>';
            html += '<input type="checkbox" class="whatsapp-number-checkbox" value="' + number + '" checked> ';
            html += number;
            html += '</label></div>';
        });
    } else {
        html = '<p class="text-muted">No numbers configured in settings. Enter a custom number below.</p>';
    }
    
    $('#whatsapp_numbers_list').html(html);
    $('#custom_whatsapp_number').val('');
    $('#whatsappModal').modal('show');
}

function sendToWhatsApp() {
    var reportId = $('#whatsapp_report_id').val();
    var selectedNumbers = [];
    
    // Get checked numbers
    $('.whatsapp-number-checkbox:checked').each(function() {
        selectedNumbers.push($(this).val());
    });
    
    // Add custom number if provided
    var customNumber = $('#custom_whatsapp_number').val().trim();
    if (customNumber) {
        selectedNumbers.push(customNumber);
    }
    
    if (selectedNumbers.length === 0) {
        alert_float('warning', 'Please select at least one phone number');
        return;
    }
    
    // Confirm
    var confirmMsg = 'Send report to ' + selectedNumbers.length + ' WhatsApp number(s)?';
    if (!confirm(confirmMsg)) {
        return;
    }
    
    // Send via AJAX
    $.ajax({
        url: '<?php echo admin_url('autograph_feedback_insights/send_to_whatsapp_multiple'); ?>',
        type: 'POST',
        dataType: 'json',
        data: {
            report_id: reportId,
            phone_numbers: selectedNumbers
        },
        success: function(response) {
            $('#whatsappModal').modal('hide');
            
            if (response.success) {
                alert_float('success', response.message);
                setTimeout(function() {
                    window.location.href = '<?php echo admin_url('autograph_feedback_insights'); ?>';
                }, 1500);
            } else {
                alert_float('danger', response.message);
            }
        },
        error: function() {
            $('#whatsappModal').modal('hide');
            alert_float('danger', 'An error occurred while sending WhatsApp messages.');
        }
    });
}
</script>

