<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4 class="no-margin">
                            <?php echo _l('autograph_insights'); ?>
                        </h4>
                        <hr class="hr-panel-heading" />

                        <!-- Settings Section -->
                        <div class="row mtop20">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h5 class="bold"><?php echo _l('autograph_settings'); ?></h5>
                                    </div>
                                    <div class="panel-body">
                                        <?php echo form_open(admin_url('autograph_feedback_insights')); ?>
                                        <input type="hidden" name="update_settings" value="1">
                                        
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="openai_api_key"><?php echo _l('autograph_openai_api_key'); ?></label>
                                                    <input type="text" 
                                                           name="openai_api_key" 
                                                           id="openai_api_key"
                                                           class="form-control"
                                                           value="<?php echo html_escape($settings['openai_api_key'] ?? ''); ?>"
                                                           placeholder="sk-...">
                                                    <small class="help-block"><?php echo _l('autograph_openai_api_key_help'); ?></small>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="openai_model"><?php echo _l('autograph_openai_model'); ?></label>
                                                    <select name="openai_model" id="openai_model" class="form-control selectpicker">
                                                        <option value="gpt-4-turbo-preview" <?php echo ($settings['openai_model'] ?? 'gpt-4-turbo-preview') == 'gpt-4-turbo-preview' ? 'selected' : ''; ?>>GPT-4 Turbo (128k tokens - Recommended)</option>
                                                        <option value="gpt-4-turbo" <?php echo ($settings['openai_model'] ?? '') == 'gpt-4-turbo' ? 'selected' : ''; ?>>GPT-4 Turbo</option>
                                                        <option value="gpt-4" <?php echo ($settings['openai_model'] ?? '') == 'gpt-4' ? 'selected' : ''; ?>>GPT-4 (8k tokens)</option>
                                                        <option value="gpt-3.5-turbo-16k" <?php echo ($settings['openai_model'] ?? '') == 'gpt-3.5-turbo-16k' ? 'selected' : ''; ?>>GPT-3.5 Turbo 16k</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="cron_enabled"><?php echo _l('autograph_cron_enabled'); ?></label>
                                                    <div class="onoffswitch">
                                                        <input type="checkbox" 
                                                               name="cron_enabled" 
                                                               class="onoffswitch-checkbox" 
                                                               id="cron_enabled"
                                                               <?php echo ($settings['cron_enabled'] ?? '0') == '1' ? 'checked' : ''; ?>>
                                                        <label class="onoffswitch-label" for="cron_enabled"></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label for="whatsapp_phone">WhatsApp Phone Numbers (one per line)</label>
                                                    <textarea name="whatsapp_phone" 
                                                              id="whatsapp_phone"
                                                              class="form-control"
                                                              rows="3"
                                                              placeholder="+971501234567&#10;+971509876543&#10;+971501112222"><?php echo html_escape($settings['whatsapp_phone'] ?? ''); ?></textarea>
                                                    <small class="help-block">Enter each phone number on a new line with country code (e.g., +971501234567). Reports will be sent to ALL numbers when you click "Run Analysis Now".</small>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label for="status_filter">Filter by Lead Status (Optional)</label>
                                                    <select name="status_filter[]" id="status_filter" class="form-control selectpicker" multiple data-actions-box="true" data-selected-text-format="count > 3" data-none-selected-text="All Leads (Autograph mentions only)">
                                                        <?php 
                                                        $selected_statuses = [];
                                                        if (!empty($settings['status_filter'])) {
                                                            $selected_statuses = json_decode($settings['status_filter'], true);
                                                            if (!is_array($selected_statuses)) {
                                                                $selected_statuses = [];
                                                            }
                                                        }
                                                        foreach ($lead_statuses as $status): 
                                                        ?>
                                                            <option value="<?php echo $status['id']; ?>" 
                                                                <?php echo in_array($status['id'], $selected_statuses) ? 'selected' : ''; ?>>
                                                                <?php echo html_escape($status['name']); ?>
                                                            </option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                    <small class="help-block">
                                                        <strong>Important:</strong><br>
                                                        • <strong>Status Selected:</strong> Analyzes ALL notes from leads with selected status(es)<br>
                                                        • <strong>No Status Selected:</strong> Analyzes only notes mentioning "Autograph" from all leads
                                                    </small>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-12">
                                                <button type="submit" class="btn btn-info">
                                                    <?php echo _l('autograph_save_settings'); ?>
                                                </button>
                                            </div>
                                        </div>
                                        
                                        <?php echo form_close(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Analysis Section -->
                        <div class="row mtop20">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h5 class="bold"><?php echo _l('autograph_run_analysis'); ?></h5>
                                    </div>
                                    <div class="panel-body">
                                        <p>
                                            <strong><?php echo _l('autograph_notes_found'); ?>:</strong> 
                                            <?php echo $notes_count; ?> 
                                            <?php 
                                            $status_filter_setting = $settings['status_filter'] ?? '';
                                            if (!empty($status_filter_setting)) {
                                                echo 'notes from leads with selected statuses';
                                            } else {
                                                echo _l('autograph_notes_related_to_autograph');
                                            }
                                            ?>
                                        </p>
                                        
                                        <?php if (empty($settings['openai_api_key'])): ?>
                                            <div class="alert alert-warning">
                                                <?php echo _l('autograph_api_key_required'); ?>
                                            </div>
                                        <?php else: ?>
                                            <button type="button" 
                                                    id="run-analysis-btn" 
                                                    class="btn btn-primary btn-lg">
                                                <i class="fa fa-refresh"></i> 
                                                <?php echo _l('autograph_run_analysis_now'); ?>
                                            </button>
                                            
                                            <?php 
                                            $whatsapp_phone_setting = $settings['whatsapp_phone'] ?? '';
                                            $whatsapp_numbers_configured = array_filter(array_map('trim', explode("\n", $whatsapp_phone_setting)));
                                            if (!empty($whatsapp_numbers_configured)): 
                                            ?>
                                                <button type="button" 
                                                        id="run-and-send-btn" 
                                                        class="btn btn-success btn-lg">
                                                    <i class="fa fa-whatsapp"></i> 
                                                    Run & Send to WhatsApp (<?php echo count($whatsapp_numbers_configured); ?> numbers)
                                                </button>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        
                                        <div id="analysis-progress" style="display:none; margin-top:15px;">
                                            <div class="alert alert-info">
                                                <i class="fa fa-spinner fa-spin"></i> 
                                                <?php echo _l('autograph_analyzing'); ?>...
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Latest Report Section -->
                        <?php if ($latest_report): ?>
                            <div class="row mtop20">
                                <div class="col-md-12">
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h5 class="bold"><?php echo _l('autograph_latest_report'); ?></h5>
                                            <small class="text-muted">
                                                <?php echo _l('autograph_analyzed_on'); ?>: 
                                                <?php echo date('Y-m-d H:i:s', strtotime($latest_report->analysis_date)); ?>
                                            </small>
                                        </div>
                                        <div class="panel-body">
                                            <!-- Sentiment Score -->
                                            <div class="row mbot20">
                                                <div class="col-md-12">
                                                    <h5 class="bold"><?php echo _l('autograph_overall_sentiment'); ?></h5>
                                                    <?php
                                                    $sentiment = strtolower($latest_report->sentiment);
                                                    $badge_class = 'default';
                                                    if ($sentiment == 'positive') {
                                                        $badge_class = 'success';
                                                    } elseif ($sentiment == 'negative') {
                                                        $badge_class = 'danger';
                                                    }
                                                    ?>
                                                    <span class="label label-<?php echo $badge_class; ?> label-lg">
                                                        <?php echo ucfirst($sentiment); ?>
                                                    </span>
                                                    <?php if ($latest_report->sentiment_score !== null): ?>
                                                        <span class="ml-2">
                                                            Score: <?php echo number_format($latest_report->sentiment_score * 100, 1); ?>%
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <!-- Summary -->
                                            <div class="row mbot20">
                                                <div class="col-md-12">
                                                    <h5 class="bold"><?php echo _l('autograph_summary'); ?></h5>
                                                    <p><?php echo nl2br(html_escape($latest_report->summary)); ?></p>
                                                </div>
                                            </div>

                                            <!-- Positive Highlights -->
                                            <?php 
                                            $positive_highlights = json_decode($latest_report->positive_highlights, true);
                                            if ($positive_highlights && !empty($positive_highlights)): 
                                            ?>
                                                <div class="row mbot20">
                                                    <div class="col-md-12">
                                                        <h5 class="bold text-success"><?php echo _l('autograph_positive_highlights'); ?></h5>
                                                        <ul>
                                                            <?php foreach ($positive_highlights as $highlight): ?>
                                                                <li><?php echo html_escape($highlight); ?></li>
                                                            <?php endforeach; ?>
                                                        </ul>
                                                    </div>
                                                </div>
                                            <?php endif; ?>

                                            <!-- Negative Concerns -->
                                            <?php 
                                            $negative_concerns = json_decode($latest_report->negative_concerns, true);
                                            if ($negative_concerns && !empty($negative_concerns)): 
                                            ?>
                                                <div class="row mbot20">
                                                    <div class="col-md-12">
                                                        <h5 class="bold text-danger"><?php echo _l('autograph_negative_concerns'); ?></h5>
                                                        <ul>
                                                            <?php foreach ($negative_concerns as $concern): ?>
                                                                <li><?php echo html_escape($concern); ?></li>
                                                            <?php endforeach; ?>
                                                        </ul>
                                                    </div>
                                                </div>
                                            <?php endif; ?>

                                            <!-- Market Narrative -->
                                            <?php if (!empty($latest_report->market_narrative)): ?>
                                                <div class="row mbot20">
                                                    <div class="col-md-12">
                                                        <h5 class="bold"><?php echo _l('autograph_market_narrative'); ?></h5>
                                                        <p><?php echo nl2br(html_escape($latest_report->market_narrative)); ?></p>
                                                    </div>
                                                </div>
                                            <?php endif; ?>

                                            <!-- Action Suggestions -->
                                            <?php 
                                            $action_suggestions = json_decode($latest_report->action_suggestions, true);
                                            if ($action_suggestions && !empty($action_suggestions)): 
                                            ?>
                                                <div class="row mbot20">
                                                    <div class="col-md-12">
                                                        <h5 class="bold text-info"><?php echo _l('autograph_action_suggestions'); ?></h5>
                                                        <ul>
                                                            <?php foreach ($action_suggestions as $suggestion): ?>
                                                                <li><?php echo html_escape($suggestion); ?></li>
                                                            <?php endforeach; ?>
                                                        </ul>
                                                    </div>
                                                </div>
                                            <?php endif; ?>

                                            <!-- Stats -->
                                            <div class="row mtop20">
                                                <div class="col-md-6">
                                                    <div class="alert alert-info">
                                                        <strong><?php echo _l('autograph_notes_analyzed'); ?>:</strong> 
                                                        <?php echo $latest_report->notes_analyzed; ?>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="alert alert-info">
                                                        <strong><?php echo _l('autograph_leads_analyzed'); ?>:</strong> 
                                                        <?php echo $latest_report->leads_analyzed; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="row mtop20">
                                <div class="col-md-12">
                                    <div class="alert alert-info">
                                        <?php echo _l('autograph_no_report_yet'); ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <!-- Previous Reports Section -->
                        <?php if (!empty($reports) && count($reports) > 0): ?>
                            <div class="row mtop20">
                                <div class="col-md-12">
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h5 class="bold">Previous Reports History</h5>
                                        </div>
                                        <div class="panel-body">
                                            <div class="table-responsive">
                                                <table class="table table-striped table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th>Analysis Date</th>
                                                            <th>Sentiment</th>
                                                            <th>Score</th>
                                                            <th>Notes</th>
                                                            <th>Leads</th>
                                                            <th>Actions</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach ($reports as $report): ?>
                                                            <tr>
                                                                <td><?php echo date('M j, Y g:i A', strtotime($report->analysis_date)); ?></td>
                                                                <td>
                                                                    <?php
                                                                    $sentiment = strtolower($report->sentiment);
                                                                    $badge_class = 'default';
                                                                    if ($sentiment == 'positive') {
                                                                        $badge_class = 'success';
                                                                    } elseif ($sentiment == 'negative') {
                                                                        $badge_class = 'danger';
                                                                    }
                                                                    ?>
                                                                    <span class="label label-<?php echo $badge_class; ?>">
                                                                        <?php echo ucfirst($sentiment); ?>
                                                                    </span>
                                                                </td>
                                                                <td>
                                                                    <?php echo $report->sentiment_score !== null ? number_format($report->sentiment_score * 100, 1) . '%' : '-'; ?>
                                                                </td>
                                                                <td><?php echo $report->notes_analyzed; ?></td>
                                                                <td><?php echo $report->leads_analyzed; ?></td>
                                                                <td>
                                                                    <a href="<?php echo admin_url('autograph_feedback_insights/view_report/' . $report->id); ?>" 
                                                                       class="btn btn-sm btn-default" 
                                                                       title="View Report">
                                                                        <i class="fa fa-eye"></i> View
                                                                    </a>
                                                                    <a href="<?php echo admin_url('autograph_feedback_insights/export_pdf/' . $report->id); ?>" 
                                                                       class="btn btn-sm btn-danger" 
                                                                       title="Export to PDF">
                                                                        <i class="fa fa-file-pdf-o"></i> PDF
                                                                    </a>
                                                                    <button type="button"
                                                                            class="btn btn-sm btn-success" 
                                                                            title="Send to WhatsApp"
                                                                            onclick="showWhatsAppModal(<?php echo $report->id; ?>)">
                                                                        <i class="fa fa-whatsapp"></i> WhatsApp
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- WhatsApp Send Modal -->
<div class="modal fade" id="whatsappModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Send Report to WhatsApp</h4>
            </div>
            <div class="modal-body">
                <input type="hidden" id="whatsapp_report_id">
                <div class="form-group">
                    <label>Select Phone Number(s) to Send To:</label>
                    <div id="whatsapp_numbers_list">
                        <!-- Will be populated by JavaScript -->
                    </div>
                </div>
                <div class="form-group">
                    <label>Or Enter Custom Number:</label>
                    <input type="text" 
                           id="custom_whatsapp_number" 
                           class="form-control" 
                           placeholder="+971501234567">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-success" onclick="sendToWhatsApp()">
                    <i class="fa fa-whatsapp"></i> Send
                </button>
            </div>
        </div>
    </div>
</div>

<?php init_tail(); ?>

<script>
// Get configured WhatsApp numbers from settings
var configuredNumbers = <?php 
    $whatsapp_phone = $settings['whatsapp_phone'] ?? '';
    $numbers = array_filter(array_map('trim', explode("\n", $whatsapp_phone)));
    echo json_encode($numbers);
?>;

$(document).ready(function() {
    $('#run-analysis-btn').on('click', function() {
        var $btn = $(this);
        var $progress = $('#analysis-progress');
        
        $btn.prop('disabled', true);
        $progress.show();
        
        $.ajax({
            url: '<?php echo admin_url('autograph_feedback_insights/run_analysis_ajax'); ?>',
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                $progress.hide();
                $btn.prop('disabled', false);
                
                if (response.success) {
                    alert_float('success', response.message);
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    alert_float('danger', response.message);
                }
            },
            error: function() {
                $progress.hide();
                $btn.prop('disabled', false);
                alert_float('danger', 'An error occurred while running the analysis.');
            }
        });
    });

    // Run analysis and send to WhatsApp
    $('#run-and-send-btn').on('click', function() {
        var $btn = $(this);
        var $progress = $('#analysis-progress');
        
        if (!confirm('Run analysis and send to all configured WhatsApp numbers?')) {
            return;
        }
        
        $btn.prop('disabled', true);
        $('#run-analysis-btn').prop('disabled', true);
        $progress.show();
        
        $.ajax({
            url: '<?php echo admin_url('autograph_feedback_insights/run_analysis_and_send'); ?>',
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                $progress.hide();
                $btn.prop('disabled', false);
                $('#run-analysis-btn').prop('disabled', false);
                
                if (response.success) {
                    var message = response.message;
                    if (response.whatsapp_sent > 0) {
                        message += ' Sent to ' + response.whatsapp_sent + ' WhatsApp number(s).';
                    }
                    alert_float('success', message);
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    alert_float('danger', response.message);
                }
            },
            error: function() {
                $progress.hide();
                $btn.prop('disabled', false);
                $('#run-analysis-btn').prop('disabled', false);
                alert_float('danger', 'An error occurred while running the analysis.');
            }
        });
    });
});

function showWhatsAppModal(reportId) {
    $('#whatsapp_report_id').val(reportId);
    
    // Populate number list
    var html = '';
    if (configuredNumbers.length > 0) {
        configuredNumbers.forEach(function(number) {
            html += '<div class="checkbox"><label>';
            html += '<input type="checkbox" class="whatsapp-number-checkbox" value="' + number + '" checked> ';
            html += number;
            html += '</label></div>';
        });
    } else {
        html = '<p class="text-muted">No numbers configured in settings. Enter a custom number below.</p>';
    }
    
    $('#whatsapp_numbers_list').html(html);
    $('#custom_whatsapp_number').val('');
    $('#whatsappModal').modal('show');
}

function sendToWhatsApp() {
    var reportId = $('#whatsapp_report_id').val();
    var selectedNumbers = [];
    
    // Get checked numbers
    $('.whatsapp-number-checkbox:checked').each(function() {
        selectedNumbers.push($(this).val());
    });
    
    // Add custom number if provided
    var customNumber = $('#custom_whatsapp_number').val().trim();
    if (customNumber) {
        selectedNumbers.push(customNumber);
    }
    
    if (selectedNumbers.length === 0) {
        alert_float('warning', 'Please select at least one phone number');
        return;
    }
    
    // Confirm
    var confirmMsg = 'Send report to ' + selectedNumbers.length + ' WhatsApp number(s)?';
    if (!confirm(confirmMsg)) {
        return;
    }
    
    // Send via AJAX
    $.ajax({
        url: '<?php echo admin_url('autograph_feedback_insights/send_to_whatsapp_multiple'); ?>',
        type: 'POST',
        dataType: 'json',
        data: {
            report_id: reportId,
            phone_numbers: selectedNumbers
        },
        success: function(response) {
            $('#whatsappModal').modal('hide');
            
            if (response.success) {
                alert_float('success', response.message);
            } else {
                alert_float('danger', response.message);
            }
        },
        error: function() {
            $('#whatsappModal').modal('hide');
            alert_float('danger', 'An error occurred while sending WhatsApp messages.');
        }
    });
}
</script>

<?php init_tail(); ?>

