# Autograph Feedback Insights - cPanel Installation Guide

## 🚀 Quick Installation (3 Steps)

### Step 1: Upload Module to cPanel

**Option A: Using File Manager**
1. Login to your cPanel
2. Go to **File Manager**
3. Navigate to: `public_html/modules/` (or wherever your Perfex CRM is installed)
4. Click **Upload**
5. Upload the entire `autograph_feedback_insights` folder
6. Make sure the folder structure is: `public_html/modules/autograph_feedback_insights/`

**Option B: Using FTP**
1. Connect to your server via FTP (FileZilla, WinSCP, etc.)
2. Navigate to: `/public_html/modules/`
3. Upload the `autograph_feedback_insights` folder
4. Ensure correct folder structure

### Step 2: Activate the Module

1. Login to your Perfex CRM admin panel
2. Go to **Setup → Modules**
3. Find **"Autograph Feedback Insights"** in the list
4. Click **Activate**
5. ✅ **That's it!** All database tables are created automatically!

### Step 3: Configure the Module

1. Look for **"Autograph Insights"** in the sidebar menu (independent menu after "Leads Reporting")
2. Click **Dashboard**
3. Configure:
   - **OpenAI API Key**: Enter your API key (starts with sk-)
   - **OpenAI Model**: Select GPT-4 Turbo (recommended)
   - **WhatsApp Phone** (optional): Enter number to receive reports
   - **Status Filter** (optional): Select lead statuses to analyze
4. Click **Save Settings**
5. Click **Run Analysis Now** to generate your first report!

## ✅ What Gets Installed Automatically

When you activate the module, it creates:

### Database Tables (Auto-Created):
1. **tblautograph_feedback_report** - Stores sentiment analysis reports
2. **tblautograph_feedback_settings** - Stores module configuration
3. **tblautograph_feedback_schedules** - Stores automated schedules

### Menu Items (Auto-Added):
- **Autograph Insights** (independent sidebar menu)
  - Dashboard
  - Automated Schedules

### Default Settings (Auto-Configured):
- OpenAI Model: gpt-4-turbo-preview
- Cron Enabled: No (you enable manually)
- All other settings: Empty (you fill in)

## 📁 Required Folder Structure

After upload, verify this structure exists:

```
public_html/modules/autograph_feedback_insights/
├── autograph_feedback_insights.php
├── install.php
├── uninstall.php
├── config/config.php
├── controllers/
│   ├── Autograph_feedback_insights.php
│   └── Cron.php
├── models/
│   └── Autograph_feedback_insights_model.php
├── views/
│   ├── insights.php
│   ├── schedules.php
│   └── view_report.php
├── includes/
│   └── sidebar_menu_links.php
├── language/english/
│   └── autograph_feedback_insights_lang.php
└── Documentation files (*.md)
```

## 🔧 Post-Installation Setup

### 1. Get OpenAI API Key
- Go to: https://platform.openai.com/api-keys
- Create new API key
- Copy it (starts with `sk-`)

### 2. Configure Module
- Enter OpenAI API key in module settings
- Select GPT-4 Turbo model (handles large datasets)
- Optionally configure WhatsApp number

### 3. Test Manual Analysis
- Click **Run Analysis Now**
- Wait for analysis to complete
- View the generated report

### 4. Setup Automated Schedules (Optional)
- Go to **Autograph Insights → Automated Schedules**
- Click **New Schedule**
- Configure filters, time, and WhatsApp recipients
- Save and enable

### 5. Setup Cron Job (Optional - for automation)

**In cPanel:**
1. Go to **Cron Jobs** in cPanel
2. Add new cron job:
   - **Minute**: 0
   - **Hour**: * (every hour)
   - **Day**: *
   - **Month**: *
   - **Weekday**: *
   - **Command**: 
     ```bash
     /usr/bin/php /home/username/public_html/index.php autograph_feedback_insights cron execute_schedules
     ```
3. Click **Add New Cron Job**

## 🎯 No Manual SQL Required!

✅ **All database tables are created automatically** when you activate the module

✅ **All settings are initialized automatically**

✅ **Menu items appear automatically**

✅ **No manual database queries needed**

## 🔍 Verification

After activation, verify:

1. **Menu Appears**: Check sidebar for "Autograph Insights"
2. **Dashboard Loads**: Click Dashboard - should load without errors
3. **Tables Created**: Go to phpMyAdmin → your database → check for:
   - `tblautograph_feedback_report`
   - `tblautograph_feedback_settings`
   - `tblautograph_feedback_schedules`

## 🆘 Troubleshooting

### Module doesn't activate
- Check PHP version (7.4+ required)
- Check folder permissions (755 recommended)
- Check error logs

### Tables not created
- Check database user has CREATE TABLE permission
- Check error logs in cPanel
- Try deactivating and reactivating

### Menu not appearing
- Clear browser cache (Ctrl + F5)
- Deactivate/Reactivate module
- Check you're logged in as staff member

### 404 Error on pages
- Verify folder structure is correct
- Check .htaccess file exists
- Verify mod_rewrite is enabled

## 📦 Files Included

- ✅ All PHP files (controllers, models, views)
- ✅ Language files (English)
- ✅ Installation scripts (auto-run)
- ✅ Configuration files
- ✅ Documentation (README, guides)

## 🌟 Features Ready After Installation

1. **Dashboard**: Sentiment analysis and reporting
2. **Status Filtering**: Filter by lead status
3. **Date Range Filtering**: Analyze specific time periods
4. **Report History**: All reports saved automatically
5. **PDF Export**: Download professional reports
6. **WhatsApp Integration**: Send reports via WhatsApp
7. **Automated Schedules**: Set and forget automation
8. **Multi-recipient**: Send to multiple numbers

## 📞 Support

After installation, access module documentation:
- `README.md` - General overview
- `INSTALLATION.md` - Installation details
- `AUTOMATED_SCHEDULES_GUIDE.md` - Scheduling guide
- `MODULE_SUMMARY.md` - Complete feature list

## ⚡ Quick Start After Installation

1. Activate module
2. Go to Dashboard
3. Enter OpenAI API key
4. Click "Run Analysis Now"
5. View your first sentiment analysis report!

That's it! The module is fully self-contained and installs completely automatically.


