// Fix for lead attachment descriptions not appearing
// This script adds the missing code to ensure descriptions are correctly saved with attachments

// Create a helper function to update attachments table
function fix_lead_attachment_descriptions() {
    var dropzone = document.getElementById("lead-attachment-upload");
    
    // Only execute on the leads page with the attachments tab
    if (dropzone) {
        // Add event listener to monitor uploads
        dropzone.addEventListener("drop", function(e) {
            // Save the current description
            var description = $("#attachment_description").val();
            console.log("Description set for upload: " + description);
            
            // Make sure description is saved with the file
            if (typeof leadAttachmentsDropzone !== 'undefined') {
                leadAttachmentsDropzone.options.autoProcessQueue = false;
                
                // Process files one at a time to ensure description is attached to each
                leadAttachmentsDropzone.on("addedfile", function(file) {
                    console.log("File added to queue: " + file.name);
                });
                
                // Clear existing listeners
                leadAttachmentsDropzone.off("sending");
                
                // Add new sending listener
                leadAttachmentsDropzone.on("sending", function(file, xhr, formData) {
                    var lead_id = $('input[name="leadid"]').val();
                    formData.append("id", lead_id);
                    formData.append("last_file", true);
                    
                    // Get the description from the textarea
                    var description = $("#attachment_description").val();
                    if (description) {
                        console.log("Sending description with file: " + description);
                        formData.append("description", description);
                    }
                });
                
                // Process the queue after a slight delay
                setTimeout(function() {
                    leadAttachmentsDropzone.processQueue();
                }, 100);
            }
        });
    }
}

// Call the function when document is ready
$(document).ready(function() {
    // Execute when lead modal is loaded
    $(document).on('app.lead-modal-loaded', function() {
        fix_lead_attachment_descriptions();
    });
});
