<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-8">
                                <h4 class="no-margin">
                                    <i class="fa fa-brain text-primary"></i> 
                                    <?php echo $title; ?>
                                    <?php if (isset($lead)): ?>
                                        - <?php echo $lead->name; ?>
                                    <?php endif; ?>
                                </h4>
                            </div>
                            <div class="col-md-4 text-right">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-success dropdown-toggle" data-toggle="dropdown">
                                        <i class="fa fa-download"></i> Export Reports <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                        <li><a href="<?php echo admin_url('leads/export_ai_reports/csv' . (isset($lead_id) ? '/' . $lead_id : '')); ?>">
                                            <i class="fa fa-file-excel-o"></i> Export as CSV
                                        </a></li>
                                        <li><a href="<?php echo admin_url('leads/export_ai_reports/xlsx' . (isset($lead_id) ? '/' . $lead_id : '')); ?>">
                                            <i class="fa fa-file-excel-o"></i> Export as Excel
                                        </a></li>
                                        <li><a href="<?php echo admin_url('leads/export_ai_reports/pdf' . (isset($lead_id) ? '/' . $lead_id : '')); ?>">
                                            <i class="fa fa-file-pdf-o"></i> Export as PDF/HTML
                                        </a></li>
                                    </ul>
                                </div>
                                <?php if (!isset($lead)): ?>
                                <a href="<?php echo admin_url('leads'); ?>" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> Back to Leads
                                </a>
                                <?php else: ?>
                                <a href="<?php echo admin_url('leads/index/' . $lead->id); ?>" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> Back to Lead
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <hr class="hr-panel-heading">
                        
                        <?php if (!isset($lead)): ?>
                        <!-- Dashboard Statistics -->
                        <div class="row">
                            <div class="col-md-3">
                                <div class="panel panel-primary">
                                    <div class="panel-body text-center">
                                        <h3 class="no-margin"><?php echo $stats['total_reports'] ?? 0; ?></h3>
                                        <p class="text-muted">Total Reports</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="panel panel-success">
                                    <div class="panel-body text-center">
                                        <h3 class="no-margin"><?php echo $stats['recent_count'] ?? 0; ?></h3>
                                        <p class="text-muted">Last 30 Days</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="panel panel-info">
                                    <div class="panel-body text-center">
                                        <h3 class="no-margin"><?php echo $stats['avg_score'] ?? 0; ?>%</h3>
                                        <p class="text-muted">Average Score</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="panel panel-warning">
                                    <div class="panel-body text-center">
                                        <h3 class="no-margin">
                                            <?php echo isset($stats['by_verdict']['Hot']) ? $stats['by_verdict']['Hot'] : 0; ?>
                                        </h3>
                                        <p class="text-muted">Hot Leads</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Verdict Distribution Chart -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Lead Distribution by Verdict</h4>
                                    </div>
                                    <div class="panel-body">
                                        <canvas id="verdictChart" width="400" height="200"></canvas>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Score Distribution</h4>
                                    </div>
                                    <div class="panel-body">
                                        <p><strong>Highest Score:</strong> <?php echo $stats['max_score'] ?? 0; ?>%</p>
                                        <p><strong>Lowest Score:</strong> <?php echo $stats['min_score'] ?? 0; ?>%</p>
                                        <p><strong>Average Score:</strong> <?php echo $stats['avg_score'] ?? 0; ?>%</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Reports Table -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            AI Analysis Reports
                                            <?php if (isset($lead)): ?>
                                                (<?php echo count($reports); ?> reports)
                                            <?php endif; ?>
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php if (empty($reports)): ?>
                                            <div class="text-center text-muted">
                                                <i class="fa fa-search fa-3x"></i>
                                                <h4>No AI analysis reports found</h4>
                                                <p>AI analysis reports will appear here once leads are analyzed.</p>
                                                <?php if (isset($lead)): ?>
                                                    <a href="<?php echo admin_url('leads/index/' . $lead->id); ?>" class="btn btn-primary">
                                                        <i class="fa fa-brain"></i> Analyze This Lead
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        <?php else: ?>
                                            <div class="table-responsive">
                                                <table class="table table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th>ID</th>
                                                            <?php if (!isset($lead)): ?>
                                                            <th>Lead</th>
                                                            <?php endif; ?>
                                                            <th>Score</th>
                                                            <th>Verdict</th>
                                                            <th>Confidence</th>
                                                            <th>Key Insights Preview</th>
                                                            <th>Files</th>
                                                            <th>Analyst</th>
                                                            <th>Date</th>
                                                            <th>Actions</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach ($reports as $report): ?>
                                                        <tr>
                                                            <td><?php echo $report->id; ?></td>
                                                            <?php if (!isset($lead)): ?>
                                                            <td>
                                                                <strong><?php echo $report->lead_name ?? 'Unknown'; ?></strong><br>
                                                                <small class="text-muted"><?php echo $report->lead_email ?? ''; ?></small>
                                                            </td>
                                                            <?php endif; ?>
                                                            <td>
                                                                <span class="label label-<?php 
                                                                    echo $report->score >= 80 ? 'success' : 
                                                                        ($report->score >= 60 ? 'warning' : 'default'); 
                                                                ?>">
                                                                    <?php echo $report->score; ?>%
                                                                </span>
                                                            </td>
                                                            <td>
                                                                <span class="label label-<?php 
                                                                    echo strtolower($report->verdict) == 'hot' ? 'danger' : 
                                                                        (strtolower($report->verdict) == 'warm' ? 'warning' : 
                                                                        (strtolower($report->verdict) == 'qualified' ? 'success' : 'default')); 
                                                                ?>">
                                                                    <?php echo $report->verdict; ?>
                                                                </span>
                                                            </td>
                                                            <td><?php echo $report->confidence_level ?? 'Medium'; ?></td>
                                                            <td>
                                                                <div style="max-width: 300px; overflow: hidden; text-overflow: ellipsis;">
                                                                    <?php 
                                                                    $insights = $report->detailed_insights ?? $report->rationale ?? '';
                                                                    echo substr(strip_tags($insights), 0, 150) . (strlen($insights) > 150 ? '...' : '');
                                                                    ?>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <span class="badge"><?php echo $report->files_analyzed_count ?? 0; ?></span>
                                                            </td>
                                                            <td>
                                                                <?php 
                                                                echo ($report->analyst_firstname ?? '') . ' ' . ($report->analyst_lastname ?? '');
                                                                ?>
                                                            </td>
                                                            <td>
                                                                <span title="<?php echo $report->created_at; ?>">
                                                                    <?php echo time_ago($report->created_at); ?>
                                                                </span>
                                                            </td>
                                                            <td>
                                                                <div class="btn-group">
                                                                    <a href="<?php echo admin_url('leads/view_ai_report/' . $report->id); ?>" 
                                                                       class="btn btn-default btn-xs" title="View Details">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                    <?php if (!isset($lead)): ?>
                                                                    <a href="<?php echo admin_url('leads/index/' . $report->lead_id); ?>" 
                                                                       class="btn btn-primary btn-xs" title="View Lead">
                                                                        <i class="fa fa-user"></i>
                                                                    </a>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                            
                                            <?php if (isset($pagination)): ?>
                                            <div class="text-center">
                                                <?php echo $pagination; ?>
                                            </div>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php init_tail(); ?>

<?php if (!isset($lead) && !empty($stats['by_verdict'])): ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Verdict Distribution Chart
var ctx = document.getElementById('verdictChart').getContext('2d');
var verdictChart = new Chart(ctx, {
    type: 'doughnut',
    data: {
        labels: [
            <?php foreach ($stats['by_verdict'] as $verdict => $count): ?>
            '<?php echo $verdict; ?>',
            <?php endforeach; ?>
        ],
        datasets: [{
            data: [
                <?php foreach ($stats['by_verdict'] as $verdict => $count): ?>
                <?php echo $count; ?>,
                <?php endforeach; ?>
            ],
            backgroundColor: [
                '#dc3545', // Hot - Red
                '#fd7e14', // Warm - Orange  
                '#6c757d', // Cold - Gray
                '#28a745', // Qualified - Green
                '#007bff', // Other - Blue
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        legend: {
            position: 'bottom'
        }
    }
});
</script>
<?php endif; ?>
