<?php foreach($notes as $note) { 
    // Detect communication type from note content
    $note_text = strtolower($note['description']);
    $communication_type = 'general';
    $icon = 'fa-sticky-note';
    $color_class = 'note-general';
    
    if (strpos($note_text, 'whatsapp') !== false || strpos($note_text, 'whats app') !== false) {
        $communication_type = 'whatsapp';
        $icon = 'fa-whatsapp';
        $color_class = 'note-whatsapp';
    } elseif (strpos($note_text, 'call') !== false || strpos($note_text, 'phone') !== false || strpos($note_text, 'rang') !== false) {
        $communication_type = 'call';
        $icon = 'fa-phone';
        $color_class = 'note-call';
    } elseif (strpos($note_text, 'message') !== false || strpos($note_text, 'sms') !== false || strpos($note_text, 'text') !== false) {
        $communication_type = 'message';
        $icon = 'fa-comment';
        $color_class = 'note-message';
    } elseif (strpos($note_text, 'email') !== false || strpos($note_text, 'mail') !== false) {
        $communication_type = 'email';
        $icon = 'fa-envelope';
        $color_class = 'note-email';
    } elseif (strpos($note_text, 'meeting') !== false || strpos($note_text, 'visit') !== false) {
        $communication_type = 'meeting';
        $icon = 'fa-users';
        $color_class = 'note-meeting';
    }
?>
<div class="lead-note <?php echo $color_class; ?>" data-note-id="<?php echo $note['id']; ?>" data-communication-type="<?php echo $communication_type; ?>">
    <div class="note-header">
        <div class="note-icon">
            <i class="fa <?php echo $icon; ?>"></i>
        </div>
        <div class="note-meta">
            <div class="note-author">
                <?php echo staff_profile_image($note['addedfrom'], ['staff-profile-image-xs', 'pull-left', 'mright5']); ?>
                <strong><?php echo get_staff_full_name($note['addedfrom']); ?></strong>
            </div>
            <div class="note-timestamp">
                <small class="text-muted">
                    <i class="fa fa-clock-o mright5"></i><?php echo _dt($note['dateadded']); ?>
                </small>
            </div>
        </div>
        <?php if(has_permission('leads','','delete') || $note['addedfrom'] == get_staff_user_id()) { ?>
        <div class="note-actions">
            <a href="#" class="text-danger note-delete" onclick="delete_lead_note(this, <?php echo $note['id']; ?>, <?php echo isset($lead) ? $lead->id : (isset($_GET['id']) ? $_GET['id'] : 'null'); ?>); return false;" title="Delete Note">
                <i class="fa fa-times"></i>
            </a>
        </div>
        <?php } ?>
    </div>
    <div class="note-content">
        <?php echo process_text_content_for_display($note['description']); ?>
    </div>
    <div class="note-footer">
        <span class="communication-badge badge-<?php echo $communication_type; ?>">
            <i class="fa <?php echo $icon; ?> mright5"></i><?php echo ucfirst($communication_type); ?>
        </span>
    </div>
</div>
<?php } ?>
