<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
  <div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="panel_s">
          <div class="panel-body">
            <h4 class="customer-profile-group-heading"><?= _l('Assign Interested Dealers to Staff'); ?></h4>
            <?php if(isset($message)) echo $message; ?>
            <?php if($this->session->flashdata('alert-success')): ?>
              <div class="alert alert-success"><?= $this->session->flashdata('alert-success'); ?></div>
            <?php endif; ?>
            <form method="post" class="assign-form">
              <?php if(function_exists('render_csrf_field')) { echo render_csrf_field(); } else if(isset($this) && method_exists($this->security, 'get_csrf_token_name')) { ?>
                <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>" />
              <?php } ?>
              <div class="form-group">
                <label for="staff_id">Assign selected to staff:</label>
                <select name="staff_id" id="staff_id" class="form-control" required>
                  <option value="">Select staff</option>
                  <?php foreach ($staff as $s): ?>
                    <option value="<?= $s['staffid']; ?>"><?= htmlspecialchars($s['firstname'] . ' ' . $s['lastname']); ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="table-responsive">
                <table class="table table-bordered">
                  <thead>
                    <tr>
                      <th><input type="checkbox" id="select_all"></th>
                      <th>ID</th>
                      <th>Name</th>
                      <th>Company</th>
                      <th>Email</th>
                      <th>Phone</th>
                      <th>Date Added</th>
                      <th>Assigned Person</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php foreach ($dealers as $dealer): ?>
                      <tr>
                        <td><input type="checkbox" name="dealer_ids[]" value="<?= $dealer['id']; ?>"></td>
                        <td><?= $dealer['id']; ?></td>
                        <td><?= htmlspecialchars($dealer['name']); ?></td>
                        <td><?= htmlspecialchars($dealer['company']); ?></td>
                        <td><?= htmlspecialchars($dealer['email']); ?></td>
                        <td><?= htmlspecialchars($dealer['phonenumber']); ?></td>
                        <td><?= htmlspecialchars($dealer['dateadded']); ?></td>
                        <td>
                          <?php
                            if (!empty($dealer['assigned'])) {
                              $assigned_staff = null;
                              foreach ($staff as $s) {
                                if ($s['staffid'] == $dealer['assigned']) {
                                  $assigned_staff = $s;
                                  break;
                                }
                              }
                              if ($assigned_staff) {
                                echo htmlspecialchars($assigned_staff['firstname'] . ' ' . $assigned_staff['lastname']);
                              } else {
                                echo 'ID: ' . (int)$dealer['assigned'];
                              }
                            } else {
                              echo '<span style="color:#888;">Unassigned</span>';
                            }
                          ?>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  </tbody>
                </table>
              </div>
              <button type="submit" class="btn btn-primary">Assign</button>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<script>
document.getElementById('select_all').addEventListener('change', function() {
  var checkboxes = document.querySelectorAll('input[name="dealer_ids[]"]');
  for (var i = 0; i < checkboxes.length; i++) {
    checkboxes[i].checked = this.checked;
  }
});
</script>
<?php init_tail(); ?>
