<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-8">
                                <h4 class="no-margin">
                                    <i class="fa fa-brain"></i> <?php echo $title; ?>
                                </h4>
                            </div>
                            <div class="col-md-4 text-right">
                                <a href="<?php echo admin_url('ai_reports'); ?>" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> Back to Reports
                                </a>
                                <a href="<?php echo admin_url('leads/index/' . $report->lead_id); ?>" class="btn btn-info">
                                    <i class="fa fa-user"></i> View Lead
                                </a>
                                <?php if (is_admin()): ?>
                                <a href="<?php echo admin_url('ai_reports/delete/' . $report->id); ?>" 
                                   class="btn btn-danger" 
                                   onclick="return confirm('Are you sure you want to delete this report?')">
                                    <i class="fa fa-trash"></i> Delete
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <hr class="hr-panel-heading">
                        
                        <!-- Report Summary -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Analysis Summary</h4>
                                    </div>
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="text-center">
                                                    <h2 class="no-margin text-info"><?php echo $report->confidence_score ?: 0; ?>%</h2>
                                                    <p class="text-muted">Confidence Score</p>
                                                    <div class="progress">
                                                        <?php 
                                                        $score = $report->confidence_score ?: 0;
                                                        $score_class = $score >= 80 ? 'success' : ($score >= 60 ? 'warning' : 'danger');
                                                        ?>
                                                        <div class="progress-bar progress-bar-<?php echo $score_class; ?>" 
                                                             style="width: <?php echo $score; ?>%"></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="text-center">
                                                    <?php 
                                                    $verdict = $report->purchase_likelihood ?: 'Unknown';
                                                    $badge_class = '';
                                                    switch (strtolower($verdict)) {
                                                        case 'hot': $badge_class = 'danger'; break;
                                                        case 'warm': $badge_class = 'warning'; break;
                                                        case 'cold': $badge_class = 'info'; break;
                                                        case 'qualified': $badge_class = 'success'; break;
                                                        default: $badge_class = 'default';
                                                    }
                                                    ?>
                                                    <h3 class="no-margin">
                                                        <span class="label label-<?php echo $badge_class; ?>" style="font-size: 14px;">
                                                            <?php echo $verdict; ?>
                                                        </span>
                                                    </h3>
                                                    <p class="text-muted">Verdict</p>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="text-center">
                                                    <h4 class="no-margin"><?php echo ucfirst(str_replace('_', ' ', $report->analysis_type)); ?></h4>
                                                    <p class="text-muted">Analysis Type</p>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="text-center">
                                                    <h4 class="no-margin"><?php echo _dt($report->created_at); ?></h4>
                                                    <p class="text-muted">Created</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Lead Information -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Lead Information</h4>
                                    </div>
                                    <div class="panel-body">
                                        <table class="table table-bordered">
                                            <tr>
                                                <td><strong>Name:</strong></td>
                                                <td>
                                                    <a href="<?php echo admin_url('leads/index/' . $report->lead_id); ?>">
                                                        <?php echo $report->lead_name ?: 'Unknown'; ?>
                                                    </a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><strong>Company:</strong></td>
                                                <td><?php echo $report->lead_company ?: 'N/A'; ?></td>
                                            </tr>
                                            <tr>
                                                <td><strong>Email:</strong></td>
                                                <td>
                                                    <?php if ($report->lead_email): ?>
                                                        <a href="mailto:<?php echo $report->lead_email; ?>">
                                                            <?php echo $report->lead_email; ?>
                                                        </a>
                                                    <?php else: ?>
                                                        N/A
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><strong>Phone:</strong></td>
                                                <td>
                                                    <?php if ($report->lead_phone): ?>
                                                        <a href="tel:<?php echo $report->lead_phone; ?>">
                                                            <?php echo $report->lead_phone; ?>
                                                        </a>
                                                    <?php else: ?>
                                                        N/A
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><strong>Lead ID:</strong></td>
                                                <td>#<?php echo $report->lead_id; ?></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Report Details</h4>
                                    </div>
                                    <div class="panel-body">
                                        <table class="table table-bordered">
                                            <tr>
                                                <td><strong>Report ID:</strong></td>
                                                <td>#<?php echo $report->id; ?></td>
                                            </tr>
                                            <tr>
                                                <td><strong>Created By:</strong></td>
                                                <td><?php echo $report->created_by_name ?: 'Unknown'; ?></td>
                                            </tr>
                                            <tr>
                                                <td><strong>Status:</strong></td>
                                                <td>
                                                    <span class="label label-<?php echo $report->status == 'completed' ? 'success' : 'warning'; ?>">
                                                        <?php echo ucfirst($report->status); ?>
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><strong>Files Analyzed:</strong></td>
                                                <td><?php echo count($uploaded_files); ?> files</td>
                                            </tr>
                                            <tr>
                                                <td><strong>Created:</strong></td>
                                                <td><?php echo _dt($report->created_at); ?></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Analysis Results -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="panel panel-success">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Key Insights</h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php if (!empty($report->key_insights)): ?>
                                            <div class="well">
                                                <?php echo nl2br(htmlspecialchars($report->key_insights)); ?>
                                            </div>
                                        <?php else: ?>
                                            <p class="text-muted">No insights available</p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="panel panel-warning">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Recommendations</h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php if (!empty($report->recommendations)): ?>
                                            <div class="well">
                                                <?php echo nl2br(htmlspecialchars($report->recommendations)); ?>
                                            </div>
                                        <?php else: ?>
                                            <p class="text-muted">No recommendations available</p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Enhanced Analysis Data -->
                        <?php if (!empty($ai_response_data)): ?>
                        <div class="row">
                            <?php if (isset($ai_response_data['communication_analysis'])): ?>
                            <div class="col-md-6">
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Communication Analysis</h4>
                                    </div>
                                    <div class="panel-body">
                                        <div class="well">
                                            <?php echo nl2br(htmlspecialchars($ai_response_data['communication_analysis'])); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <?php if (isset($ai_response_data['urgency_level'])): ?>
                            <div class="col-md-6">
                                <div class="panel panel-primary">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Urgency Level</h4>
                                    </div>
                                    <div class="panel-body text-center">
                                        <?php 
                                        $urgency = $ai_response_data['urgency_level'];
                                        $urgency_class = strtolower($urgency) == 'high' ? 'danger' : (strtolower($urgency) == 'medium' ? 'warning' : 'info');
                                        ?>
                                        <h3>
                                            <span class="label label-<?php echo $urgency_class; ?>" style="font-size: 16px;">
                                                <?php echo $urgency; ?>
                                            </span>
                                        </h3>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="row">
                            <?php if (isset($ai_response_data['risk_factors']) && is_array($ai_response_data['risk_factors'])): ?>
                            <div class="col-md-6">
                                <div class="panel panel-danger">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Risk Factors</h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php if (!empty($ai_response_data['risk_factors'])): ?>
                                            <ul class="list-unstyled">
                                                <?php foreach ($ai_response_data['risk_factors'] as $risk): ?>
                                                    <li><i class="fa fa-exclamation-triangle text-danger"></i> <?php echo htmlspecialchars($risk); ?></li>
                                                <?php endforeach; ?>
                                            </ul>
                                        <?php else: ?>
                                            <p class="text-muted">No risk factors identified</p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <?php if (isset($ai_response_data['positive_signals']) && is_array($ai_response_data['positive_signals'])): ?>
                            <div class="col-md-6">
                                <div class="panel panel-success">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Positive Signals</h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php if (!empty($ai_response_data['positive_signals'])): ?>
                                            <ul class="list-unstyled">
                                                <?php foreach ($ai_response_data['positive_signals'] as $signal): ?>
                                                    <li><i class="fa fa-check-circle text-success"></i> <?php echo htmlspecialchars($signal); ?></li>
                                                <?php endforeach; ?>
                                            </ul>
                                        <?php else: ?>
                                            <p class="text-muted">No positive signals identified</p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Uploaded Files -->
                        <?php if (!empty($uploaded_files)): ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Analyzed Files</h4>
                                    </div>
                                    <div class="panel-body">
                                        <div class="row">
                                            <?php foreach ($uploaded_files as $file): ?>
                                                <div class="col-md-3">
                                                    <div class="thumbnail text-center">
                                                        <i class="fa fa-file-o fa-3x"></i>
                                                        <div class="caption">
                                                            <p><small><?php echo htmlspecialchars($file); ?></small></p>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Raw AI Response (for debugging - admin only) -->
                        <?php if (is_admin() && !empty($report->ai_response)): ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <a data-toggle="collapse" href="#rawResponseCollapse">
                                                Raw AI Response (Debug)
                                                <span class="pull-right">
                                                    <i class="fa fa-chevron-down"></i>
                                                </span>
                                            </a>
                                        </h4>
                                    </div>
                                    <div id="rawResponseCollapse" class="panel-collapse collapse">
                                        <div class="panel-body">
                                            <pre style="max-height: 300px; overflow-y: auto;"><?php echo htmlspecialchars($report->ai_response); ?></pre>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>

<style>
.progress {
    height: 20px;
}

.label {
    font-size: 12px;
}

.well {
    background-color: #f9f9f9;
    border: 1px solid #e3e3e3;
    border-radius: 4px;
    padding: 19px;
    margin-bottom: 20px;
}

.thumbnail {
    padding: 20px;
}

.panel-title a {
    color: inherit;
    text-decoration: none;
}

.panel-title a:hover {
    text-decoration: none;
}

.list-unstyled li {
    margin-bottom: 8px;
}

.list-unstyled li i {
    margin-right: 8px;
}
</style>
