<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Followup_test extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    public function index()
    {
        echo "<h2>Next Follow-up Date Test</h2>";
        echo "<style>body { font-family: Arial; margin: 20px; } .success { color: green; } .error { color: red; } .info { color: blue; }</style>";
        
        // Check if column exists
        $table_name = db_prefix() . 'lead_notes';
        $query = $this->db->query("SHOW COLUMNS FROM $table_name LIKE 'next_followup_date'");

        if ($query->num_rows() > 0) {
            echo "<p class='success'>✓ next_followup_date column exists in $table_name</p>";
            
            // Test simple query
            $simple_test = $this->db->query("SELECT COUNT(*) as count FROM $table_name WHERE next_followup_date IS NOT NULL");
            $result = $simple_test->row();
            echo "<p class='info'>Records with follow-up dates: " . $result->count . "</p>";
            
            // Test the leads query
            echo "<h3>Testing Leads Query</h3>";
            $leads_query = "SELECT 
                " . db_prefix() . "leads.id, 
                " . db_prefix() . "leads.name,
                (SELECT MIN(next_followup_date) 
                 FROM " . db_prefix() . "lead_notes 
                 WHERE leadid = " . db_prefix() . "leads.id 
                 AND next_followup_date > NOW()) as next_followup_date
            FROM " . db_prefix() . "leads 
            LIMIT 5";
            
            $start_time = microtime(true);
            $test_result = $this->db->query($leads_query);
            $end_time = microtime(true);
            $execution_time = ($end_time - $start_time) * 1000;
            
            if ($test_result) {
                echo "<p class='success'>✓ Query executed successfully in " . round($execution_time, 2) . " ms</p>";
                
                echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
                echo "<tr style='background: #f0f0f0;'><th>Lead ID</th><th>Lead Name</th><th>Next Follow-up Date</th></tr>";
                foreach ($test_result->result() as $row) {
                    echo "<tr>";
                    echo "<td>" . htmlspecialchars($row->id) . "</td>";
                    echo "<td>" . htmlspecialchars($row->name) . "</td>";
                    echo "<td>" . htmlspecialchars($row->next_followup_date ?: 'No follow-up scheduled') . "</td>";
                    echo "</tr>";
                }
                echo "</table>";
                
                // Insert a test follow-up note if no data exists
                if ($result->count == 0) {
                    echo "<h3>Adding Test Data</h3>";
                    $first_lead = $test_result->row();
                    if ($first_lead) {
                        $future_date = date('Y-m-d H:i:s', strtotime('+7 days'));
                        $insert_data = [
                            'leadid' => $first_lead->id,
                            'description' => 'Test follow-up note - ' . date('Y-m-d H:i:s'),
                            'next_followup_date' => $future_date,
                            'addedfrom' => 1,
                            'dateadded' => date('Y-m-d H:i:s')
                        ];
                        
                        if ($this->db->insert(db_prefix() . 'lead_notes', $insert_data)) {
                            echo "<p class='success'>✓ Test follow-up note added for lead ID " . $first_lead->id . " with date: $future_date</p>";
                        } else {
                            echo "<p class='error'>✗ Failed to add test note</p>";
                        }
                    }
                }
                
            } else {
                echo "<p class='error'>✗ Query failed</p>";
            }
            
        } else {
            echo "<p class='error'>✗ next_followup_date column does not exist!</p>";
        }

        echo "<h3>Database Info</h3>";
        echo "<p>Database Prefix: " . db_prefix() . "</p>";
        echo "<p>Leads table: " . db_prefix() . "leads</p>";
        echo "<p>Lead notes table: " . db_prefix() . "lead_notes</p>";

        $leads_count = $this->db->count_all(db_prefix() . 'leads');
        $notes_count = $this->db->count_all(db_prefix() . 'lead_notes');
        echo "<p>Total leads: $leads_count</p>";
        echo "<p>Total lead notes: $notes_count</p>";
        
        echo "<hr>";
        echo "<p><a href='" . admin_url('leads') . "'>← Back to Leads Dashboard</a></p>";
        echo "<p><a href='" . admin_url('followup_test') . "'>🔄 Refresh Test</a></p>";
    }
}
?>
